/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.crypto;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import openwfe.org.crypto.CryptoException;
import org.jdom.Content;
import org.jdom.Element;

public class RsaKey
implements Serializable {
    static final long serialVersionUID = -2578029002953409978L;
    public static final String PUBLIC = "public";
    public static final String PRIVATE = "private";
    public static final String PUBLIC_KEY = "public-key";
    public static final String PRIVATE_KEY = "private-key";
    public static final String EXP = "exp";
    public static final String MOD = "mod";
    protected String keyType = null;
    protected String exp = null;
    protected String mod = null;

    public RsaKey() {
    }

    public RsaKey(String string, String string2, String string3) {
        this.keyType = string;
        this.exp = string2;
        this.mod = string3;
    }

    public RsaKey(RSAKey rSAKey) throws CryptoException {
        this.mod = rSAKey.getModulus().toString();
        if (rSAKey instanceof RSAPublicKey) {
            this.keyType = PUBLIC;
            this.exp = ((RSAPublicKey)rSAKey).getPublicExponent().toString();
        } else if (rSAKey instanceof RSAPrivateKey) {
            this.keyType = PRIVATE;
            this.exp = ((RSAPrivateKey)rSAKey).getPrivateExponent().toString();
        } else {
            throw new CryptoException("Cannot create RsaKey from key of class '" + rSAKey.getClass().getName() + "'");
        }
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String getMod() {
        return this.mod;
    }

    public String getExp() {
        return this.exp;
    }

    public void setKeyType(String string) {
        this.keyType = string;
    }

    public void setMod(String string) {
        this.mod = string;
    }

    public void setExp(String string) {
        this.exp = string;
    }

    public RSAKey assembleRealKey() throws CryptoException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            if (this.keyType.equals(PUBLIC)) {
                RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger(this.mod), new BigInteger(this.exp));
                return (RSAKey)((Object)keyFactory.generatePublic(rSAPublicKeySpec));
            }
            RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(new BigInteger(this.mod), new BigInteger(this.exp));
            return (RSAKey)((Object)keyFactory.generatePrivate(rSAPrivateKeySpec));
        }
        catch (Exception exception) {
            throw new CryptoException("Failed to assemble real RSAKey", exception);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.keyType.equals(PUBLIC)) {
            stringBuffer.append("<public-key>\n");
        } else {
            stringBuffer.append("<private-key>\n");
        }
        stringBuffer.append("    <exp>");
        stringBuffer.append(this.exp);
        stringBuffer.append("</exp>\n");
        stringBuffer.append("    <mod>");
        stringBuffer.append(this.mod);
        stringBuffer.append("</mod>\n");
        if (this.keyType.equals(PUBLIC)) {
            stringBuffer.append("</public-key>\n");
        } else {
            stringBuffer.append("</private-key>\n");
        }
        return stringBuffer.toString();
    }

    public Element toXml() {
        Element element = null;
        element = this.keyType.equals(PUBLIC) ? new Element(PUBLIC_KEY) : new Element(PRIVATE_KEY);
        Element element2 = new Element(EXP);
        element2.addContent(this.exp);
        element.addContent((Content)element2);
        Element element3 = new Element(MOD);
        element3.addContent(this.mod);
        element.addContent((Content)element3);
        return element;
    }

    public static RsaKey buildKey(Element element) {
        if (element == null) {
            return null;
        }
        String string = element.getName();
        String string2 = PRIVATE;
        if (string.equals(PUBLIC_KEY)) {
            string2 = PUBLIC;
        }
        String string3 = element.getChildTextTrim(EXP);
        String string4 = element.getChildTextTrim(MOD);
        return new RsaKey(string2, string3, string4);
    }

    public static RsaKey[] generateKeyPair(int n) throws CryptoException {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(n);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            RsaKey[] rsaKeyArray = new RsaKey[]{new RsaKey((RSAKey)((Object)keyPair.getPublic())), new RsaKey((RSAKey)((Object)keyPair.getPrivate()))};
            return rsaKeyArray;
        }
        catch (Exception exception) {
            throw new CryptoException("Failed to generate key pair", exception);
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("Generating key pair...");
            RsaKey[] rsaKeyArray = RsaKey.generateKeyPair(2048);
            System.out.println(rsaKeyArray[0].toString());
            System.out.println(rsaKeyArray[1].toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

