/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.ldap;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import openwfe.org.AbstractService;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import org.apache.log4j.Logger;

public class LdapService
extends AbstractService {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$ldap$LdapService == null ? (class$openwfe$org$ldap$LdapService = LdapService.class$("openwfe.org.ldap.LdapService")) : class$openwfe$org$ldap$LdapService).getName());
    public static final String P_HOST = "host";
    public static final String P_PORT = "port";
    public static final String P_AUTH_METHOD = "authentication-method";
    public static final String P_INITIAL_CONTEXT_FACTORY = "initial-context-factory";
    public static final String P_USER_BASE = "user-base";
    public static final String P_USER_ATTRIBUTE = "user-attribute";
    public static final String P_USER_OBJCLASS = "user-objclass";
    public static final String P_GROUP_BASE = "group-base";
    public static final String P_GROUP_ATTRIBUTE = "group-attribute";
    public static final String P_GROUP_OBJCLASS = "group-objclass";
    public static final String P_TRUNCATE_SUFFIX = "truncate-suffix";
    private Properties m_envProps;
    private String m_host;
    private String m_port;
    private String m_authenticationMethod;
    private String m_userBase;
    private String m_userAttr;
    private String m_userObjClass;
    private String m_groupBase;
    private String m_groupAttr;
    private String m_groupObjClass;
    private String m_truncateSuffix;
    private InitialDirContext m_dirCtx;
    static /* synthetic */ Class class$openwfe$org$ldap$LdapService;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        log.info((Object)"LdapService init()");
        super.init(string, applicationContext, map);
        this.m_host = (String)map.get(P_HOST);
        this.m_port = (String)map.get(P_PORT);
        this.m_authenticationMethod = (String)map.get(P_AUTH_METHOD);
        this.m_envProps = new Properties();
        this.m_envProps.put("java.naming.factory.initial", MapUtils.getAsString(map, P_INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory"));
        this.m_envProps.put("java.naming.provider.url", "ldap://" + this.m_host + ":" + this.m_port);
        this.m_envProps.put("java.naming.security.authentication", this.m_authenticationMethod);
        this.m_userBase = (String)map.get(P_USER_BASE);
        this.m_userAttr = (String)map.get(P_USER_ATTRIBUTE);
        this.m_userObjClass = (String)map.get(P_USER_OBJCLASS);
        this.m_groupBase = (String)map.get(P_GROUP_BASE);
        this.m_groupAttr = (String)map.get(P_GROUP_ATTRIBUTE);
        this.m_groupObjClass = (String)map.get(P_GROUP_OBJCLASS);
        this.m_truncateSuffix = (String)map.get(P_TRUNCATE_SUFFIX);
        if (log.isInfoEnabled()) {
            log.info((Object)("Using " + this.m_host + ":" + this.m_port + " for ldap."));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("User base: " + this.m_userBase));
            log.debug((Object)("User attr: " + this.m_userAttr));
            log.debug((Object)("User objclass: " + this.m_userObjClass));
            log.debug((Object)("Group base: " + this.m_groupBase));
            log.debug((Object)("Group attr: " + this.m_groupAttr));
            log.debug((Object)("Group objclass: " + this.m_groupObjClass));
            log.debug((Object)("Strip suffix: " + this.m_truncateSuffix));
        }
        try {
            this.m_dirCtx = new InitialDirContext(this.m_envProps);
        }
        catch (NamingException namingException) {
            throw new ServiceException(namingException.getMessage(), namingException);
        }
    }

    private String stripSuffix(String string) {
        if (this.m_truncateSuffix == null) {
            return string;
        }
        if (string.endsWith(this.m_truncateSuffix)) {
            return string.substring(0, string.length() - this.m_truncateSuffix.length());
        }
        return string;
    }

    public String getLdapUid(Principal principal) {
        return this.stripSuffix(this.m_userAttr + "=" + principal.getName() + "," + this.m_userBase);
    }

    public String[] getGroups(Principal principal) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        String string = this.getLdapUid(principal);
        int n = string.indexOf(",");
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("=")) != -1) {
            string = string.substring(n + 1);
        }
        NamingEnumeration<SearchResult> namingEnumeration = this.m_dirCtx.search(this.m_groupBase, "memberUid=" + string, searchControls);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
            SearchResult searchResult = namingEnumeration.next();
            arrayList.add(this.stripSuffix(searchResult.getName() + "," + this.m_groupBase));
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getGroups() throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        NamingEnumeration<SearchResult> namingEnumeration = this.m_groupObjClass != null && !"".equals(this.m_groupObjClass) ? this.m_dirCtx.search(this.m_groupBase, "(&(objectClass=" + this.m_groupObjClass + ")(" + this.m_groupAttr + "=*))", searchControls) : this.m_dirCtx.search(this.m_groupBase, this.m_groupAttr + "=*", searchControls);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
            SearchResult searchResult = namingEnumeration.next();
            arrayList.add(this.stripSuffix(searchResult.getName() + "," + this.m_groupBase));
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getUsers() throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        NamingEnumeration<SearchResult> namingEnumeration = this.m_userObjClass != null && !"".equals(this.m_userObjClass) ? this.m_dirCtx.search(this.m_userBase, "(&(objectClass=" + this.m_userObjClass + ")(" + this.m_userAttr + "=*))", searchControls) : this.m_dirCtx.search(this.m_userBase, this.m_userAttr + "=*", searchControls);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
            SearchResult searchResult = namingEnumeration.next();
            arrayList.add(this.stripSuffix(searchResult.getName() + "," + this.m_userBase));
        }
        return arrayList.toArray(new String[0]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

