/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.misc;

import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import openwfe.org.misc.ByteException;

public abstract class ByteUtils {
    public static byte[] objectToByteArray(Object object) throws ByteException {
        return ByteUtils.objectsToByteArray(new Object[]{object});
    }

    public static byte[] objectsToByteArray(Object[] objectArray) throws ByteException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLEncoder xMLEncoder = new XMLEncoder(byteArrayOutputStream);
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) continue;
                xMLEncoder.writeObject(objectArray[i]);
                xMLEncoder.flush();
            }
        }
        catch (Throwable throwable) {
            throw new ByteException("Failed to encode objects", throwable);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String toString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] >= 0) {
                stringBuffer.append('+');
            }
            stringBuffer.append(byArray[i]);
        }
        return stringBuffer.toString();
    }

    public static int toByte(String string) {
        if (string.charAt(0) == '+') {
            string = string.substring(1);
        }
        return Integer.parseInt(string);
    }

    public static byte[] fromString(String string) throws NumberFormatException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string2 = "" + string.charAt(0);
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '+' || c == '-') {
                byteArrayOutputStream.write(ByteUtils.toByte(string2));
                string2 = "" + c;
                continue;
            }
            string2 = string2 + c;
        }
        byteArrayOutputStream.write(ByteUtils.toByte(string2));
        return byteArrayOutputStream.toByteArray();
    }
}

