/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.misc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;

public class Wget {
    public static final int READ_BUFFER_SIZE = 2048;
    public static final String BANNER = "OpenWFE Wget 0.0.5 - simple java wget";
    public static final int MAX_RETRIES = 42;
    static /* synthetic */ Class class$openwfe$org$misc$Wget;

    public static boolean wget(String string, String string2) throws Exception {
        return Wget.wget(string, string2, false, false);
    }

    public static boolean wget(String string, String string2, boolean bl, boolean bl2) throws Exception {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        int n = string2.lastIndexOf("/");
        String string3 = string2.substring(n + 1);
        string3 = string + string3;
        File file = new File(string3);
        URL uRL = new URL(string2);
        URLConnection uRLConnection = uRL.openConnection();
        if (bl && file.exists() && bl2) {
            System.out.println("..wget() local   " + file.lastModified());
            System.out.println("..wget() remote  " + uRLConnection.getLastModified());
        }
        if (bl && file.exists() && file.lastModified() >= uRLConnection.getLastModified()) {
            if (bl2) {
                System.out.println("..wget() local file fresher than web version. Not downloading.");
            }
            return false;
        }
        if (bl2) {
            System.out.println("..wget() will save to " + string3);
        }
        int n2 = uRLConnection.getContentLength();
        if (bl2) {
            System.out.println("..wget() contentLength is " + n2);
        }
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        InputStream inputStream = uRL.openStream();
        FileOutputStream fileOutputStream = new FileOutputStream(string3);
        byte[] byArray = new byte[2048];
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5 = inputStream.read(byArray);
            n3 += n5;
            if (bl2) {
                System.out.println("..wget() read " + n5 + " bytes   (" + n3 + "/" + n2 + ") r" + n4);
            }
            if (n5 > 0) {
                fileOutputStream.write(byArray, 0, n5);
                fileOutputStream.flush();
                n4 = 0;
            }
            if (n3 >= n2) break;
            if (n5 >= 2048) continue;
            if (n4 >= 42) {
                if (!bl2) break;
                System.out.println("..wget() giving up.");
                break;
            }
            if (n5 >= 1) continue;
            Thread.yield();
            ++n4;
        }
        fileOutputStream.close();
        inputStream.close();
        return true;
    }

    private static void mkdir(String string, boolean bl) throws Exception {
        File file = new File(string);
        if (file.exists() && !file.isDirectory()) {
            throw new IllegalArgumentException("dir '" + string + "' already exists and it's not a directory.");
        }
        if (file.exists()) {
            if (bl) {
                System.out.println("..wget() dir '" + string + "' already present");
            }
            return;
        }
        file.mkdirs();
        if (bl) {
            System.out.println("..wget() made dir '" + string + "'");
        }
    }

    public static void downloadList(String string, boolean bl, boolean bl2) throws Exception {
        String string2;
        if (string.indexOf("://") < 0) {
            string = "file:" + string;
        }
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string3 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            boolean bl3;
            if ((string2 = string2.trim()).length() < 1 || string2.startsWith("#")) continue;
            if (string2.startsWith("mkdir ")) {
                Wget.mkdir(string2.substring(6).trim(), bl2);
                continue;
            }
            if (string2.startsWith("server")) {
                string3 = string2.trim().length() == 6 ? null : string2.substring(7).trim();
                if (string3 == null || string3.endsWith("/")) continue;
                string3 = string3 + "/";
                continue;
            }
            int n = string2.indexOf(" ");
            String string4 = ".";
            String string5 = string2;
            if (n > -1) {
                string4 = string2.substring(0, n).trim();
                string5 = string2.substring(n + 1).trim();
            }
            if (string3 != null && string5.indexOf("://") < 1) {
                string5 = string3 + string5;
            }
            if (bl2) {
                System.out.println("..wget() todir >" + string4 + "<  fromURL >" + string5 + "<");
            }
            if (bl3 = Wget.wget(string4, string5, bl, bl2)) {
                System.out.println("x " + string5);
                continue;
            }
            System.out.println(". " + string5);
        }
    }

    private static void printUsage() {
        String string = "java " + (class$openwfe$org$misc$Wget == null ? (class$openwfe$org$misc$Wget = Wget.class$("openwfe.org.misc.Wget")) : class$openwfe$org$misc$Wget).getName();
        System.out.println();
        System.out.println(BANNER);
        System.out.println();
        System.out.println("USAGE :");
        System.out.println();
        System.out.print(string);
        System.out.println(" [-d {downloadDir}] [-v] [-H] {URL}*");
        System.out.println(" [-v] [-H] -l {URL of a download list}");
        System.out.println();
        System.out.println("Wget is a java 'wget', with not much features.");
        System.out.println();
        System.out.println("  -v : verbose");
        System.out.println("  -h : prints this usage and exits");
        System.out.println("  -H : HEAD, will not download if local resource fresher than web resource");
        System.out.println("  -l : the files and their target dir are enumerated in a list");
        System.out.println("       (behind a URL or within a local file)");
        System.out.println();
        System.exit(-1);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            Wget.printUsage();
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        String string = ".";
        String string2 = null;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            if (stringArray[n].equals("-d")) {
                if (stringArray.length - n < 2) {
                    Wget.printUsage();
                }
                string = stringArray[n + 1];
                n += 2;
                continue;
            }
            if (stringArray[n].equals("-v")) {
                bl2 = true;
                ++n;
                continue;
            }
            if (stringArray[n].equals("-H")) {
                bl = true;
                ++n;
                continue;
            }
            if (stringArray[n].equals("-h")) {
                Wget.printUsage();
                continue;
            }
            if (!stringArray[n].equals("-l")) continue;
            string2 = stringArray[n + 1];
            n += 2;
        }
        if (string2 != null) {
            System.out.println("...downloadList is at " + string2);
            Wget.downloadList(string2, bl, bl2);
            System.exit(0);
        }
        for (int i = n; i < stringArray.length; ++i) {
            Wget.wget(string, stringArray[i], bl, bl2);
            System.out.println("...got " + stringArray[i]);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

