/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.log4j.Logger;

public class ChannelInputStream
extends InputStream {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$net$ChannelInputStream == null ? (class$openwfe$org$net$ChannelInputStream = ChannelInputStream.class$("openwfe.org.net.ChannelInputStream")) : class$openwfe$org$net$ChannelInputStream).getName());
    public static final String P_DEBUG = (class$openwfe$org$net$ChannelInputStream == null ? (class$openwfe$org$net$ChannelInputStream = ChannelInputStream.class$("openwfe.org.net.ChannelInputStream")) : class$openwfe$org$net$ChannelInputStream).getName() + ".debug";
    private static final boolean DEBUG = System.getProperty(P_DEBUG) != null && System.getProperty(P_DEBUG).toLowerCase().equals("true");
    private ReadableByteChannel channel = null;
    private int bytesRead = 0;
    private int bytesToRead = -1;
    private int maxAttempt = 10;
    private int residualByte = -1;
    static /* synthetic */ Class class$openwfe$org$net$ChannelInputStream;

    public ChannelInputStream(ReadableByteChannel readableByteChannel) {
        this.channel = readableByteChannel;
    }

    public ChannelInputStream(ReadableByteChannel readableByteChannel, int n) {
        this.channel = readableByteChannel;
        this.bytesToRead = n;
    }

    public ChannelInputStream(ReadableByteChannel readableByteChannel, int n, int n2) {
        this.channel = readableByteChannel;
        this.bytesToRead = n;
        this.maxAttempt = n2;
    }

    public void setMaxAttempt(int n) {
        this.maxAttempt = n;
    }

    public void setBytesToRead(int n) {
        this.bytesToRead = this.bytesRead + n;
    }

    public int read() throws IOException {
        byte[] byArray;
        int n;
        if (DEBUG) {
            log.info((Object)"read()");
        }
        if ((n = this.read(0, byArray = new byte[1], 0, 1)) < 1) {
            return n;
        }
        return byArray[0];
    }

    public int read(byte[] byArray) throws IOException {
        if (DEBUG) {
            log.info((Object)"read(ba)");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n = this.channel.read(byteBuffer);
        this.bytesRead += n;
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (DEBUG) {
            log.info((Object)("read(ba, o, l) : (ba, " + n + ", " + n2 + ")"));
        }
        return this.read(0, byArray, n, n2);
    }

    private int read(int n, byte[] byArray, int n2, int n3) throws IOException {
        if (DEBUG) {
            log.info((Object)("read(a, ba, o, l) btr : " + this.bytesToRead + " / br : " + this.bytesRead));
        }
        if (DEBUG) {
            log.info((Object)("read(a, ba, o, l) : (" + n + ", ba, " + n2 + ", " + n3 + ")"));
        }
        if (n > this.maxAttempt) {
            return -1;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
        int n4 = this.channel.read(byteBuffer);
        if (DEBUG) {
            log.info((Object)("read(a, ba, o, l) (" + n + ") readCount : " + n4));
        }
        if (n4 == 0) {
            if (this.bytesToRead > 0 && this.bytesRead >= this.bytesToRead) {
                log.debug((Object)"read(a, ba, o, l) done.");
                return -1;
            }
            if (n % 5 == 4) {
                try {
                    Thread.sleep(28L);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                Thread.yield();
            }
            return this.read(n + 1, byArray, n2, n3);
        }
        this.bytesRead += n4;
        return n4;
    }

    public void close() throws IOException {
    }

    public static BufferedReader newBufferedReader(ReadableByteChannel readableByteChannel, String string) throws UnsupportedEncodingException {
        return new BufferedReader(ChannelInputStream.newInputStreamReader(readableByteChannel, string));
    }

    public static InputStreamReader newInputStreamReader(ReadableByteChannel readableByteChannel, String string) throws UnsupportedEncodingException {
        return new InputStreamReader((InputStream)new ChannelInputStream(readableByteChannel), string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        log.info((Object)(")( emit extra debug info ? " + DEBUG));
    }
}

