/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.rest;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimerTask;
import openwfe.org.Application;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.Utils;
import openwfe.org.misc.Base64;
import openwfe.org.misc.IoUtils;
import openwfe.org.net.NetUtils;
import openwfe.org.net.SocketService;
import openwfe.org.rest.RestSession;
import openwfe.org.rest.RestUtils;
import openwfe.org.time.Time;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class RestService
extends SocketService {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$rest$RestService == null ? (class$openwfe$org$rest$RestService = RestService.class$("openwfe.org.rest.RestService")) : class$openwfe$org$rest$RestService).getName());
    public static final int DEFAULT_PORT = 6080;
    public static final String P_SERVER_NAME = "serverName";
    public static final String P_REST_SESSION_CLASS = "restSessionClass";
    public static final String P_PURGE_FREQUENCY = "purgeFrequency";
    public static final String P_SESSION_TIMEOUT = "sessionTimeout";
    protected static final String DEFAULT_SERVER_NAME = "$Id: RestService.java 2713 2006-06-01 14:38:45Z jmettraux $";
    protected static final long DEFAULT_PURGE_FREQUENCY = Time.parseTimeString("2m");
    protected static final long DEFAULT_SESSION_TIMEOUT = Time.parseTimeString("10m");
    private static final String K_CONTENT_LENGTH = "Content-length";
    private Map unmodifiableServiceParams = null;
    private String serverName = null;
    private String restSessionClassName = null;
    private Map sessions = new HashMap();
    private TimerTask timeOutTask = null;
    private Long lastGivenId = new Long(-1L);
    static /* synthetic */ Class class$openwfe$org$rest$RestService;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        this.setDefaultPort(6080);
        super.init(string, applicationContext, map);
        this.unmodifiableServiceParams = Collections.unmodifiableMap(map);
        this.serverName = MapUtils.getAsString(map, P_SERVER_NAME, DEFAULT_SERVER_NAME);
        this.restSessionClassName = MapUtils.getAsString(map, P_REST_SESSION_CLASS);
        try {
            Class<?> clazz = Class.forName(this.restSessionClassName);
            RestSession restSession = (RestSession)clazz.newInstance();
        }
        catch (Throwable throwable) {
            throw new ServiceException("Cannot use RestSession of class " + this.restSessionClassName, throwable);
        }
        long l = MapUtils.getAsLong(map, P_SESSION_TIMEOUT, DEFAULT_SESSION_TIMEOUT);
        long l2 = MapUtils.getAsLong(map, P_PURGE_FREQUENCY, DEFAULT_PURGE_FREQUENCY);
        log.info((Object)("Session timeout set to " + l + " ms"));
        log.info((Object)("Purge frequency set to " + l2 + " ms"));
        final long l3 = l;
        this.timeOutTask = new TimerTask(){

            public void run() {
                RestService.this.timeOutSessions(l3);
            }
        };
        Application.getTimer().schedule(this.timeOutTask, 15L, l2);
        log.info((Object)("Service '" + this.getName() + "' ready."));
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getRestSessionClassName() {
        return this.restSessionClassName;
    }

    public Element getStatus() {
        Element element = new Element(this.getName());
        element.addContent((Content)XmlUtils.getClassElt(this));
        element.addContent((Content)XmlUtils.getRevisionElt(DEFAULT_SERVER_NAME));
        return element;
    }

    private String[] extractHeaders(SocketChannel socketChannel) throws IOException {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>(10);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while ((n = IoUtils.read(socketChannel)) != -1) {
            if (n == 0) {
                if (n2 >= 3) {
                    arrayList.add(stringBuffer.toString());
                    break;
                }
                ++n2;
                Thread.yield();
                continue;
            }
            n2 = 0;
            char c = (char)n;
            if (c == '\r') continue;
            if (c == '\n') {
                String string = stringBuffer.toString().trim();
                if (string.length() < 1) break;
                arrayList.add(string);
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append(c);
        }
        return Utils.toStringArray(arrayList);
    }

    public void handle(SelectionKey selectionKey) throws ServiceException {
        try {
            String[] stringArray;
            String string;
            SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
            if (log.isDebugEnabled()) {
                log.debug((Object)("handle() incoming connection from " + socketChannel.socket().getInetAddress()));
            }
            if (!this.verify(selectionKey, string = (stringArray = this.extractHeaders(socketChannel))[0])) {
                return;
            }
            Long l = RestService.extractSessionId(string);
            if (l == null) {
                this.authenticate(selectionKey, stringArray);
                return;
            }
            RestSession restSession = (RestSession)this.sessions.get(l);
            if (restSession == null) {
                NetUtils.httpReply(selectionKey, 404, "No such session", this.serverName, null, "text/plain", null);
                return;
            }
            restSession.handle(selectionKey, stringArray);
        }
        catch (Throwable throwable) {
            throw new ServiceException("Socket handling failed", throwable);
        }
    }

    public void stop() throws ServiceException {
        this.timeOutTask.cancel();
        log.info((Object)"timeout system for rest sessions stopped.");
        super.stop();
    }

    private void authenticate(SelectionKey selectionKey, String[] stringArray) {
        Throwable throwable = null;
        String string = RestService.extractHeaderValue(stringArray, "Authorization");
        if (string != null) {
            if (!string.toLowerCase().startsWith("basic")) {
                NetUtils.httpReply(selectionKey, 401, "Unauthorized: only 'BASIC' authentication supported", this.serverName, null, "text/plain", null);
                return;
            }
            int n = string.indexOf(" ");
            string = string.substring(n + 1);
            string = new String(Base64.decode(string.getBytes()));
            String[] stringArray2 = string.split(":");
            try {
                Long l = this.generateNewSessionId();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("authenticate() new sessionId : " + l));
                }
                RestSession restSession = this.newRestSession(l, stringArray2[0], stringArray2[1]);
                stringArray2 = null;
                this.sessions.put(l, restSession);
                Element element = new Element("session");
                element.setAttribute("id", "" + l);
                log.debug((Object)"authenticate() 200 Authorized");
                NetUtils.httpReply(selectionKey, 200, "OK", this.serverName, null, "text/xml", element);
                return;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                log.debug((Object)"authenticate() failed.", throwable2);
            }
        }
        log.debug((Object)"authenticate() 401 Unauthorized");
        NetUtils.httpReply(selectionKey, 401, "Unauthorized", this.serverName, new String[]{"WWW-Authenticate: BASIC realm=\"" + this.serverName + "\""}, "text/plain", throwable);
    }

    protected RestSession newRestSession(Long l, String string, String string2) throws Exception {
        Class<?> clazz = Class.forName(this.restSessionClassName);
        RestSession restSession = (RestSession)clazz.newInstance();
        restSession.init(this, l, string, string2);
        log.debug((Object)"newRestSession() ok.");
        return restSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long generateNewSessionId() {
        Long l = this.lastGivenId;
        synchronized (l) {
            long l2;
            for (l2 = System.currentTimeMillis(); l2 <= this.lastGivenId; ++l2) {
            }
            this.lastGivenId = new Long(l2);
            return this.lastGivenId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeOutSessions(long l) {
        log.debug((Object)"timeOutSessions() session cleaner waking up");
        long l2 = System.currentTimeMillis();
        Map map = this.sessions;
        synchronized (map) {
            ArrayList<Long> arrayList = new ArrayList<Long>(this.sessions.size());
            Iterator<Object> iterator = this.sessions.keySet().iterator();
            while (iterator.hasNext()) {
                Long l3 = (Long)iterator.next();
                RestSession restSession = (RestSession)this.sessions.get(l3);
                long l4 = l2 - restSession.getLastUsed();
                if (l4 <= l) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("timeOutSessions() Removing session " + l3));
                }
                arrayList.add(l3);
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.sessions.remove(iterator.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(Long l) {
        Map map = this.sessions;
        synchronized (map) {
            this.sessions.remove(l);
        }
    }

    protected static Long extractSessionId(String string) throws IOException {
        try {
            String string2 = RestUtils.extractFromLine(string, "session");
            if (log.isDebugEnabled()) {
                log.debug((Object)("extractSessionId() sessionId = \"" + string2 + "\""));
            }
            return new Long(Long.parseLong(string2));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String extractHeaderValue(String[] stringArray, String string) {
        String string2 = string.toLowerCase() + ": ";
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (!string3.toLowerCase().startsWith(string2)) continue;
            return string3.substring(string.length() + 2);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("extractHeaderValue() didn't find value for key '" + string + "'"));
        }
        return null;
    }

    private static String print(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("'");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("'");
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private boolean verify(SelectionKey selectionKey, String string) {
        String[] stringArray = string.split(" ");
        if (log.isDebugEnabled()) {
            log.debug((Object)("verify() ss is " + RestService.print(stringArray)));
        }
        if (stringArray.length < 3) {
            NetUtils.httpReply(selectionKey, 400, "Bad request", this.serverName, null, "text/plain", "Incomplete HTTP request");
            return false;
        }
        String string2 = stringArray[0].toUpperCase();
        if (!string2.equals("GET") && !string2.equals("POST")) {
            NetUtils.httpReply(selectionKey, 405, "Method Not Allowed", this.serverName, null, "text/plain", "Method '" + string2 + "' not allowed.");
            return false;
        }
        if (!stringArray[1].startsWith("/" + this.serverName)) {
            NetUtils.httpReply(selectionKey, 404, "Not Found", this.serverName, null, "text/plain", "Object >" + stringArray[1] + "< not found.");
            return false;
        }
        if (!stringArray[2].startsWith("HTTP/")) {
            NetUtils.httpReply(selectionKey, 505, "HTTP Version not supported", this.serverName, null, "text/plain", "HTTP Version >" + stringArray[2] + "< not supported.");
            return false;
        }
        return true;
    }

    public static int extractNumericHeaderValue(String[] stringArray, String string) {
        String string2 = RestService.extractHeaderValue(stringArray, string);
        try {
            return Integer.parseInt(string2);
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public static int determineBytesToRead(String[] stringArray) {
        return RestService.extractNumericHeaderValue(stringArray, K_CONTENT_LENGTH);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

