/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.rest;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.ExceptionUtils;
import openwfe.org.ServiceException;
import openwfe.org.net.ChannelInputStream;
import openwfe.org.net.NetUtils;
import openwfe.org.rest.HttpException;
import openwfe.org.rest.RestService;
import openwfe.org.rest.RestUtils;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public abstract class RestSession {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$rest$RestSession == null ? (class$openwfe$org$rest$RestSession = RestSession.class$("openwfe.org.rest.RestSession")) : class$openwfe$org$rest$RestSession).getName());
    public static final String ACTION_END_WORK_SESSION = "endworksession";
    private RestService service = null;
    private ApplicationContext applicationContext = null;
    private Map serviceParams = null;
    private Long sessionId = null;
    private long lastUsed = -1L;
    static /* synthetic */ Class class$openwfe$org$rest$RestSession;
    static /* synthetic */ Class class$java$nio$channels$SelectionKey;
    static /* synthetic */ Class array$Ljava$lang$String;

    public void init(RestService restService, Long l, String string, String string2) throws ServiceException {
        this.service = restService;
        this.sessionId = l;
        this.touch();
        this.authentify(string, string2);
    }

    public RestService getService() {
        return this.service;
    }

    protected abstract boolean authentify(String var1, String var2) throws ServiceException;

    protected boolean evalRequest(String string, SelectionKey selectionKey, String[] stringArray) throws Exception {
        String string2 = "do_" + string.toLowerCase();
        Method method = this.getClass().getMethod(string2, class$java$nio$channels$SelectionKey == null ? (class$java$nio$channels$SelectionKey = RestSession.class$("java.nio.channels.SelectionKey")) : class$java$nio$channels$SelectionKey, array$Ljava$lang$String == null ? (array$Ljava$lang$String = RestSession.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        Object object = method.invoke((Object)this, selectionKey, stringArray);
        if (object == null) {
            return true;
        }
        return (Boolean)object;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public void handle(SelectionKey selectionKey, String[] stringArray) {
        this.touch();
        String string = stringArray[0];
        String string2 = null;
        IOException iOException = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("handle() firstLine is >" + string + "<"));
            }
            string2 = RestUtils.extractFromLine(string, "action");
        }
        catch (IOException iOException2) {
            log.info((Object)"Failed to parse 'action' from http request", (Throwable)iOException2);
            iOException = iOException2;
        }
        if (string2 == null) {
            Object object = iOException;
            if (object == null) {
                object = "No specific action requested";
            }
            NetUtils.httpReply(selectionKey, 400, "Bad Request", this.service.getServerName(), null, "text/plain", object);
            return;
        }
        if ((string2 = string2.toLowerCase()).equals(ACTION_END_WORK_SESSION)) {
            if (this.service != null) {
                this.service.removeSession(this.sessionId);
            }
            log.info((Object)("Session " + this.sessionId + " ended."));
            NetUtils.httpReply(selectionKey, 200, "OK", this.service.getServerName(), null, "text/xml", new Element("bye"));
            return;
        }
        try {
            try {
                if (this.evalRequest(string2, selectionKey, stringArray)) {
                    return;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }
        catch (MalformedURLException malformedURLException) {
            log.info((Object)"Malformed URL Exception : ", (Throwable)malformedURLException);
            NetUtils.httpReply(selectionKey, 400, "Bad Request", this.service.getServerName(), null, "text/plain", malformedURLException);
            return;
        }
        catch (HttpException httpException) {
            log.info((Object)"HTTP error : ", (Throwable)httpException);
            NetUtils.httpReply(selectionKey, httpException.getErrorCode(), httpException.getMessage(), this.service.getServerName(), null, "text/plain", httpException);
            return;
        }
        catch (Throwable throwable) {
            log.info((Object)"Internal Server error : ", throwable);
            Throwable throwable2 = ExceptionUtils.getRootCause(throwable);
            NetUtils.httpReply(selectionKey, 500, throwable2.toString() + " : " + throwable2.getMessage(), this.service.getServerName(), null, "text/plain", throwable);
            return;
        }
        NetUtils.httpReply(selectionKey, 400, "Bad Request", this.service.getServerName(), null, "text/plain", "Action '" + string2 + "' has no implementation.");
    }

    public void touch() {
        this.lastUsed = System.currentTimeMillis();
    }

    protected void reply(SelectionKey selectionKey, Element element) {
        NetUtils.httpReply(selectionKey, 200, "OK", this.service.getServerName(), null, "text/xml", element);
    }

    public static String printSessions(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n[\n ");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Long l = (Long)iterator.next();
            RestSession restSession = (RestSession)map.get(l);
            stringBuffer.append("    ");
            stringBuffer.append(l);
            stringBuffer.append(" : ");
            stringBuffer.append(new Date(restSession.getLastUsed()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",\n");
        }
        stringBuffer.append("\n]\n");
        return stringBuffer.toString();
    }

    public static Element parseBody(SelectionKey selectionKey, String[] stringArray) throws Exception {
        log.debug((Object)"parseBody()");
        int n = RestService.determineBytesToRead(stringArray);
        SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ChannelInputStream(socketChannel, n, 100));
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build((InputStream)bufferedInputStream);
        return document.getRootElement();
    }

    public static void rethrowAsHttpException(int n, Exception exception) throws HttpException {
        throw new HttpException(n, exception.getMessage());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

