/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.rmi;

import java.rmi.ConnectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.rmi.LocalRemoteService;
import openwfe.org.state.StoppedState;
import org.apache.log4j.Logger;

public class RemoteService
extends LocalRemoteService {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$rmi$RemoteService == null ? (class$openwfe$org$rmi$RemoteService = RemoteService.class$("openwfe.org.rmi.RemoteService")) : class$openwfe$org$rmi$RemoteService).getName());
    public static final String PORT = "port";
    private Registry registry = null;
    static /* synthetic */ Class class$openwfe$org$rmi$RemoteService;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        super.init(string, applicationContext, map);
        this.localInit();
        int n = MapUtils.getAsInt(this.getParams(), PORT, 1099);
        try {
            this.registry = LocateRegistry.getRegistry(n);
            try {
                this.registry.rebind(this.getRemoteName(), this.getRemote());
            }
            catch (ConnectException connectException) {
                this.registry = LocateRegistry.createRegistry(n);
                this.registry.rebind(this.getRemoteName(), this.getRemote());
            }
            log.info((Object)("init() Service bound in rmi registry " + n + " under name '" + this.getRemoteName() + "'"));
        }
        catch (Exception exception) {
            log.warn((Object)("init() Failed to bind an remote instance under name '" + this.getRemoteName() + "' on port " + n), (Throwable)exception);
            throw new ServiceException("Failed to bind an remote instance under name '" + this.getRemoteName() + "' on port " + n);
        }
        log.info((Object)("Serving on rmi port " + n));
    }

    public void stop() throws ServiceException {
        this.setState(new StoppedState());
        try {
            this.registry.unbind(this.getRemoteName());
        }
        catch (Exception exception) {
            log.info((Object)"stop() Something wicked happened during unbind", (Throwable)exception);
            return;
        }
        log.info((Object)("stop() Unbound server '" + this.getRemoteName() + "'"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

