/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.ServiceException;
import openwfe.org.sql.ds.OwfeDataSource;
import org.apache.log4j.Logger;

public abstract class SqlUtils {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$sql$SqlUtils == null ? (class$openwfe$org$sql$SqlUtils = SqlUtils.class$("openwfe.org.sql.SqlUtils")) : class$openwfe$org$sql$SqlUtils).getName());
    static /* synthetic */ Class class$openwfe$org$sql$SqlUtils;

    public static void closeStatement(Statement statement, ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (Throwable throwable) {
            log.debug((Object)"closeStatement() problem when disposing of sql resources", throwable);
        }
    }

    public static void closeStatement(Statement statement) {
        SqlUtils.closeStatement(statement, null);
    }

    public static void closeConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void rollback(Connection connection) {
        try {
            connection.rollback();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNewInsertId(Connection connection, String string, String string2) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT MAX(");
            stringBuffer.append(string2);
            stringBuffer.append(") FROM ");
            stringBuffer.append(string);
            String string3 = stringBuffer.toString();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                long l = resultSet.getLong(1) + 1L;
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            resultSet.close();
            statement.close();
        }
    }

    public static String buildPreparedInsertString(String string, String[] stringArray) {
        ArrayList<Character> arrayList = new ArrayList<Character>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(new Character('?'));
        }
        return SqlUtils.buildInsertString(string, stringArray, arrayList);
    }

    public static String buildInsertString(String string, String[] stringArray, List list) {
        Object object;
        if (stringArray.length != list.size()) {
            throw new IllegalArgumentException("number of columns doesn't match number of values for table '" + string + "'");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(string);
        stringBuffer.append(" (");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(") VALUES (");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object == null) {
                stringBuffer.append("NULL");
            } else if (object instanceof String) {
                stringBuffer.append(SqlUtils.prepareString(object.toString()));
            } else if (object instanceof java.sql.Date) {
                stringBuffer.append("'").append(object.toString()).append("'");
            } else {
                stringBuffer.append(object.toString());
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        object = stringBuffer.toString();
        return object;
    }

    public static String buildUpdateString(String string, String[] stringArray, List list, String string2) {
        if (stringArray.length != list.size()) {
            throw new IllegalArgumentException("number of columns doesn't match number of values for table '" + string + "'");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ");
        stringBuffer.append(string);
        stringBuffer.append(" SET ");
        Iterator iterator = list.iterator();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" = ");
            Object e = iterator.next();
            if (e == null) {
                stringBuffer.append("NULL");
            } else if (e instanceof String) {
                stringBuffer.append(SqlUtils.prepareString(e.toString()));
            } else if (e instanceof Date) {
                stringBuffer.append(SqlUtils.prepareString(e.toString()));
            } else {
                stringBuffer.append(e.toString());
            }
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        if (string2 != null) {
            stringBuffer.append(" WHERE ");
            stringBuffer.append(string2);
        } else {
            log.debug((Object)"buildUpdateString() Warning : null 'whereClause' !");
        }
        String string3 = stringBuffer.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("buildUpdateString() :\n>" + string3 + "<"));
        }
        return string3;
    }

    public static String buildDeleteString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM ");
        stringBuffer.append(string);
        stringBuffer.append(" WHERE ");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static String buildQueryString(String string, String[] stringArray, String string2) {
        return SqlUtils.buildQueryString(string, stringArray, string2, null);
    }

    public static String buildQueryString(String string, String[] stringArray, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" FROM ").append(string);
        if (string2 != null) {
            stringBuffer.append(" WHERE ").append(string2);
        }
        if (string3 != null) {
            stringBuffer.append(" ORDER BY ").append(string3);
        }
        return stringBuffer.toString();
    }

    public static OwfeDataSource lookupDataSource(ApplicationContext applicationContext, Map map) throws ServiceException {
        return OwfeDataSource.lookupDataSource(applicationContext, map);
    }

    public static String prepareString(String string) {
        if (string == null) {
            return "NULL";
        }
        String string2 = string.replaceAll("'", "''");
        string2 = "'" + string2 + "'";
        return string2;
    }

    public static String norm(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() < 1) {
            return null;
        }
        int n = string.indexOf("\"");
        int n2 = string.indexOf(";");
        if (n2 > -1 && n2 < n) {
            n = n2;
        }
        if (n > -1) {
            string = string.substring(0, n);
        }
        string = string.replaceAll("'", "''");
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

