/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.sql.ds;

import com.ibm.db2.jcc.DB2Diagnosable;
import com.ibm.db2.jcc.DB2SimpleDataSource;
import com.ibm.db2.jcc.DB2Sqlca;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.sql.ds.OwfeDataSource;
import org.apache.log4j.Logger;

public class DB2DataSource
extends OwfeDataSource {
    public static final String P_HOST = "db2Host";
    public static final String P_PORT = "db2Port";
    public static final int P_PORT_DEFAULT = 50000;
    public static final String P_USER = "db2User";
    public static final String P_PASS = "db2Pass";
    public static final String P_DBNAME = "db2Database";
    public static final String P_SCHEMA = "db2Schema";
    public static final String P_TYPE = "db2Type";
    public static final int P_TYPE_DEFAULT = 4;
    private static final String CON_VALIDITY_SQL_CODE = "select 1 from syscat.servers";

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        super.init(string, applicationContext, map);
        DB2SimpleDataSource dB2SimpleDataSource = new DB2SimpleDataSource();
        dB2SimpleDataSource.setDatabaseName(MapUtils.getMandatoryString(map, P_DBNAME));
        dB2SimpleDataSource.setCurrentSchema(MapUtils.getMandatoryString(map, P_SCHEMA));
        dB2SimpleDataSource.setServerName(MapUtils.getMandatoryString(map, P_HOST));
        dB2SimpleDataSource.setPortNumber(MapUtils.getAsInt(map, P_PORT, 50000));
        dB2SimpleDataSource.setUser(MapUtils.getMandatoryString(map, P_USER));
        dB2SimpleDataSource.setPassword(MapUtils.getMandatoryString(map, P_PASS));
        dB2SimpleDataSource.setDriverType(MapUtils.getAsInt(map, P_TYPE, 4));
        this.setDataSource((DataSource)dB2SimpleDataSource);
    }

    public void logSQLException(String string, Logger logger, SQLException sQLException) {
        while (sQLException != null) {
            DB2Sqlca dB2Sqlca;
            logger.error((Object)(string + "() SQLException : " + sQLException.toString()));
            if (sQLException instanceof DB2Diagnosable && (dB2Sqlca = ((DB2Diagnosable)sQLException).getSqlca()) != null) {
                int n = dB2Sqlca.getSqlCode();
                String string2 = dB2Sqlca.getSqlErrmc();
                String[] stringArray = dB2Sqlca.getSqlErrmcTokens();
                String string3 = dB2Sqlca.getSqlErrp();
                int[] nArray = dB2Sqlca.getSqlErrd();
                char[] cArray = dB2Sqlca.getSqlWarn();
                String string4 = dB2Sqlca.getSqlState();
                String string5 = "";
                try {
                    string5 = dB2Sqlca.getMessage();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                logger.error((Object)("Server error message: " + string5));
                logger.error((Object)"--------------- SQLCA ---------------");
                logger.error((Object)("Error code: " + n));
                logger.error((Object)("SQLERRMC: " + string2));
                for (int i = 0; i < stringArray.length; ++i) {
                    logger.error((Object)("  token " + i + ": " + stringArray[i]));
                }
                logger.error((Object)("SQLERRP: " + string3));
                logger.error((Object)("SQLERRD(1): " + nArray[0] + "\n" + "SQLERRD(2): " + nArray[1] + "\n" + "SQLERRD(3): " + nArray[2] + "\n" + "SQLERRD(4): " + nArray[3] + "\n" + "SQLERRD(5): " + nArray[4] + "\n" + "SQLERRD(6): " + nArray[5]));
                logger.error((Object)("SQLWARN1: " + cArray[0] + "\n" + "SQLWARN2: " + cArray[1] + "\n" + "SQLWARN3: " + cArray[2] + "\n" + "SQLWARN4: " + cArray[3] + "\n" + "SQLWARN5: " + cArray[4] + "\n" + "SQLWARN6: " + cArray[5] + "\n" + "SQLWARN7: " + cArray[6] + "\n" + "SQLWARN8: " + cArray[7] + "\n" + "SQLWARN9: " + cArray[8] + "\n" + "SQLWARNA: " + cArray[9]));
                logger.error((Object)("SQLSTATE: " + string4));
            }
            sQLException = sQLException.getNextException();
        }
    }

    public String getConnectionValiditySqlCode() {
        return CON_VALIDITY_SQL_CODE;
    }
}

