/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.sql.ds;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;
import openwfe.org.AbstractService;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.sql.SqlUtils;
import org.apache.log4j.Logger;

public abstract class OwfeDataSource
extends AbstractService {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$sql$ds$OwfeDataSource == null ? (class$openwfe$org$sql$ds$OwfeDataSource = OwfeDataSource.class$("openwfe.org.sql.ds.OwfeDataSource")) : class$openwfe$org$sql$ds$OwfeDataSource).getName());
    public static final String P_URL = "url";
    public static final String P_LOGIN_TIMEOUT = "loginTimeout";
    public static final String P_DO_NOT_CHECK_CONNECTION = "doNotCheckConnection";
    public static final String P_DATA_SOURCE = "dataSource";
    private DataSource dataSource = null;
    private long lastConnectionRelease = System.currentTimeMillis();
    private Connection sqlConnection = null;
    private boolean doNotCheckConnection = false;
    static /* synthetic */ Class class$openwfe$org$sql$ds$OwfeDataSource;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        super.init(string, applicationContext, map);
        this.doNotCheckConnection = MapUtils.getAsBoolean(map, P_DO_NOT_CHECK_CONNECTION, false);
        log.info((Object)("init() doNotCheckConnection is set to '" + this.doNotCheckConnection + "'"));
    }

    protected void setDataSource(DataSource dataSource) throws ServiceException {
        this.dataSource = dataSource;
        long l = MapUtils.getAsTime(this.getParams(), P_LOGIN_TIMEOUT, -1L);
        if (l < 0L) {
            return;
        }
        int n = (int)(l / 1000L);
        try {
            this.dataSource.setLoginTimeout(n);
        }
        catch (SQLException sQLException) {
            throw new ServiceException("Failed to set login timeout on wrapped datasource", sQLException);
        }
    }

    protected Connection establishConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getConnection() (" + this.getClass().getName() + ")"));
            }
            long l = System.currentTimeMillis();
            long l2 = l - this.lastConnectionRelease;
            if (this.sqlConnection == null || l2 > 3600000L || this.isConnectionInvalid()) {
                block9: {
                    if (this.sqlConnection != null) {
                        log.debug((Object)"getConnection() closing old connection");
                        try {
                            this.sqlConnection.close();
                        }
                        catch (Throwable throwable) {
                            if (!log.isDebugEnabled()) break block9;
                            log.debug((Object)("getConnection() failed to close old connection " + throwable.toString()));
                        }
                    }
                }
                log.debug((Object)"getConnection() setting up new connection");
                this.sqlConnection = this.establishConnection();
                this.lastConnectionRelease = System.currentTimeMillis();
            }
            long l3 = System.currentTimeMillis() - l;
            if (log.isDebugEnabled()) {
                log.debug((Object)("getConnection() took " + l3 + " ms"));
            }
            return this.sqlConnection;
        }
    }

    public void releaseConnection() {
        log.debug((Object)"releaseConnection()");
        this.lastConnectionRelease = System.currentTimeMillis();
    }

    public Connection newConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isConnectionInvalid() {
        if (this.getConnectionValiditySqlCode() == null) {
            return false;
        }
        if (this.doNotCheckConnection) {
            return false;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.sqlConnection.createStatement();
            resultSet = statement.executeQuery(this.getConnectionValiditySqlCode());
        }
        catch (Throwable throwable) {
            boolean bl;
            try {
                log.info((Object)("isConnectionInvalid() Yes : " + throwable.toString()));
                bl = true;
            }
            catch (Throwable throwable2) {
                SqlUtils.closeStatement(statement, resultSet);
                throw throwable2;
            }
            SqlUtils.closeStatement(statement, resultSet);
            return bl;
        }
        SqlUtils.closeStatement(statement, resultSet);
        log.debug((Object)"isConnectionInvalid() seems that con is valid.");
        return false;
    }

    public abstract String getConnectionValiditySqlCode();

    public void stop() throws ServiceException {
        log.debug((Object)"stop()");
        super.stop();
        this.lastConnectionRelease = -1L;
        if (this.sqlConnection != null) {
            try {
                this.sqlConnection.close();
                this.sqlConnection = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void logSQLException(String string, Logger logger, SQLException sQLException) {
        while (sQLException != null) {
            logger.error((Object)(string + "() SQLException : " + sQLException.toString()));
            sQLException = sQLException.getNextException();
        }
    }

    public static OwfeDataSource lookupDataSource(ApplicationContext applicationContext, Map map) throws ServiceException {
        OwfeDataSource owfeDataSource;
        String string = (String)map.get(P_DATA_SOURCE);
        if (string == null) {
            string = P_DATA_SOURCE;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("lookupDataSource() looking for data source named '" + string + "'"));
        }
        if ((owfeDataSource = (OwfeDataSource)applicationContext.lookup(string)) == null) {
            throw new ServiceException("No OwfeDataSource stored as service named '" + string + "'");
        }
        return owfeDataSource;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

