/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.time;

import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;

public class CronLine {
    private int[] minutes = null;
    private int[] hours = null;
    private int[] days = null;
    private int[] months = null;
    private int[] daysOfWeek = null;

    protected CronLine() {
    }

    public boolean matches(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        if (CronLine.noMatch(calendar.get(12), this.minutes)) {
            return false;
        }
        if (CronLine.noMatch(calendar.get(10), this.hours)) {
            return false;
        }
        if (CronLine.noMatch(calendar.get(5), this.days)) {
            return false;
        }
        if (CronLine.noMatch(calendar.get(2), this.months)) {
            return false;
        }
        return !CronLine.noMatch(calendar.get(7), this.daysOfWeek);
    }

    private static boolean noMatch(int n, int[] nArray) {
        if (nArray == null) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return false;
        }
        return true;
    }

    public static CronLine parse(String string) {
        String[] stringArray = string.split(" ");
        CronLine cronLine = new CronLine();
        cronLine.minutes = CronLine.parseItem(stringArray[0], 0, 59);
        cronLine.hours = CronLine.parseItem(stringArray[1], 0, 24);
        cronLine.days = CronLine.parseItem(stringArray[2], 1, 31);
        cronLine.months = CronLine.parseItem(stringArray[3], 1, 12);
        cronLine.daysOfWeek = CronLine.parseItem(stringArray[4], 1, 7);
        return cronLine;
    }

    private static int[] parseItem(String string, int n, int n2) {
        if (string.trim().equals("*")) {
            return null;
        }
        if (string.indexOf(",") > -1) {
            return CronLine.parseList(string, n, n2);
        }
        if (string.indexOf("-") > -1 || string.indexOf("*") > -1) {
            return CronLine.parseRange(string, n, n2);
        }
        int n3 = Integer.parseInt(string);
        if (n3 < n) {
            n3 = n;
        } else if (n3 > n2) {
            n3 = n2;
        }
        return new int[]{n3};
    }

    private static int[] parseList(String string, int n, int n2) {
        String[] stringArray = string.split(",");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
            if (nArray[i] < n) {
                nArray[i] = n;
            }
            if (nArray[i] <= n2) continue;
            nArray[i] = n2;
        }
        return nArray;
    }

    private static int[] parseRange(String string, int n, int n2) {
        int n3;
        int n4 = string.indexOf("-");
        int n5 = string.indexOf("/");
        int n6 = 1;
        if (n5 > -1) {
            n6 = Integer.parseInt(string.substring(n5 + 1));
        }
        int n7 = -1;
        int n8 = -1;
        if (n4 > -1) {
            n7 = Integer.parseInt(string.substring(0, n4));
            n8 = n5 > -1 ? Integer.parseInt(string.substring(n4 + 1, n5)) : Integer.parseInt(string.substring(n4 + 1));
        } else {
            n7 = n;
            n8 = n2;
        }
        if (n7 < n) {
            n7 = n;
        }
        if (n8 > n2) {
            n8 = n2;
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (n3 = n7; n3 <= n8; n3 += n6) {
            linkedList.add(new Integer(n3));
        }
        n3 = 0;
        int[] nArray = new int[linkedList.size()];
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            nArray[n3++] = (Integer)iterator.next();
        }
        return nArray;
    }
}

