/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class Time {
    public static final SimpleDateFormat SDF_ISO_DATE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
    public static final SimpleDateFormat SDF_ISO_DATE_SHORT = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat[] dateFormats = new SimpleDateFormat[]{SDF_ISO_DATE, SDF_ISO_DATE_SHORT, new SimpleDateFormat("yy-MM-dd HH:mm:ss"), new SimpleDateFormat("dd-MM-yy"), new SimpleDateFormat("dd-MM-yy HH:mm:ss")};

    public static long parseTimeString(String string) {
        string = string.trim();
        int n = -1;
        long l = 0L;
        String string2 = "";
        while (true) {
            if (++n >= string.length()) {
                if (string2.length() <= 0) break;
                l += (long)Integer.parseInt(string2);
                break;
            }
            char c = string.charAt(n);
            if (Character.isDigit(c)) {
                string2 = string2 + c;
                continue;
            }
            long l2 = Long.parseLong(string2);
            string2 = "";
            if (c == 'y') {
                l += l2 * 365L * 24L * 3600L * 1000L;
                continue;
            }
            if (c == 'M') {
                l += l2 * 30L * 24L * 3600L * 1000L;
                continue;
            }
            if (c == 'w') {
                l += l2 * 7L * 24L * 3600L * 1000L;
                continue;
            }
            if (c == 'd') {
                l += l2 * 24L * 3600L * 1000L;
                continue;
            }
            if (c == 'h') {
                l += l2 * 3600L * 1000L;
                continue;
            }
            if (c == 'm') {
                l += l2 * 60L * 1000L;
                continue;
            }
            if (c == 's') {
                l += l2 * 1000L;
                continue;
            }
            l += l2;
        }
        return l;
    }

    private static long[] tts(long l, int n) {
        long l2 = l % (long)n;
        long l3 = (l - l2) / (long)n;
        return new long[]{l2, l3};
    }

    public static String toTimeString(Long l, boolean bl) {
        if (l == null) {
            return "0ms";
        }
        return Time.toTimeString((long)l, bl);
    }

    public static String toTimeString(long l, boolean bl) {
        long[] lArray = Time.tts(l, 1000);
        long l2 = lArray[0];
        lArray = Time.tts(lArray[1], 60);
        long l3 = lArray[0];
        lArray = Time.tts(lArray[1], 60);
        long l4 = lArray[0];
        lArray = Time.tts(lArray[1], 24);
        long l5 = lArray[0];
        lArray = Time.tts(lArray[1], 30);
        long l6 = lArray[0];
        lArray = Time.tts(lArray[1], 12);
        long l7 = lArray[0];
        long l8 = lArray[1];
        StringBuffer stringBuffer = new StringBuffer();
        if (l8 > 0L) {
            stringBuffer.append(l8).append("y");
        }
        if (l7 > 0L) {
            stringBuffer.append(l7).append("M");
        }
        if (l6 > 0L) {
            stringBuffer.append(l6).append("d");
        }
        if (l5 > 0L) {
            stringBuffer.append(l5).append("h");
        }
        if (l4 > 0L) {
            stringBuffer.append(l4).append("m");
        }
        if (l3 > 0L) {
            stringBuffer.append(l3).append("s");
        }
        if (bl) {
            stringBuffer.append(l2).append("ms");
        }
        return stringBuffer.toString();
    }

    public static Date parseDate(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        string2 = string2.replace('/', '-');
        string2 = string2.replace('.', '-');
        for (int i = 0; i < dateFormats.length; ++i) {
            try {
                Date date = dateFormats[i].parse(string2);
                return date;
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        return null;
    }

    public static String toIsoDate(long l) {
        Date date = new Date(l);
        return SDF_ISO_DATE.format(date);
    }

    public static String toIsoDate(Date date) {
        return SDF_ISO_DATE.format(date);
    }

    public static String toIsoDate() {
        return Time.toIsoDate(System.currentTimeMillis());
    }

    public static long fromIsoDate(String string) throws ParseException {
        return SDF_ISO_DATE.parse(string).getTime();
    }
}

