/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.xconf;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import openwfe.org.ServiceException;
import openwfe.org.Utils;
import openwfe.org.xconf.XconfElementBuilder;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class XconfBuilder {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$xconf$XconfBuilder == null ? (class$openwfe$org$xconf$XconfBuilder = XconfBuilder.class$("openwfe.org.xconf.XconfBuilder")) : class$openwfe$org$xconf$XconfBuilder).getName());
    private XconfElementBuilder eltBuilder = null;
    private URL sourceUrl = null;
    private long sourceLastModified = 0L;
    static /* synthetic */ Class class$openwfe$org$xconf$XconfBuilder;

    public XconfBuilder(String string, XconfElementBuilder xconfElementBuilder) throws ServiceException {
        this.eltBuilder = xconfElementBuilder;
        if (log.isDebugEnabled()) {
            log.debug((Object)("XconfBuilder() considering url " + string));
        }
        if (string.startsWith("resource:")) {
            this.sourceUrl = this.getClass().getResource(string.substring(9));
        } else {
            try {
                this.sourceUrl = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ServiceException("Could not build URL out of '" + string + "'", malformedURLException);
            }
        }
    }

    public URL getSourceUrl() {
        return this.sourceUrl;
    }

    public void buildConfig() throws ServiceException {
        this.eltBuilder.clearConfig();
        this.buildConfig(this.sourceUrl);
        this.sourceLastModified = this.sourceLastModified();
    }

    private void buildConfig(URL uRL) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("buildConfig(u) building " + uRL));
        }
        this.eltBuilder.clearConfig();
        Element element = null;
        try {
            element = XmlUtils.extractXml(uRL, false);
        }
        catch (Throwable throwable) {
            throw new ServiceException("Failed to build configuration out of '" + uRL + "'", throwable);
        }
        Iterator iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            if (element2.getName().equals("include")) {
                String string = element2.getAttributeValue("url");
                try {
                    this.buildConfig(new URL(string));
                }
                catch (Throwable throwable) {
                    log.warn((Object)("buildConfig(u) cannot build include " + string + ". Skipped"), throwable);
                }
                continue;
            }
            this.eltBuilder.parseElement(this, element2);
        }
    }

    private long sourceLastModified() {
        if (this.sourceUrl == null) {
            return -1L;
        }
        long l = Utils.getLastModified(this.sourceUrl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("newLastModified() this.sourceLastModified = " + this.sourceLastModified));
            log.debug((Object)("newLastModified() fileLastModified        = " + l));
        }
        if (this.sourceLastModified < l) {
            return l;
        }
        return -1L;
    }

    public boolean hasSourceBeenModified() {
        return this.sourceLastModified() > -1L;
    }

    public void refreshConfig() throws ServiceException {
        if (this.hasSourceBeenModified()) {
            log.info((Object)("refreshConfig() config file " + this.sourceUrl + " modified => reparsing"));
            this.buildConfig();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

