/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.weld.impl;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.manager.BeanManagerImpl;
import org.ops4j.lang.Ops4jException;
import org.ops4j.pax.cdi.spi.AbstractCdiContainer;
import org.ops4j.pax.cdi.spi.CdiContainerType;
import org.ops4j.pax.cdi.weld.impl.InstanceManager;
import org.ops4j.pax.cdi.weld.impl.OsgiEnvironment;
import org.ops4j.pax.cdi.weld.impl.bda.BundleDeployment;
import org.ops4j.pax.swissbox.core.ContextClassLoaderUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeldCdiContainer
extends AbstractCdiContainer {
    private Logger log = LoggerFactory.getLogger(WeldCdiContainer.class);
    private InstanceManager instanceManager;
    private WeldBootstrap bootstrap;
    private BeanManagerImpl manager;

    public WeldCdiContainer(CdiContainerType containerType, Bundle ownBundle, Bundle bundle, Collection<Bundle> extensionBundles) {
        super(containerType, bundle, extensionBundles, Arrays.asList(ownBundle, FrameworkUtil.getBundle(Bootstrap.class)));
        this.log.debug("creating Weld CDI container for bundle {}", (Object)bundle);
    }

    protected void doStart(Object environment) {
        this.buildContextClassLoader();
        try {
            ContextClassLoaderUtils.doWithClassLoader((ClassLoader)this.getContextClassLoader(), (Callable)new Callable<BeanManager>(){

                @Override
                public BeanManager call() throws Exception {
                    return WeldCdiContainer.this.createBeanManager();
                }
            });
        }
        catch (Exception exc) {
            throw new Ops4jException((Throwable)exc);
        }
    }

    private BeanManager createBeanManager() {
        this.bootstrap = new WeldBootstrap();
        BundleDeployment deployment = new BundleDeployment(this.getBundle(), (Bootstrap)this.bootstrap, this.getContextClassLoader());
        BeanDeploymentArchive beanDeploymentArchive = deployment.getBeanDeploymentArchive();
        String contextId = this.getBundle().getSymbolicName() + ":" + this.getBundle().getBundleId();
        this.bootstrap.startContainer(contextId, (Environment)OsgiEnvironment.getInstance(), (Deployment)deployment);
        this.bootstrap.startInitialization();
        this.bootstrap.deployBeans();
        this.bootstrap.validateBeans();
        this.bootstrap.endInitialization();
        this.manager = this.bootstrap.getManager(beanDeploymentArchive);
        return this.manager;
    }

    public void doStop() {
        this.bootstrap.shutdown();
    }

    public Event<Object> getEvent() {
        return this.getInstanceManager().getEvent();
    }

    public BeanManager getBeanManager() {
        return this.manager;
    }

    public Instance<Object> getInstance() {
        return this.getInstanceManager().getInstance();
    }

    private InstanceManager getInstanceManager() {
        if (this.instanceManager == null) {
            BeanManager beanManager = this.getBeanManager();
            this.instanceManager = new InstanceManager();
            AnnotatedType annotatedType = beanManager.createAnnotatedType(InstanceManager.class);
            InjectionTarget target = beanManager.createInjectionTarget(annotatedType);
            CreationalContext cc = beanManager.createCreationalContext(null);
            target.inject((Object)this.instanceManager, cc);
        }
        return this.instanceManager;
    }

    public <T> T unwrap(Class<T> wrappedClass) {
        if (wrappedClass.isAssignableFrom(WeldBootstrap.class)) {
            return wrappedClass.cast(this.bootstrap);
        }
        if (wrappedClass.isAssignableFrom(BeanManagerImpl.class)) {
            return wrappedClass.cast(this.manager);
        }
        return null;
    }

    public void startContext(Class<? extends Annotation> scope) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void stopContext(Class<? extends Annotation> scope) {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

