/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.junit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.statements.Fail;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.ops4j.pax.exam.ExamConfigurationException;
import org.ops4j.pax.exam.ExceptionHelper;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.TestDirectory;
import org.ops4j.pax.exam.TestInstantiationInstruction;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.junit.DecoratedFrameworkMethod;
import org.ops4j.pax.exam.junit.JUnitLegacyAnnotationHandler;
import org.ops4j.pax.exam.spi.ExamReactor;
import org.ops4j.pax.exam.spi.StagedExamReactor;
import org.ops4j.pax.exam.spi.reactors.AnnotationHandler;
import org.ops4j.pax.exam.spi.reactors.ReactorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnit4TestRunner
extends BlockJUnit4ClassRunner {
    private static Logger LOG = LoggerFactory.getLogger(JUnit4TestRunner.class);
    private ReactorManager manager;
    private StagedExamReactor reactor;
    private boolean useProbeInvoker;
    private Map<FrameworkMethod, TestAddress> methodToTestAddressMap = new HashMap<FrameworkMethod, TestAddress>();

    public JUnit4TestRunner(Class<?> klass) throws Exception {
        super(klass);
        LOG.info("creating PaxExam runner for {}", klass);
        Object testClassInstance = klass.newInstance();
        this.manager = ReactorManager.getInstance();
        this.manager.setAnnotationHandler((AnnotationHandler)new JUnitLegacyAnnotationHandler());
        ExamReactor examReactor = this.manager.prepareReactor(klass, testClassInstance);
        boolean bl = this.useProbeInvoker = !this.manager.getSystemType().equals("cdi");
        if (this.useProbeInvoker) {
            this.addTestsToReactor(examReactor, klass, testClassInstance);
        }
        this.reactor = this.manager.stageReactor();
    }

    public void run(RunNotifier notifier) {
        LOG.info("running test class {}", (Object)this.getTestClass().getName());
        Class testClass = this.getTestClass().getJavaClass();
        try {
            this.manager.beforeClass(this.reactor, (Object)testClass);
            super.run(notifier);
        }
        catch (Exception e) {
            throw new TestContainerException("Problem interacting with reactor.", (Throwable)e);
        }
        finally {
            this.manager.afterClass(this.reactor, testClass);
        }
    }

    protected Statement classBlock(RunNotifier notifier) {
        if (this.useProbeInvoker) {
            Statement statement = this.childrenInvoker(notifier);
            return statement;
        }
        return super.classBlock(notifier);
    }

    protected Statement methodBlock(FrameworkMethod method) {
        Object test;
        if (!this.useProbeInvoker) {
            return super.methodBlock(method);
        }
        try {
            test = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return JUnit4TestRunner.this.createTest();
                }
            }.run();
        }
        catch (Throwable e) {
            return new Fail(e);
        }
        Statement statement = this.methodInvoker(method, test);
        return statement;
    }

    protected List<FrameworkMethod> getChildren() {
        if (!this.useProbeInvoker) {
            return super.getChildren();
        }
        if (this.methodToTestAddressMap.isEmpty()) {
            this.fillChildren();
        }
        return new ArrayList<FrameworkMethod>(this.methodToTestAddressMap.keySet());
    }

    private void fillChildren() {
        Set targets = this.reactor.getTargets();
        TestDirectory testDirectory = TestDirectory.getInstance();
        for (TestAddress address : targets) {
            FrameworkMethod frameworkMethod = (FrameworkMethod)this.manager.lookupTestMethod(address.root());
            String className = frameworkMethod.getMethod().getDeclaringClass().getName();
            String methodName = frameworkMethod.getName();
            if (!className.equals(this.getTestClass().getName())) continue;
            DecoratedFrameworkMethod method = new DecoratedFrameworkMethod(address, frameworkMethod);
            testDirectory.add(address, new TestInstantiationInstruction(className + ";" + methodName));
            this.methodToTestAddressMap.put(method, address);
        }
    }

    private void addTestsToReactor(ExamReactor reactor, Class<?> testClass, Object testClassInstance) throws IOException, ExamConfigurationException {
        TestProbeBuilder probe = this.manager.createProbeBuilder(testClassInstance);
        for (FrameworkMethod s : super.getChildren()) {
            TestAddress address = this.delegateTest(testClassInstance, probe, s);
            if (address == null) {
                address = probe.addTest(testClass, s.getMethod().getName(), new Object[0]);
            }
            this.manager.storeTestMethod(address, (Object)s);
        }
        reactor.addProbe(probe);
    }

    private TestAddress delegateTest(Object testClassInstance, TestProbeBuilder probe, FrameworkMethod s) {
        try {
            Class<?>[] types = s.getMethod().getParameterTypes();
            if (types.length == 1 && types[0].isAssignableFrom(TestProbeBuilder.class)) {
                return (TestAddress)s.getMethod().invoke(testClassInstance, probe);
            }
            return null;
        }
        catch (Exception e) {
            throw new TestContainerException("Problem delegating to test.", (Throwable)e);
        }
    }

    protected synchronized Statement methodInvoker(final FrameworkMethod method, Object test) {
        if (!this.useProbeInvoker) {
            return super.methodInvoker(method, test);
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                TestAddress address = (TestAddress)JUnit4TestRunner.this.methodToTestAddressMap.get(method);
                TestAddress root = address.root();
                LOG.debug("Invoke " + method.getName() + " @ " + address + " Arguments: " + root.arguments());
                try {
                    JUnit4TestRunner.this.reactor.invoke(address);
                }
                catch (Exception e) {
                    Throwable t = ExceptionHelper.unwind((Throwable)e);
                    throw t;
                }
            }
        };
    }

    protected Object createTest() throws Exception {
        if (this.useProbeInvoker) {
            return super.createTest();
        }
        Object test = super.createTest();
        this.manager.inject(test);
        return test;
    }
}

