/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.junit.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.statements.Fail;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Parameterized;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.ops4j.pax.exam.ExamConfigurationException;
import org.ops4j.pax.exam.ExceptionHelper;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.TestDirectory;
import org.ops4j.pax.exam.TestInstantiationInstruction;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.junit.impl.JUnitLegacyAnnotationHandler;
import org.ops4j.pax.exam.junit.impl.ParameterizedFrameworkMethod;
import org.ops4j.pax.exam.spi.ExamReactor;
import org.ops4j.pax.exam.spi.StagedExamReactor;
import org.ops4j.pax.exam.spi.reactors.AnnotationHandler;
import org.ops4j.pax.exam.spi.reactors.ReactorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterizedProbeRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ParameterizedProbeRunner.class);
    private ReactorManager manager;
    private StagedExamReactor stagedReactor;
    private Map<FrameworkMethod, TestAddress> methodToTestAddressMap = new LinkedHashMap<FrameworkMethod, TestAddress>();
    private Object[] parameters;

    public ParameterizedProbeRunner(Class<?> klass) throws InitializationError {
        super(klass);
        LOG.info("creating PaxExam runner for {}", klass);
        this.manager = ReactorManager.getInstance();
        this.manager.setAnnotationHandler((AnnotationHandler)new JUnitLegacyAnnotationHandler());
        try {
            ExamReactor examReactor = this.manager.prepareReactor(klass, null);
            this.addTestsToReactor(examReactor, klass, null);
            this.stagedReactor = this.manager.stageReactor();
        }
        catch (InstantiationException exc) {
            throw new InitializationError((Throwable)exc);
        }
        catch (IllegalAccessException exc) {
            throw new InitializationError((Throwable)exc);
        }
        catch (InvocationTargetException exc) {
            throw new InitializationError((Throwable)exc);
        }
        catch (IOException exc) {
            throw new InitializationError((Throwable)exc);
        }
        catch (ExamConfigurationException exc) {
            throw new InitializationError((Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        LOG.info("running test class {}", (Object)this.getTestClass().getName());
        Class testClass = this.getTestClass().getJavaClass();
        try {
            this.manager.beforeClass(this.stagedReactor, (Object)testClass);
            super.run(notifier);
        }
        catch (Throwable e) {
            Description description = Description.createSuiteDescription((Class)testClass);
            notifier.fireTestFailure(new Failure(description, e));
        }
        finally {
            this.manager.afterClass(this.stagedReactor, testClass);
        }
    }

    protected Statement classBlock(RunNotifier notifier) {
        Statement statement = this.childrenInvoker(notifier);
        return statement;
    }

    protected Statement methodBlock(FrameworkMethod method) {
        Object test;
        try {
            ReflectiveCallable reflectiveCallable = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return ParameterizedProbeRunner.this.createTest();
                }
            };
            test = reflectiveCallable.run();
        }
        catch (Throwable e) {
            return new Fail(e);
        }
        Statement statement = this.methodInvoker(method, test);
        return statement;
    }

    protected List<FrameworkMethod> getChildren() {
        if (this.methodToTestAddressMap.isEmpty()) {
            this.fillChildren();
        }
        return new ArrayList<FrameworkMethod>(this.methodToTestAddressMap.keySet());
    }

    private void fillChildren() {
        Set targets = this.stagedReactor.getTargets();
        TestDirectory testDirectory = TestDirectory.getInstance();
        for (TestAddress address : targets) {
            FrameworkMethod frameworkMethod = (FrameworkMethod)this.manager.lookupTestMethod(address.root());
            if (frameworkMethod == null) continue;
            Class<?> frameworkMethodClass = frameworkMethod.getMethod().getDeclaringClass();
            String className = frameworkMethodClass.getName();
            String methodName = frameworkMethod.getName();
            if (!frameworkMethodClass.isAssignableFrom(this.getTestClass().getJavaClass())) continue;
            ParameterizedFrameworkMethod method = new ParameterizedFrameworkMethod(address, frameworkMethod);
            testDirectory.add(address, new TestInstantiationInstruction(className + ";" + methodName));
            this.methodToTestAddressMap.put(method, address);
        }
    }

    private void addTestsToReactor(ExamReactor reactor, Class<?> testClass, Object testClassInstance) throws IOException, ExamConfigurationException {
        TestProbeBuilder probe = this.manager.createProbeBuilder(testClassInstance);
        Iterator<Object[]> it = null;
        int index = 0;
        try {
            it = this.allParameters().iterator();
        }
        catch (Throwable t) {
            throw new ExamConfigurationException(t.getMessage());
        }
        while (it.hasNext()) {
            this.parameters = it.next();
            for (FrameworkMethod s : super.getChildren()) {
                TestAddress address = probe.addTest(testClass, s.getMethod().getName(), new Object[]{index});
                this.manager.storeTestMethod(address, (Object)s);
            }
            ++index;
        }
        reactor.addProbe(probe);
    }

    protected synchronized Statement methodInvoker(final FrameworkMethod method, Object test) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestAddress address = (TestAddress)ParameterizedProbeRunner.this.methodToTestAddressMap.get(method);
                TestAddress root = address.root();
                LOG.debug("Invoke " + method.getName() + " @ " + address + " Arguments: " + root.arguments());
                try {
                    ParameterizedProbeRunner.this.stagedReactor.invoke(address);
                }
                catch (Exception e) {
                    Throwable t = ExceptionHelper.unwind((Throwable)e);
                    throw t;
                }
            }
        };
    }

    protected Object createTest() throws Exception {
        return this.getTestClass().getOnlyConstructor().newInstance(this.parameters);
    }

    private Iterable<Object[]> allParameters() throws Throwable {
        Object params = this.getParametersMethod().invokeExplosively(null, new Object[0]);
        if (params instanceof Iterable) {
            return (Iterable)params;
        }
        throw this.parametersMethodReturnedWrongType();
    }

    private FrameworkMethod getParametersMethod() throws Exception {
        List methods = this.getTestClass().getAnnotatedMethods(Parameterized.Parameters.class);
        for (FrameworkMethod each : methods) {
            if (!each.isStatic() || !each.isPublic()) continue;
            return each;
        }
        throw new Exception("No public static parameters method on class " + this.getTestClass().getName());
    }

    private Exception parametersMethodReturnedWrongType() throws Exception {
        String className = this.getTestClass().getName();
        String methodName = this.getParametersMethod().getName();
        String message = MessageFormat.format("{0}.{1}() must return an Iterable of arrays.", className, methodName);
        return new TestContainerException(message);
    }

    protected void validateConstructor(List<Throwable> errors) {
        this.validateOnlyOneConstructor(errors);
        if (this.fieldsAreAnnotated()) {
            this.validateZeroArgConstructor(errors);
        }
    }

    private List<FrameworkField> getAnnotatedFieldsByParameter() {
        return this.getTestClass().getAnnotatedFields(Parameterized.Parameter.class);
    }

    private boolean fieldsAreAnnotated() {
        return !this.getAnnotatedFieldsByParameter().isEmpty();
    }
}

