/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Locale;
import org.apache.felix.framework.BundleInfo;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.FelixBundle;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;

class BundleImpl
extends FelixBundle {
    private Felix m_felix = null;
    private BundleInfo m_info = null;

    protected BundleImpl(Felix felix, BundleInfo info) {
        this.m_felix = felix;
        this.m_info = info;
    }

    BundleInfo getInfo() {
        return this.m_info;
    }

    void setInfo(BundleInfo info) {
        this.m_info = info;
    }

    public BundleContext getBundleContext() {
        return this.m_info.getBundleContext();
    }

    public long getBundleId() {
        return this.m_info.getBundleId();
    }

    public URL getEntry(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.m_felix.getBundleEntry(this, name);
    }

    public Enumeration getEntryPaths(String path) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.m_felix.getBundleEntryPaths(this, path);
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.m_felix.findBundleEntries(this, path, filePattern, recurse);
    }

    public Dictionary getHeaders() {
        return this.getHeaders(Locale.getDefault().toString());
    }

    public Dictionary getHeaders(String locale) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "metadata"));
        }
        return this.m_felix.getBundleHeaders(this, locale);
    }

    public long getLastModified() {
        return this.m_info.getLastModified();
    }

    public String getLocation() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "metadata"));
        }
        return this.m_felix.getBundleLocation(this);
    }

    public URL getResource(String name) {
        return this.m_felix.getBundleResource(this, name);
    }

    public Enumeration getResources(String name) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.m_felix.getBundleResources(this, name);
    }

    public ServiceReference[] getRegisteredServices() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ServiceReference[] refs = this.m_felix.getBundleRegisteredServices(this);
            if (refs == null) {
                return refs;
            }
            ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
            block2: for (int i = 0; i < refs.length; ++i) {
                String[] objectClass = (String[])refs[i].getProperty("objectClass");
                if (objectClass == null) continue;
                for (int j = 0; j < objectClass.length; ++j) {
                    try {
                        sm.checkPermission(new ServicePermission(objectClass[j], "get"));
                        result.add(refs[i]);
                        continue block2;
                    }
                    catch (Exception ex) {
                        continue;
                    }
                }
            }
            if (result.isEmpty()) {
                return null;
            }
            return result.toArray(new ServiceReference[result.size()]);
        }
        return this.m_felix.getBundleRegisteredServices(this);
    }

    public ServiceReference[] getServicesInUse() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ServiceReference[] refs = this.m_felix.getBundleServicesInUse(this);
            if (refs == null) {
                return refs;
            }
            ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
            block2: for (int i = 0; i < refs.length; ++i) {
                String[] objectClass = (String[])refs[i].getProperty("objectClass");
                if (objectClass == null) continue;
                for (int j = 0; j < objectClass.length; ++j) {
                    try {
                        sm.checkPermission(new ServicePermission(objectClass[j], "get"));
                        result.add(refs[i]);
                        continue block2;
                    }
                    catch (Exception ex) {
                        continue;
                    }
                }
            }
            if (result.isEmpty()) {
                return null;
            }
            return result.toArray(new ServiceReference[result.size()]);
        }
        return this.m_felix.getBundleServicesInUse(this);
    }

    public int getState() {
        return this.m_info.getState();
    }

    public String getSymbolicName() {
        return this.m_felix.getBundleSymbolicName(this);
    }

    public boolean hasPermission(Object obj) {
        return this.m_felix.bundleHasPermission(this, obj);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "class"));
            }
            catch (Exception e) {
                throw new ClassNotFoundException("No permission.", e);
            }
        }
        return this.m_felix.loadBundleClass(this, name);
    }

    public void start() throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "execute"));
        }
        this.m_felix.startBundle(this, true);
    }

    public void update() throws BundleException {
        this.update(null);
    }

    public void update(InputStream is) throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "lifecycle"));
        }
        this.m_felix.updateBundle(this, is);
    }

    public void stop() throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "execute"));
        }
        this.m_felix.stopBundle(this, true);
    }

    public void uninstall() throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "lifecycle"));
        }
        this.m_felix.uninstallBundle(this);
    }

    public String toString() {
        return this.m_felix.getBundleSymbolicName(this) + " [" + this.getBundleId() + "]";
    }

    Object getSignerMatcher() {
        return null;
    }
}

