/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.jline;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import jline.AnsiWindowsTerminal;
import jline.NoInterruptUnixTerminal;
import jline.Terminal;
import jline.UnsupportedTerminal;
import org.fusesource.jansi.internal.WindowsSupport;

public class TerminalFactory {
    private Terminal term;

    public synchronized Terminal getTerminal() throws Exception {
        if (this.term == null) {
            this.init();
        }
        return this.term;
    }

    public void init() throws Exception {
        if ("jline.UnsupportedTerminal".equals(System.getProperty("jline.terminal"))) {
            this.term = new UnsupportedTerminal();
            return;
        }
        boolean windows = System.getProperty("os.name").toLowerCase().contains("windows");
        try {
            if (windows) {
                KarafWindowsTerminal t = new KarafWindowsTerminal();
                t.setDirectConsole(true);
                t.init();
                this.term = t;
            } else {
                NoInterruptUnixTerminal t = new NoInterruptUnixTerminal();
                t.init();
                this.term = t;
            }
        }
        catch (Throwable e) {
            System.out.println("Using an unsupported terminal: " + e.toString());
            this.term = new UnsupportedTerminal();
        }
    }

    public synchronized void destroy() throws Exception {
        if (this.term != null) {
            this.term.restore();
            this.term = null;
        }
    }

    public static class KarafWindowsTerminal
    extends AnsiWindowsTerminal {
        public int readCharacter(InputStream in) throws IOException {
            if (this.isSystemIn(in)) {
                return WindowsSupport.readByte();
            }
            return super.readCharacter(in);
        }

        private boolean isSystemIn(InputStream in) throws IOException {
            assert (in != null);
            if (in == System.in) {
                return true;
            }
            while (in instanceof FilterInputStream) {
                try {
                    Field f = FilterInputStream.class.getDeclaredField("in");
                    f.setAccessible(true);
                    in = (InputStream)f.get(in);
                }
                catch (Throwable t) {
                    break;
                }
                if (in != System.in) continue;
                return true;
            }
            return in instanceof FileInputStream && ((FileInputStream)in).getFD() == FileDescriptor.in;
        }
    }
}

