/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.LogLevel;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.ServiceRegistry;
import org.apache.felix.framework.util.EventDispatcher;
import org.ops4j.io.FileUtils;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.runner.AuditedProperties;
import org.ops4j.pax.runner.CommandLine;
import org.ops4j.pax.runner.CommandLineImpl;
import org.ops4j.pax.runner.Configuration;
import org.ops4j.pax.runner.ConfigurationException;
import org.ops4j.pax.runner.ConfigurationImpl;
import org.ops4j.pax.runner.Context;
import org.ops4j.pax.runner.ContextImpl;
import org.ops4j.pax.runner.ExtensionBasedProvisionSchemaResolver;
import org.ops4j.pax.runner.NoopJavaRunner;
import org.ops4j.pax.runner.OptionResolver;
import org.ops4j.pax.runner.OptionResolverImpl;
import org.ops4j.pax.runner.ProvisionSchemaResolver;
import org.ops4j.pax.runner.commons.Info;
import org.ops4j.pax.runner.osgi.RunnerBundle;
import org.ops4j.pax.runner.osgi.RunnerBundleContext;
import org.ops4j.pax.runner.osgi.RunnerStartLevel;
import org.ops4j.pax.runner.platform.BundleReference;
import org.ops4j.pax.runner.platform.BundleReferenceBean;
import org.ops4j.pax.runner.platform.InProcessJavaRunner;
import org.ops4j.pax.runner.platform.InitDScriptRunner;
import org.ops4j.pax.runner.platform.JavaRunner;
import org.ops4j.pax.runner.platform.Platform;
import org.ops4j.pax.runner.platform.PlatformException;
import org.ops4j.pax.runner.platform.ScriptJavaRunner;
import org.ops4j.pax.runner.platform.SystemFileReference;
import org.ops4j.pax.runner.platform.SystemFileReferenceBean;
import org.ops4j.pax.runner.platform.ZipJavaRunner;
import org.ops4j.pax.scanner.MalformedSpecificationException;
import org.ops4j.pax.scanner.ProvisionService;
import org.ops4j.pax.scanner.ScannedBundle;
import org.ops4j.pax.scanner.ScannerException;
import org.ops4j.pax.scanner.UnsupportedSchemaException;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Run {
    private static Log LOGGER;
    private static final String HANDLER_SERVICE = "handler.service";
    private static final String PROVISION_SERVICE = "provision.service";
    private static final String PLATFORM_SERVICE = "platform.service";
    private static final String CLEAN_START = "clean";
    private static final String WORKING_DIRECTORY = "workingDirectory";

    public Run() {
        if (LOGGER == null) {
            Run.createLogger();
        }
    }

    public static void main(String ... args) {
        try {
            Run.main(null, args);
        }
        catch (Throwable t) {
            Run.showError(t);
            System.exit(1);
        }
    }

    public static void main(JavaRunner runner, String ... args) {
        CommandLineImpl commandLine = new CommandLineImpl(args);
        boolean disableLogo = Boolean.valueOf(commandLine.getOption("nologo"));
        if (!disableLogo) {
            Run.showLogo();
        }
        Run.initializeLogger(commandLine);
        String configURL = commandLine.getOption("config");
        if (configURL == null) {
            configURL = "classpath:META-INF/runner.properties";
        }
        ConfigurationImpl config = new ConfigurationImpl(configURL);
        new Run().start(commandLine, config, new OptionResolverImpl(commandLine, config), runner);
    }

    public static Log getLogger() {
        Run.createLogger();
        return LOGGER;
    }

    public static void start(JavaRunner runner, String ... args) {
        CommandLineImpl commandLine = new CommandLineImpl(args);
        String configURL = commandLine.getOption("config");
        if (configURL == null) {
            configURL = "classpath:META-INF/runner.properties";
        }
        ConfigurationImpl config = new ConfigurationImpl(configURL);
        new Run().start(commandLine, config, new OptionResolverImpl(commandLine, config), runner);
    }

    public void start(CommandLine commandLine, Configuration config, OptionResolver resolver) {
        this.start(commandLine, config, resolver, null);
    }

    public void start(CommandLine commandLine, Configuration config, OptionResolver resolver, JavaRunner runner) {
        Context context = this.createContext(commandLine, config, resolver);
        LOGGER.info(commandLine);
        this.cleanup(resolver);
        this.installServices(context);
        this.installHandlers(context);
        this.installBundles(this.installScanners(context), new ExtensionBasedProvisionSchemaResolver(), context);
        EventDispatcher.shutdown();
        this.startPlatform(this.installPlatform(context), context, runner == null ? this.createJavaRunner(resolver) : runner);
    }

    void cleanup(OptionResolver resolver) {
        boolean cleanStart = Boolean.valueOf(resolver.get(CLEAN_START));
        if (cleanStart) {
            File workingDir = new File(resolver.getMandatory(WORKING_DIRECTORY));
            LOGGER.debug("Removing working directory [" + workingDir.getAbsolutePath() + "]");
            FileUtils.delete(workingDir);
        }
    }

    Context createContext(CommandLine commandLine, Configuration config, OptionResolver resolver) {
        NullArgumentException.validateNotNull(commandLine, "Command line");
        NullArgumentException.validateNotNull(config, "Configuration");
        NullArgumentException.validateNotNull(resolver, "PropertyResolver");
        ServiceRegistry serviceRegistry = new ServiceRegistry(null);
        final EventDispatcher dispatcher = EventDispatcher.start(new Logger(4));
        serviceRegistry.addServiceListener(new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                dispatcher.fireServiceEvent(event);
            }
        });
        return new ContextImpl().setCommandLine(commandLine).setConfiguration(config).setOptionResolver(resolver).setServiceRegistry(serviceRegistry).setEventDispatcher(dispatcher);
    }

    JavaRunner createJavaRunner(OptionResolver resolver) {
        NullArgumentException.validateNotNull(resolver, "PropertyResolver");
        LOGGER.debug("Creating Java Runner");
        String executor = resolver.get("executor");
        if (executor == null || executor.trim().length() == 0) {
            LOGGER.debug("Using default executor");
            return null;
        }
        if ("noop".equalsIgnoreCase(executor)) {
            LOGGER.debug("Using noop executor");
            return new NoopJavaRunner();
        }
        if ("script".equalsIgnoreCase(executor)) {
            LOGGER.debug("Using script executor");
            return new ScriptJavaRunner();
        }
        if ("zip".equalsIgnoreCase(executor)) {
            LOGGER.debug("Using zip executor");
            return new ZipJavaRunner();
        }
        if ("inProcess".equalsIgnoreCase(executor)) {
            LOGGER.debug("Using in process executor");
            return new InProcessJavaRunner();
        }
        if (executor.startsWith("init.d")) {
            String[] data = executor.split(",");
            String appName = data.length > 1 && data[1].length() > 0 ? data[1] : null;
            return new InitDScriptRunner(appName);
        }
        try {
            JavaRunner javaRunner = (JavaRunner)this.getClass().getClassLoader().loadClass(executor).newInstance();
            LOGGER.debug("Using " + executor + " executor");
            return javaRunner;
        }
        catch (Exception ignore) {
            LOGGER.debug("Connot load executor: " + executor + " reason: " + ignore.getMessage());
            throw new ConfigurationException("Executor [" + executor + "] is not supported");
        }
    }

    void installHandlers(Context context) {
        LOGGER.debug("Installing handlers");
        String option = context.getOptionResolver().get("handlers");
        if (option != null) {
            String[] segments;
            Configuration config = context.getConfiguration();
            for (String segment : segments = option.split(",")) {
                NullArgumentException.validateNotEmpty(segment, "Handler entry");
                LOGGER.debug("Handler [" + segment + "]");
                String activatorName = config.getProperty(segment);
                if (activatorName == null || activatorName.trim().length() == 0) {
                    throw new ConfigurationException("Handler [" + segment + "] is not supported");
                }
                this.createActivator(segment, activatorName, context);
            }
            String serviceActivatorName = config.getProperty(HANDLER_SERVICE);
            if (serviceActivatorName == null || serviceActivatorName.trim().length() == 0) {
                throw new ConfigurationException("Handler Service must be configured [handler.service]");
            }
            this.createActivator(HANDLER_SERVICE, serviceActivatorName, context);
        }
    }

    ProvisionService installScanners(Context context) {
        String[] segments;
        LOGGER.debug("Installing provisioning");
        String option = context.getOptionResolver().getMandatory("scanners");
        RunnerStartLevel.install(context.getServiceRegistry());
        for (String segment : segments = option.split(",")) {
            NullArgumentException.validateNotEmpty(segment, "Scanner entry");
            LOGGER.debug("Scanner [" + segment + "]");
            String activatorName = context.getConfiguration().getProperty(segment);
            if (activatorName == null || activatorName.trim().length() == 0) {
                throw new ConfigurationException("Scanner [" + segment + "] is not supported");
            }
            this.createActivator(segment, activatorName, context);
        }
        String serviceActivatorName = context.getConfiguration().getProperty(PROVISION_SERVICE);
        if (serviceActivatorName == null || serviceActivatorName.trim().length() == 0) {
            throw new ConfigurationException("Provision Service must be configured [provision.service]");
        }
        BundleContext bundleContext = this.createActivator(PROVISION_SERVICE, serviceActivatorName, context);
        if (bundleContext == null) {
            throw new RuntimeException("Could not create bundle context for provision service");
        }
        ServiceReference reference = bundleContext.getServiceReference(ProvisionService.class.getName());
        if (reference == null) {
            throw new RuntimeException("Could not resolve a provision service");
        }
        return (ProvisionService)bundleContext.getService(reference);
    }

    void installServices(Context context) {
        LOGGER.debug("Installing additional services");
        String option = context.getOptionResolver().get("services");
        if (option != null) {
            String[] segments;
            Configuration config = context.getConfiguration();
            for (String segment : segments = option.split(",")) {
                NullArgumentException.validateNotEmpty(segment, "Service entry");
                LOGGER.debug("Installing service [" + segment + "]");
                String activatorName = config.getProperty(segment);
                if (activatorName == null || activatorName.trim().length() == 0) {
                    throw new ConfigurationException("Service [" + segment + "] is not supported");
                }
                this.createActivator(segment, activatorName, context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void installBundles(ProvisionService provisionService, ProvisionSchemaResolver schemaResolver, Context context) {
        if (provisionService == null) {
            throw new RuntimeException("Could not resolve a provision service");
        }
        ArrayList<String> provisionSpecs = new ArrayList<String>();
        provisionSpecs.addAll(context.getCommandLine().getArguments());
        provisionSpecs.addAll(this.transformProfilesToProvisionSpecs(context));
        Properties sysPropsBackup = System.getProperties();
        try {
            context.setSystemProperties(new AuditedProperties(sysPropsBackup));
            System.setProperties(context.getSystemProperties());
            HashSet<ScannedBundle> scannedBundles = new HashSet<ScannedBundle>();
            for (String provisionSpec : provisionSpecs) {
                try {
                    try {
                        provisionService.wrap(this.filterUnique(scannedBundles, provisionService.scan(provisionSpec))).install();
                    }
                    catch (UnsupportedSchemaException e) {
                        String resolvedProvisionURL = schemaResolver.resolve(provisionSpec);
                        if (resolvedProvisionURL == null || resolvedProvisionURL.equals(provisionSpec)) throw e;
                        provisionService.wrap(this.filterUnique(scannedBundles, provisionService.scan(resolvedProvisionURL))).install();
                    }
                }
                catch (MalformedSpecificationException e) {
                    throw new RuntimeException(e);
                }
                catch (ScannerException e) {
                    throw new RuntimeException(e);
                }
                catch (BundleException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        finally {
            System.setProperties(sysPropsBackup);
        }
    }

    private List<String> transformProfilesToProvisionSpecs(Context context) {
        ArrayList<String> provisionSpecs = new ArrayList<String>();
        String profilesOption = context.getOptionResolver().get("profiles");
        if (profilesOption != null && profilesOption.trim().length() > 0) {
            String[] profiles;
            String profilesGroup = context.getOptionResolver().get("profilesGroupId");
            for (String profile : profiles = profilesOption.split(":")) {
                int startOfOptions = profile.indexOf("@");
                String options = null;
                if (startOfOptions > 0) {
                    options = profile.substring(startOfOptions);
                    profile = profile.substring(0, startOfOptions);
                }
                String[] parts = profile.split("/");
                provisionSpecs.add("scan-composite" + ":" + "mvn" + ":" + (parts.length < 3 ? profilesGroup + "/" : "") + profile + (parts.length < 2 ? "/" : "") + "/composite" + (options != null ? options : ""));
            }
        }
        return provisionSpecs;
    }

    private List<ScannedBundle> filterUnique(Set<ScannedBundle> alreadyScanned, List<ScannedBundle> scannedBundles) {
        LinkedHashSet<ScannedBundle> unique = new LinkedHashSet<ScannedBundle>(scannedBundles);
        unique.removeAll(alreadyScanned);
        alreadyScanned.addAll(unique);
        return new ArrayList<ScannedBundle>(unique);
    }

    Platform installPlatform(Context context) {
        ServiceReference[] references;
        LOGGER.debug("Installing platform");
        String platform = context.getOptionResolver().getMandatory("platform");
        String version = Boolean.parseBoolean(context.getOptionResolver().get("snapshot")) ? "SNAPSHOT" : context.getOptionResolver().get("version");
        if (version == null && (version = context.getOptionResolver().get(platform + "." + "version")) == null) {
            throw new ConfigurationException("Could not resolve a version for platform [" + platform + "]");
        }
        version = version.toUpperCase();
        String activatorName = context.getConfiguration().getProperty(platform + "." + version);
        if (activatorName == null || activatorName.trim().length() == 0) {
            throw new ConfigurationException("Platform [" + platform + " " + version + "] is not supported");
        }
        this.createActivator(platform, activatorName, context);
        String serviceActivatorName = context.getConfiguration().getProperty(PLATFORM_SERVICE);
        if (serviceActivatorName == null || serviceActivatorName.trim().length() == 0) {
            throw new ConfigurationException("Platform Service must be configured [platform.service]");
        }
        BundleContext bundleContext = this.createActivator(PLATFORM_SERVICE, serviceActivatorName, context);
        if (bundleContext == null) {
            throw new RuntimeException("Could not create bundle context for platform service");
        }
        try {
            references = bundleContext.getServiceReferences(Platform.class.getName(), "(version=" + version + ")");
        }
        catch (InvalidSyntaxException ignore) {
            throw new ConfigurationException("Platform [" + platform + " " + version + "] is not supported");
        }
        if (references == null || references.length == 0) {
            throw new RuntimeException("Could not resolve a platform");
        }
        ServiceReference reference = references[0];
        return (Platform)bundleContext.getService(reference);
    }

    private void startPlatform(Platform platform, Context context, JavaRunner runner) {
        LOGGER.debug("Starting platform");
        if (platform == null) {
            throw new RuntimeException("Could not resolve a platform");
        }
        List<RunnerBundle> installedBundles = context.getBundles();
        ArrayList<BundleReference> references = new ArrayList<BundleReference>();
        if (installedBundles != null) {
            for (RunnerBundle bundle : installedBundles) {
                LOGGER.info("Provision bundle [" + bundle + "]");
                references.add(new BundleReferenceBean(bundle.getLocationAsURL().toExternalForm(), bundle.getLocationAsURL(), bundle.getStartLevel(), bundle.shouldStart(), bundle.shouldUpdate()));
            }
        }
        try {
            platform.start(this.determineSystemFiles(context), references, context.getSystemProperties(), null, runner);
        }
        catch (PlatformException e) {
            throw new RuntimeException(e);
        }
    }

    List<SystemFileReference> determineSystemFiles(Context context) {
        ArrayList<SystemFileReference> systemFiles = new ArrayList<SystemFileReference>();
        try {
            String[] bcpaUrls;
            String[] bcppUrls = context.getOptionResolver().getMultiple("bcp/p");
            if (bcppUrls.length > 0) {
                for (String url : bcppUrls) {
                    systemFiles.add(new SystemFileReferenceBean(url, new URL(url), true));
                }
            }
            if ((bcpaUrls = context.getOptionResolver().getMultiple("bcp/a")).length > 0) {
                for (String url : bcpaUrls) {
                    systemFiles.add(new SystemFileReferenceBean(url, new URL(url), false));
                }
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return systemFiles;
    }

    BundleContext createActivator(String bundleName, String activatorClazz, Context context) {
        try {
            BundleActivator activator = (BundleActivator)Class.forName(activatorClazz).newInstance();
            RunnerBundleContext bundleContext = new RunnerBundleContext(context);
            activator.start(bundleContext);
            return bundleContext;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create [" + bundleName + "]", e);
        }
    }

    private static void showLogo() {
        System.out.println("__________                 __________                                 ");
        System.out.println("\\______   \\_____  ___  ___ \\______   \\__ __  ____   ____   ___________");
        System.out.println("|     ___/\\__  \\ \\  \\/  /  |       _/  |  \\/    \\ /    \\_/ __ \\_  __ \\");
        System.out.println("|    |     / __ \\_>    <   |    |   \\  |  /   |  \\   |  \\  ___/|  | \\/");
        System.out.println("|____|    (____  /__/\\_ \\  |____|_  /____/|___|  /___|  /\\___  >__|   ");
        System.out.println("               \\/      \\/         \\/           \\/     \\/     \\/       ");
        System.out.println();
        String logo = "Pax Runner " + Run.getVersion() + "from OPS4J - http://www.ops4j.org";
        System.out.println(logo);
        System.out.println("--------------------------------------------------------------------------------------------------------".substring(0, logo.length()));
        System.out.println();
    }

    private static String getVersion() {
        try {
            InputStream is = Run.class.getClassLoader().getResourceAsStream("META-INF/runner.version");
            if (is != null) {
                Properties properties = new Properties();
                properties.load(is);
                String version = properties.getProperty("version");
                if (version != null) {
                    return "(" + version + ") ";
                }
                return "";
            }
            return "";
        }
        catch (Exception ignore) {
            return "";
        }
    }

    private static void showError(Throwable t) {
        Info.println();
        String message = t.getMessage();
        String debugInfo = "";
        if (LOGGER != null && !LOGGER.isDebugEnabled()) {
            debugInfo = "Use --log=debug to see details.";
        }
        System.out.println("         ___");
        System.out.println("        /  /");
        System.out.println("       /  / Oops, there has been a problem!");
        System.out.println("      /  /  ");
        System.out.println("     /__/   " + message);
        System.out.println("    ___");
        System.out.println("   /__/     " + debugInfo);
        System.out.println();
        if (LOGGER == null) {
            System.out.println("Exception caught during execution:");
            t.printStackTrace();
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.error("Exception caught during execution:", t);
        }
    }

    private static void initializeLogger(CommandLine commandLine) {
        String debug = commandLine.getOption("log");
        if (debug != null) {
            try {
                Run.createLogger(LogLevel.valueOf(debug.toUpperCase()));
            }
            catch (Exception ignore) {
                Run.createLogger(LogLevel.INFO);
                LOGGER.warn("Unknown debug option [" + debug + "], switching to INFO");
            }
        } else {
            Run.createLogger(LogLevel.INFO);
        }
    }

    private static void createLogger(LogLevel logLevel) {
        try {
            LOGGER = LogFactory.getLog(Run.class, logLevel);
        }
        catch (NoSuchMethodError ignore) {
            LOGGER = LogFactory.getLog(Run.class);
        }
    }

    private static void createLogger() {
        try {
            Run.createLogger(LogLevel.INFO);
        }
        catch (NoClassDefFoundError ignore) {
            LOGGER = LogFactory.getLog(Run.class);
        }
    }
}

