/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.runner.platform.PlatformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExecutionEnvironment {
    private static final Log LOGGER = LogFactory.getLog(ExecutionEnvironment.class);
    private static final String EE_FILES_ROOT = "META-INF/platform/ee/";
    private final String m_systemPackages;
    private final String m_executionEnvironment;

    ExecutionEnvironment(String ee) throws PlatformException {
        TreeSet<String> uniquePackages = new TreeSet<String>();
        TreeSet<String> uniqueEE = new TreeSet<String>();
        for (String segment : ee.split(",")) {
            try {
                String eeProp;
                Properties profile = new Properties();
                profile.load(this.discoverExecutionEnvironmentURL(segment).openStream());
                String systemPackagesProp = profile.getProperty("org.osgi.framework.system.packages", "");
                if (systemPackagesProp != null && systemPackagesProp.trim().length() > 0) {
                    uniquePackages.addAll(Arrays.asList(systemPackagesProp.split(",")));
                }
                if ((eeProp = profile.getProperty("org.osgi.framework.executionenvironment", "")) == null || eeProp.trim().length() <= 0) continue;
                uniqueEE.addAll(Arrays.asList(eeProp.split(",")));
            }
            catch (IOException e) {
                throw new PlatformException("Could not read execution environment profile", e);
            }
        }
        this.m_systemPackages = ExecutionEnvironment.join(uniquePackages, ",");
        this.m_executionEnvironment = ExecutionEnvironment.join(uniqueEE, ",");
    }

    public String getSystemPackages() {
        return this.m_systemPackages;
    }

    public String getExecutionEnvironment() {
        return this.m_executionEnvironment;
    }

    private URL discoverExecutionEnvironmentURL(String ee) throws PlatformException {
        URL url;
        String relativeFileName = ExecutionEnvironment.getEEMAppings().get(ee.toUpperCase());
        if (relativeFileName != null) {
            url = this.getClass().getClassLoader().getResource(EE_FILES_ROOT + relativeFileName);
            if (url == null) {
                throw new PlatformException("Execution environment [" + ee + "] not supported");
            }
            LOGGER.info("Using execution environment [" + ee + "]");
        } else {
            try {
                url = new URL(ee);
                LOGGER.info("Execution environment [" + url.toExternalForm() + "]");
            }
            catch (MalformedURLException e) {
                throw new PlatformException("Execution environment [" + ee + "] could not be found", e);
            }
        }
        return url;
    }

    private static Map<String, String> getEEMAppings() {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("CDC-1.0/Foundation-1.0".toUpperCase(), "CDC-1.0/Foundation-1.0.profile");
        mappings.put("CDC-1.1/Foundation-1.1".toUpperCase(), "CDC-1.1/Foundation-1.1.profile");
        mappings.put("OSGi/Minimum-1.0".toUpperCase(), "OSGi/Minimum-1.0.profile");
        mappings.put("OSGi/Minimum-1.1".toUpperCase(), "OSGi/Minimum-1.1.profile");
        mappings.put("OSGi/Minimum-1.2".toUpperCase(), "OSGi/Minimum-1.2.profile");
        mappings.put("JRE-1.1".toUpperCase(), "JRE-1.1.profile");
        mappings.put("J2SE-1.2".toUpperCase(), "J2SE-1.2.profile");
        mappings.put("J2SE-1.3".toUpperCase(), "J2SE-1.3.profile");
        mappings.put("J2SE-1.4".toUpperCase(), "J2SE-1.4.profile");
        mappings.put("J2SE-1.5".toUpperCase(), "J2SE-1.5.profile");
        mappings.put("J2SE-1.6".toUpperCase(), "JavaSE-1.6.profile");
        mappings.put("JavaSE-1.6".toUpperCase(), "JavaSE-1.6.profile");
        mappings.put("J2SE-1.7".toUpperCase(), "JavaSE-1.7.profile");
        mappings.put("JavaSE-1.7".toUpperCase(), "JavaSE-1.7.profile");
        mappings.put("PersonalJava-1.1".toUpperCase(), "PersonalJava-1.1.profile");
        mappings.put("PersonalJava-1.2".toUpperCase(), "PersonalJava-1.2.profile");
        mappings.put("CDC-1.0/PersonalBasis-1.0".toUpperCase(), "CDC-1.0/PersonalBasis-1.0.profile");
        mappings.put("CDC-1.0/PersonalJava-1.0".toUpperCase(), "CDC-1.0/PersonalJava-1.0.profile");
        mappings.put("NONE".toUpperCase(), "None.profile");
        return mappings;
    }

    public static String join(Collection<String> toJoin, String delimiter) {
        StringBuilder builder = new StringBuilder();
        for (String entry : toJoin) {
            if (builder.length() > 0) {
                builder.append(delimiter);
            }
            builder.append(entry);
        }
        return builder.toString();
    }
}

