/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.assembly.internal;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.io.DirectoryLister;
import org.ops4j.io.HierarchicalIOException;
import org.ops4j.io.Lister;
import org.ops4j.io.ZipLister;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.url.assembly.internal.FileResource;
import org.ops4j.pax.url.assembly.internal.JarResource;
import org.ops4j.pax.url.assembly.internal.MergePolicy;
import org.ops4j.pax.url.assembly.internal.Resource;
import org.ops4j.pax.url.assembly.internal.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourceAssembly
implements Iterable<Resource> {
    private static final Log LOGGER = LogFactory.getLog(ResourceAssembly.class);
    private final Set<Resource> m_resources;

    public ResourceAssembly(Source[] sources, MergePolicy policy) throws IOException {
        NullArgumentException.validateNotNull(sources, "Resource patterns");
        NullArgumentException.validateNotNull(policy, "Merging policy");
        this.m_resources = new HashSet<Resource>();
        for (Source source : sources) {
            this.scan(source, policy);
        }
    }

    private void scan(Source source, MergePolicy policy) throws IOException {
        LOGGER.trace("Searching for [" + source + "]");
        String path = source.path();
        URL url = null;
        try {
            url = new URL(path);
        }
        catch (MalformedURLException ignore) {
            LOGGER.trace(String.format("Path [%s] is not a valid url. Reason: %s. Continue discovery...", path, ignore.getMessage()));
        }
        File file = null;
        if (url != null && "file".equals(url.getProtocol())) {
            try {
                URI uri = new URI(url.toExternalForm().replaceAll(" ", "%20"));
                file = new File(uri);
            }
            catch (URISyntaxException ignore) {
                LOGGER.trace(String.format("Path [%s] is not a valid url. Reason: %s. Continue discovery...", path, ignore.getMessage()));
            }
        } else {
            file = new File(path);
        }
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                this.list(file, new DirectoryLister(file, source.includes(), source.excludes()), policy);
                return;
            }
            LOGGER.trace(String.format("Path [%s] is not a valid directory. Continue discovery...", path));
        } else {
            LOGGER.trace(String.format("Path [%s] is not a valid file. Continue discovery...", path));
        }
        try {
            ZipFile zip = null;
            URL baseUrl = null;
            if (file != null && file.exists()) {
                zip = new ZipFile(file);
                baseUrl = file.toURL();
            } else if (url != null) {
                zip = new ZipFile(url.toExternalForm());
                baseUrl = url;
            }
            if (zip != null && baseUrl != null) {
                this.list(new ZipLister(baseUrl, zip.entries(), source.includes(), source.excludes()), policy);
                return;
            }
        }
        catch (IOException ignore) {
            LOGGER.trace(String.format("Path [%s] is not a valid zip. Reason: %s. Continue discovery...", path, ignore.getMessage()));
        }
        if (url != null && !url.toExternalForm().startsWith("jar")) {
            try {
                URL jarUrl = new URL("jar:" + url.toURI().toASCIIString() + "!/");
                JarURLConnection jar = (JarURLConnection)jarUrl.openConnection();
                this.list(new ZipLister(url, jar.getJarFile().entries(), source.includes(), source.excludes()), policy);
                return;
            }
            catch (IOException ignore) {
                LOGGER.trace(String.format("Path [%s] is not a valid jar. Reason: %s", path, ignore.getMessage()));
            }
            catch (URISyntaxException ignore) {
                LOGGER.trace(String.format("Path [%s] is not a valid jar. Reason: %s", path, ignore.getMessage()));
            }
        }
        LOGGER.trace(String.format("Source [%s] cannot be used. Stopping.", source));
        throw new HierarchicalIOException(String.format("Source [%s] cannot be used. Stopping.", source));
    }

    private void list(File base, Lister lister, MergePolicy policy) throws IOException {
        for (URL url : lister.list()) {
            try {
                policy.addResource(new FileResource(base, new File(url.toURI())), this.m_resources);
            }
            catch (URISyntaxException e) {
                throw new HierarchicalIOException(String.format("URL [%s] could not be used", url.toExternalForm()));
            }
        }
    }

    private void list(Lister lister, MergePolicy policy) throws IOException {
        for (URL url : lister.list()) {
            policy.addResource(new JarResource(url), this.m_resources);
        }
    }

    @Override
    public Iterator<Resource> iterator() {
        return this.m_resources.iterator();
    }
}

