/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.dir.internal;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.url.dir.internal.FileTail;

public class FileTailImpl
implements FileTail {
    public static final Log logger = LogFactory.getLog(FileTailImpl.class);
    private File m_topLevelDir;
    private String m_tail;
    private File m_parentOfTail;

    public FileTailImpl(File topLevelDir, String tailExpr) throws IOException {
        NullArgumentException.validateNotNull(topLevelDir, "topLevelDir");
        NullArgumentException.validateNotNull(tailExpr, "tailExpr");
        this.m_topLevelDir = topLevelDir;
        this.m_tail = tailExpr;
        this.validateTopLevelDir();
        this.findParentOfTail();
    }

    private void validateTopLevelDir() {
        if (!(this.m_topLevelDir.exists() && this.m_topLevelDir.canRead() && this.m_topLevelDir.isDirectory())) {
            throw new IllegalArgumentException("topLevelDir " + this.m_topLevelDir.getAbsolutePath() + " is not a readable folder");
        }
        logger.debug("Top level dir " + this.m_topLevelDir + " has been verified.");
    }

    private void findParentOfTail() throws IOException {
        if (this.m_tail == null || this.m_tail.length() == 0) {
            this.m_parentOfTail = this.m_topLevelDir;
        } else {
            this.m_parentOfTail = this.findParentOfTail(this.m_topLevelDir);
            if (this.m_parentOfTail == null) {
                throw new IllegalArgumentException("topLevelDir " + this.m_topLevelDir.getAbsolutePath() + "  does not contain a tail " + this.m_tail);
            }
            logger.debug("Parent of tail is: " + this.m_parentOfTail.getAbsolutePath());
        }
    }

    protected File findParentOfTail(File folder) throws IOException {
        logger.debug("findParentOfTail " + folder.getAbsolutePath());
        for (File f : folder.listFiles()) {
            String p;
            if (!f.isHidden() && f.isDirectory()) {
                File r = this.findParentOfTail(f);
                if (r == null) continue;
                return r;
            }
            if (f.isHidden() || !(p = f.getCanonicalPath().replaceAll("\\\\", "/")).endsWith(this.m_tail)) continue;
            return new File(f.getCanonicalPath().substring(0, f.getCanonicalPath().length() - this.m_tail.length()));
        }
        return null;
    }

    public File getParentOfTail() {
        return this.m_parentOfTail;
    }

    public String toString() {
        return "FileTailImpl{m_topLevelDir=" + this.m_topLevelDir + ", m_tail=" + this.m_tail + '}';
    }
}

