/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.ext;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.aries.blueprint.ext.AbstractPropertyPlaceholder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyPlaceholder
extends AbstractPropertyPlaceholder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyPlaceholder.class);
    private Map defaultProperties;
    private Properties properties;
    private List<URL> locations;
    private boolean ignoreMissingLocations;
    private SystemProperties systemProperties = SystemProperties.fallback;

    public Map getDefaultProperties() {
        return this.defaultProperties;
    }

    public void setDefaultProperties(Map defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public List<URL> getLocations() {
        return this.locations;
    }

    public void setLocations(List<URL> locations) {
        this.locations = locations;
    }

    public boolean isIgnoreMissingLocations() {
        return this.ignoreMissingLocations;
    }

    public void setIgnoreMissingLocations(boolean ignoreMissingLocations) {
        this.ignoreMissingLocations = ignoreMissingLocations;
    }

    public SystemProperties getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(SystemProperties systemProperties) {
        this.systemProperties = systemProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        this.properties = new Properties();
        if (this.locations != null) {
            for (URL url : this.locations) {
                InputStream is = null;
                try {
                    is = url.openStream();
                }
                catch (IOException e) {
                    if (this.ignoreMissingLocations) {
                        LOGGER.debug("Unable to load properties from url " + url + " while ignoreMissingLocations is set to true");
                    }
                    throw e;
                }
                if (is == null) continue;
                try {
                    this.properties.load(is);
                }
                finally {
                    is.close();
                }
            }
        }
    }

    @Override
    protected String getProperty(String val) {
        LOGGER.debug("Retrieving property {}", (Object)val);
        String v = null;
        if (v == null && this.systemProperties == SystemProperties.override && (v = System.getProperty(val)) != null) {
            LOGGER.debug("Found system property {} with value {}", (Object)val, (Object)v);
        }
        if (v == null && this.properties != null && (v = this.properties.getProperty(val)) != null) {
            LOGGER.debug("Found property {} from locations with value {}", (Object)val, (Object)v);
        }
        if (v == null && this.systemProperties == SystemProperties.fallback && (v = System.getProperty(val)) != null) {
            LOGGER.debug("Found system property {} with value {}", (Object)val, (Object)v);
        }
        if (v == null && this.defaultProperties != null && (v = this.defaultProperties.get(val)) != null) {
            LOGGER.debug("Retrieved property {} value from defaults {}", (Object)val, (Object)v);
        }
        if (v == null) {
            LOGGER.debug("Property {} not found", (Object)val);
        }
        return v != null ? v.toString() : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SystemProperties {
        never,
        fallback,
        override;

    }
}

