/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogLevel;
import org.ops4j.pax.runner.commons.Info;

public class PaxRunnerLog
implements Log {
    private final LogLevel m_logLevel;
    private static Log m_me;

    private PaxRunnerLog(LogLevel logLevel) {
        this.m_logLevel = logLevel;
    }

    public boolean isDebugEnabled() {
        return LogLevel.ge(this.m_logLevel, LogLevel.DEBUG);
    }

    public boolean isErrorEnabled() {
        return LogLevel.ge(this.m_logLevel, LogLevel.ERROR);
    }

    public boolean isFatalEnabled() {
        return LogLevel.ge(this.m_logLevel, LogLevel.FATAL);
    }

    public boolean isInfoEnabled() {
        return LogLevel.ge(this.m_logLevel, LogLevel.INFO);
    }

    public boolean isTraceEnabled() {
        return LogLevel.ge(this.m_logLevel, LogLevel.TRACE);
    }

    public boolean isWarnEnabled() {
        return LogLevel.ge(this.m_logLevel, LogLevel.WARNING);
    }

    public void trace(Object message) {
        if (message != null && this.isTraceEnabled()) {
            Info.println(message.toString());
        }
    }

    public void trace(Object message, Throwable t) {
        if (this.isTraceEnabled()) {
            if (message != null) {
                Info.println(message.toString());
            }
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    public void debug(Object message) {
        if (message != null && this.isDebugEnabled()) {
            Info.println(message.toString());
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled()) {
            if (message != null) {
                Info.println(message.toString());
            }
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    public void info(Object message) {
        if (message != null && this.isInfoEnabled()) {
            Info.println(message.toString());
        }
    }

    public void info(Object message, Throwable t) {
        if (this.isInfoEnabled()) {
            if (message != null) {
                Info.println(message.toString());
            }
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    public void warn(Object message) {
        if (message != null && this.isWarnEnabled()) {
            Info.println(message.toString());
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.isWarnEnabled()) {
            if (message != null) {
                Info.println(message.toString());
            }
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    public void error(Object message) {
        if (message != null && this.isErrorEnabled()) {
            Info.println(message.toString());
        }
    }

    public void error(Object message, Throwable t) {
        if (this.isErrorEnabled()) {
            if (message != null) {
                Info.println(message.toString());
            }
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    public void fatal(Object message) {
        if (message != null && this.isFatalEnabled()) {
            Info.println(message.toString());
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.isFatalEnabled()) {
            if (message != null) {
                Info.println(message.toString());
            }
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    public int getLogLevel() {
        return this.m_logLevel.ordinal();
    }

    public static Log newInstance() {
        return PaxRunnerLog.newInstance(LogLevel.NONE);
    }

    public static Log newInstance(LogLevel logLevel) {
        if (m_me == null) {
            m_me = new PaxRunnerLog(logLevel);
        }
        return m_me;
    }
}

