/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.runner.platform.DaemonCommons;
import org.ops4j.pax.runner.platform.JavaRunner;
import org.ops4j.pax.runner.platform.PlatformException;

public class DaemonStopRunner
implements JavaRunner {
    private static final Log LOG = LogFactory.getLog(DaemonStopRunner.class);

    public void exec(String[] vmOptions, String[] classpath, String mainClass, String[] programOptions, String javaHome, File workingDir, String[] environmentVariables) throws PlatformException {
        this.stop(workingDir);
    }

    public void exec(String[] vmOptions, String[] classpath, String mainClass, String[] programOptions, String javaHome, File workingDir) throws PlatformException {
        this.exec(vmOptions, classpath, mainClass, programOptions, javaHome, workingDir, new String[0]);
    }

    private void stop(File workingDir) {
        if (DaemonCommons.isDaemonStarted(workingDir)) {
            try {
                File shutdownFile = new File(workingDir, ".runner.platform.daemon.shutdown");
                shutdownFile.deleteOnExit();
                shutdownFile.createNewFile();
            }
            catch (IOException e) {
                LOG.error("Couldn't connect to: localhost.");
                return;
            }
            do {
                LOG.info("Pax Runner Daemon: Shutdown in progress...");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (DaemonCommons.isDaemonStarted(workingDir));
            LOG.info("Pax Runner Daemon Stopped.");
        } else {
            LOG.warn("No Daemons yet launched!");
        }
    }
}

