/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.util.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.version.Version;
import org.sonatype.aether.version.VersionConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDependencyNode
implements DependencyNode {
    private List<DependencyNode> children = new ArrayList<DependencyNode>(0);
    private Dependency dependency;
    private List<Artifact> relocations = Collections.emptyList();
    private Collection<Artifact> aliases = Collections.emptyList();
    private VersionConstraint versionConstraint;
    private Version version;
    private String premanagedVersion;
    private String premanagedScope;
    private List<RemoteRepository> repositories = Collections.emptyList();
    private String context = "";
    private Map<Object, Object> data = Collections.emptyMap();

    public DefaultDependencyNode() {
    }

    public DefaultDependencyNode(Dependency dependency) {
        this.dependency = dependency;
    }

    public DefaultDependencyNode(DependencyNode node) {
        this.setDependency(node.getDependency());
        this.setAliases(node.getAliases());
        this.setRequestContext(node.getRequestContext());
        this.setPremanagedScope(node.getPremanagedScope());
        this.setPremanagedVersion(node.getPremanagedVersion());
        this.setRelocations(node.getRelocations());
        this.setRepositories(node.getRepositories());
        this.setVersion(node.getVersion());
        this.setVersionConstraint(node.getVersionConstraint());
        this.setData(node.getData());
    }

    @Override
    public List<DependencyNode> getChildren() {
        return this.children;
    }

    @Override
    public Dependency getDependency() {
        return this.dependency;
    }

    public void setDependency(Dependency dependency) {
        this.dependency = dependency;
    }

    @Override
    public void setArtifact(Artifact artifact) {
        this.dependency = this.dependency.setArtifact(artifact);
    }

    @Override
    public List<Artifact> getRelocations() {
        return this.relocations;
    }

    public void setRelocations(List<Artifact> relocations) {
        this.relocations = relocations == null || relocations.isEmpty() ? Collections.emptyList() : relocations;
    }

    @Override
    public Collection<Artifact> getAliases() {
        return this.aliases;
    }

    public void setAliases(Collection<Artifact> aliases) {
        this.aliases = aliases == null || aliases.isEmpty() ? Collections.emptyList() : aliases;
    }

    @Override
    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    public void setVersionConstraint(VersionConstraint versionConstraint) {
        this.versionConstraint = versionConstraint;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public void setScope(String scope) {
        this.dependency = this.dependency.setScope(scope);
    }

    @Override
    public String getPremanagedVersion() {
        return this.premanagedVersion;
    }

    public void setPremanagedVersion(String premanagedVersion) {
        this.premanagedVersion = premanagedVersion;
    }

    @Override
    public String getPremanagedScope() {
        return this.premanagedScope;
    }

    public void setPremanagedScope(String premanagedScope) {
        this.premanagedScope = premanagedScope;
    }

    @Override
    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<RemoteRepository> repositories) {
        this.repositories = repositories == null || repositories.isEmpty() ? Collections.emptyList() : repositories;
    }

    @Override
    public String getRequestContext() {
        return this.context;
    }

    @Override
    public void setRequestContext(String context) {
        this.context = context != null ? context : "";
    }

    @Override
    public Map<Object, Object> getData() {
        return this.data;
    }

    public void setData(Map<Object, Object> data) {
        this.data = data == null ? Collections.emptyMap() : data;
    }

    @Override
    public void setData(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (value == null) {
            if (!this.data.isEmpty()) {
                this.data.remove(key);
                if (this.data.isEmpty()) {
                    this.data = Collections.emptyMap();
                }
            }
        } else {
            if (this.data.isEmpty()) {
                this.data = new HashMap<Object, Object>();
            }
            this.data.put(key, value);
        }
    }

    @Override
    public boolean accept(DependencyVisitor visitor) {
        block1: {
            if (!visitor.visitEnter(this)) break block1;
            for (DependencyNode child : this.getChildren()) {
                if (!child.accept(visitor)) break;
            }
        }
        return visitor.visitLeave(this);
    }

    public String toString() {
        Dependency dep = this.getDependency();
        if (dep == null) {
            return String.valueOf(this.getChildren());
        }
        return dep.toString();
    }
}

