/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import org.apache.catalina.AccessLog;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Executor;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.coyote.http11.Http11Protocol;
import org.apache.tomcat.util.digester.Digester;
import org.ops4j.pax.web.jsp.JspServletWrapper;
import org.ops4j.pax.web.service.spi.Configuration;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.tomcat.internal.HttpServiceContext;
import org.ops4j.pax.web.service.tomcat.internal.OSGiAuthenticatorValve;
import org.ops4j.pax.web.service.tomcat.internal.ServiceValve;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class EmbeddedTomcat
extends Tomcat {
    public static final String SERVER_CONFIG_FILE_NAME = "tomcat-server.xml";
    private static final String[] DEFAULT_MIME_MAPPINGS = new String[]{"abs", "audio/x-mpeg", "ai", "application/postscript", "aif", "audio/x-aiff", "aifc", "audio/x-aiff", "aiff", "audio/x-aiff", "aim", "application/x-aim", "art", "image/x-jg", "asf", "video/x-ms-asf", "asx", "video/x-ms-asf", "au", "audio/basic", "avi", "video/x-msvideo", "avx", "video/x-rad-screenplay", "bcpio", "application/x-bcpio", "bin", "application/octet-stream", "bmp", "image/bmp", "body", "text/html", "cdf", "application/x-cdf", "cer", "application/pkix-cert", "class", "application/java", "cpio", "application/x-cpio", "csh", "application/x-csh", "css", "text/css", "dib", "image/bmp", "doc", "application/msword", "dtd", "application/xml-dtd", "dv", "video/x-dv", "dvi", "application/x-dvi", "eps", "application/postscript", "etx", "text/x-setext", "exe", "application/octet-stream", "gif", "image/gif", "gtar", "application/x-gtar", "gz", "application/x-gzip", "hdf", "application/x-hdf", "hqx", "application/mac-binhex40", "htc", "text/x-component", "htm", "text/html", "html", "text/html", "ief", "image/ief", "jad", "text/vnd.sun.j2me.app-descriptor", "jar", "application/java-archive", "java", "text/x-java-source", "jnlp", "application/x-java-jnlp-file", "jpe", "image/jpeg", "jpeg", "image/jpeg", "jpg", "image/jpeg", "js", "application/javascript", "jsf", "text/plain", "jspf", "text/plain", "kar", "audio/midi", "latex", "application/x-latex", "m3u", "audio/x-mpegurl", "mac", "image/x-macpaint", "man", "text/troff", "mathml", "application/mathml+xml", "me", "text/troff", "mid", "audio/midi", "midi", "audio/midi", "mif", "application/x-mif", "mov", "video/quicktime", "movie", "video/x-sgi-movie", "mp1", "audio/mpeg", "mp2", "audio/mpeg", "mp3", "audio/mpeg", "mp4", "video/mp4", "mpa", "audio/mpeg", "mpe", "video/mpeg", "mpeg", "video/mpeg", "mpega", "audio/x-mpeg", "mpg", "video/mpeg", "mpv2", "video/mpeg2", "nc", "application/x-netcdf", "oda", "application/oda", "odb", "application/vnd.oasis.opendocument.database", "odc", "application/vnd.oasis.opendocument.chart", "odf", "application/vnd.oasis.opendocument.formula", "odg", "application/vnd.oasis.opendocument.graphics", "odi", "application/vnd.oasis.opendocument.image", "odm", "application/vnd.oasis.opendocument.text-master", "odp", "application/vnd.oasis.opendocument.presentation", "ods", "application/vnd.oasis.opendocument.spreadsheet", "odt", "application/vnd.oasis.opendocument.text", "otg", "application/vnd.oasis.opendocument.graphics-template", "oth", "application/vnd.oasis.opendocument.text-web", "otp", "application/vnd.oasis.opendocument.presentation-template", "ots", "application/vnd.oasis.opendocument.spreadsheet-template ", "ott", "application/vnd.oasis.opendocument.text-template", "ogx", "application/ogg", "ogv", "video/ogg", "oga", "audio/ogg", "ogg", "audio/ogg", "spx", "audio/ogg", "flac", "audio/flac", "anx", "application/annodex", "axa", "audio/annodex", "axv", "video/annodex", "xspf", "application/xspf+xml", "pbm", "image/x-portable-bitmap", "pct", "image/pict", "pdf", "application/pdf", "pgm", "image/x-portable-graymap", "pic", "image/pict", "pict", "image/pict", "pls", "audio/x-scpls", "png", "image/png", "pnm", "image/x-portable-anymap", "pnt", "image/x-macpaint", "ppm", "image/x-portable-pixmap", "ppt", "application/vnd.ms-powerpoint", "pps", "application/vnd.ms-powerpoint", "ps", "application/postscript", "psd", "image/vnd.adobe.photoshop", "qt", "video/quicktime", "qti", "image/x-quicktime", "qtif", "image/x-quicktime", "ras", "image/x-cmu-raster", "rdf", "application/rdf+xml", "rgb", "image/x-rgb", "rm", "application/vnd.rn-realmedia", "roff", "text/troff", "rtf", "application/rtf", "rtx", "text/richtext", "sh", "application/x-sh", "shar", "application/x-shar", "sit", "application/x-stuffit", "snd", "audio/basic", "src", "application/x-wais-source", "sv4cpio", "application/x-sv4cpio", "sv4crc", "application/x-sv4crc", "svg", "image/svg+xml", "svgz", "image/svg+xml", "swf", "application/x-shockwave-flash", "t", "text/troff", "tar", "application/x-tar", "tcl", "application/x-tcl", "tex", "application/x-tex", "texi", "application/x-texinfo", "texinfo", "application/x-texinfo", "tif", "image/tiff", "tiff", "image/tiff", "tr", "text/troff", "tsv", "text/tab-separated-values", "txt", "text/plain", "ulw", "audio/basic", "ustar", "application/x-ustar", "vxml", "application/voicexml+xml", "xbm", "image/x-xbitmap", "xht", "application/xhtml+xml", "xhtml", "application/xhtml+xml", "xls", "application/vnd.ms-excel", "xml", "application/xml", "xpm", "image/x-xpixmap", "xsl", "application/xml", "xslt", "application/xslt+xml", "xul", "application/vnd.mozilla.xul+xml", "xwd", "image/x-xwindowdump", "vsd", "application/vnd.visio", "wav", "audio/x-wav", "wbmp", "image/vnd.wap.wbmp", "wml", "text/vnd.wap.wml", "wmlc", "application/vnd.wap.wmlc", "wmls", "text/vnd.wap.wmlsc", "wmlscriptc", "application/vnd.wap.wmlscriptc", "wmv", "video/x-ms-wmv", "wrl", "model/vrml", "wspolicy", "application/wspolicy+xml", "Z", "application/x-compress", "z", "application/x-compress", "zip", "application/zip"};
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedTomcat.class);
    private File configurationDirectory;
    private Integer configurationSessionTimeout;
    private String configurationSessionCookie;
    private String configurationSessionUrl;
    private Boolean configurationSessionCookieHttpOnly;
    private String configurationWorkerName;

    private EmbeddedTomcat() {
    }

    static EmbeddedTomcat newEmbeddedTomcat(Configuration configuration) {
        EmbeddedTomcat result = new EmbeddedTomcat();
        result.getServer().setCatalina((Catalina)new FakeCatalina());
        result.getService().setName("Catalina");
        result.getEngine().setName("Catalina");
        result.configure(configuration);
        return result;
    }

    public void setServer(Server server) {
        Service[] findServices;
        for (Service service : findServices = server.findServices()) {
            Service existingService = this.getServer().findService(service.getName());
            if (existingService != null) {
                for (Connector connector : service.findConnectors()) {
                    existingService.addConnector(connector);
                }
                for (Connector connector : service.findExecutors()) {
                    existingService.addExecutor((Executor)connector);
                }
                for (Connector connector : service.findLifecycleListeners()) {
                    existingService.addLifecycleListener((LifecycleListener)connector);
                }
                existingService.getContainer().setRealm(service.getContainer().getRealm());
                existingService.getContainer().setBackgroundProcessorDelay(service.getContainer().getBackgroundProcessorDelay());
                existingService.getContainer().setCluster(service.getContainer().getCluster());
                continue;
            }
            this.getServer().addService(service);
        }
        this.setHostname(server.getAddress());
        this.setPort(server.getPort());
    }

    void configure(Configuration configuration) {
        File configurationFile;
        long start = System.nanoTime();
        this.initBaseDir(configuration);
        Digester digester = new FakeCatalina().createStartDigester();
        digester.push((Object)this);
        URL tomcatResource = configuration.getConfigurationURL();
        if (tomcatResource == null) {
            tomcatResource = ((Object)((Object)this)).getClass().getResource("/tomcat-server.xml");
        }
        if ((configurationFile = new File(configuration.getConfigurationDir(), SERVER_CONFIG_FILE_NAME)).exists()) {
            try {
                tomcatResource = configurationFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOG.error("Exception while starting Tomcat:", (Throwable)e);
                throw new RuntimeException("Exception while starting Tomcat", e);
            }
        }
        if (tomcatResource != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                LOG.debug("Configure using resource " + tomcatResource);
                digester.parse(tomcatResource.openStream());
                long elapsed = start - System.nanoTime();
                if (LOG.isInfoEnabled()) {
                    LOG.info("configuration processed in {} ms", (Object)(elapsed / 1000000L));
                }
            }
            catch (IOException e) {
                LOG.error("Exception while starting Tomcat:", (Throwable)e);
                throw new RuntimeException("Exception while starting Tomcat", e);
            }
            catch (SAXException e) {
                LOG.error("Exception while starting Tomcat:", (Throwable)e);
                throw new RuntimeException("Exception while starting Tomcat", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
        }
        this.mergeConfiguration(configuration);
    }

    private void mergeConfiguration(Configuration configuration) {
        Connector[] connectors;
        LOG.debug("Start merging configuration");
        Connector httpConnector = null;
        Connector httpSecureConnector = null;
        String[] addresses = configuration.getListeningAddresses();
        if (addresses == null || addresses.length == 0) {
            addresses = new String[]{null};
        }
        HashMap<String, File> attributes = new HashMap<String, File>();
        attributes.put("javax.servlet.context.tempdir", configuration.getTemporaryDirectory());
        this.configurationDirectory = configuration.getConfigurationDir();
        this.configurationSessionTimeout = configuration.getSessionTimeout();
        this.configurationSessionCookie = configuration.getSessionCookie();
        this.configurationSessionUrl = configuration.getSessionUrl();
        this.configurationSessionCookieHttpOnly = configuration.getSessionCookieHttpOnly();
        this.configurationWorkerName = configuration.getWorkerName();
        for (int i = 0; i < addresses.length; ++i) {
            LOG.debug("Loop {} of {}", (Object)i, (Object)addresses.length);
            String address = addresses[i];
            LOG.debug("configuring host with address: {}", (Object)address);
            Host host = null;
            if (i == 0) {
                host = this.getHost();
                LOG.debug("retrieved existing host: {}", (Object)host);
            } else {
                host = new StandardHost();
                LOG.debug("created a new StandardHost: {}", (Object)host);
            }
            host.setName(addresses[i]);
            host.setAutoDeploy(false);
            LOG.debug("re-configured host to {}", (Object)host);
            if (i == 0) {
                this.getEngine().setDefaultHost(address);
                this.getEngine().setBackgroundProcessorDelay(-1);
            }
            if (i <= 0) continue;
            this.getEngine().addChild((Container)host);
        }
        if (configuration.isLogNCSAFormatEnabled().booleanValue()) {
            AccessLogValve ncsaLogger = new AccessLogValve();
            boolean modifiedValve = false;
            for (Host valve : this.getHost().getPipeline().getValves()) {
                if (!(valve instanceof AccessLogValve)) continue;
                modifiedValve = true;
                ncsaLogger = (AccessLog)valve;
            }
            ncsaLogger.setPattern("common");
            ncsaLogger.setDirectory(configuration.getLogNCSADirectory());
            ncsaLogger.setSuffix(".log");
            if (!modifiedValve) {
                this.getHost().getPipeline().addValve((Valve)ncsaLogger);
            }
        }
        Integer httpPort = configuration.getHttpPort();
        Boolean useNIO = configuration.useNIO();
        Integer httpSecurePort = configuration.getHttpSecurePort();
        if (configuration.isHttpEnabled().booleanValue()) {
            LOG.debug("HttpEnabled");
            connectors = this.getService().findConnectors();
            boolean masterConnectorFound = false;
            if (connectors != null && connectors.length > 0) {
                Connector backupConnector = null;
                for (Connector connector : connectors) {
                    if (!(connector instanceof Connector) || connector.getSecure()) continue;
                    if (httpPort.intValue() == connector.getPort() && "HTTP/1.1".equalsIgnoreCase(connector.getProtocol())) {
                        if (httpConnector == null) {
                            httpConnector = connector;
                        }
                        this.configureConnector(configuration, httpPort, useNIO, connector);
                        masterConnectorFound = true;
                        LOG.debug("master connector found, will alter it");
                        continue;
                    }
                    if (backupConnector != null) continue;
                    backupConnector = connector;
                    LOG.debug("backup connector found");
                }
                if (httpConnector == null && backupConnector != null) {
                    LOG.debug("No master connector found will use backup one");
                    httpConnector = backupConnector;
                }
            }
            if (!masterConnectorFound) {
                LOG.debug("No Master connector found create a new one");
                this.connector = new Connector("HTTP/1.1");
                LOG.debug("Reconfiguring master connector");
                this.configureConnector(configuration, httpPort, useNIO, this.connector);
                if (httpConnector == null) {
                    httpConnector = this.connector;
                }
                this.service.addConnector(this.connector);
            }
        } else {
            LOG.debug("Http is disabled any existing http connector will be removed");
            connectors = this.getService().findConnectors();
            if (connectors != null) {
                for (Connector connector : connectors) {
                    if (!(connector instanceof Connector) || connector.getSecure()) continue;
                    LOG.debug("Removing connector {}", (Object)connector);
                    this.getService().removeConnector(connector);
                }
            }
        }
        if (configuration.isHttpSecureEnabled().booleanValue()) {
            String sslPassword = configuration.getSslPassword();
            String sslKeyPassword = configuration.getSslKeyPassword();
            Connector[] connectors2 = this.getService().findConnectors();
            boolean masterSSLConnectorFound = false;
            if (connectors2 != null && connectors2.length > 0) {
                Connector backupConnector = null;
                for (Connector connector : connectors2) {
                    if (!connector.getSecure()) continue;
                    Connector sslCon = connector;
                    if (httpSecurePort.intValue() == connector.getPort()) {
                        httpSecureConnector = sslCon;
                        masterSSLConnectorFound = true;
                        this.configureSSLConnector(configuration, useNIO, httpSecurePort, sslCon);
                        continue;
                    }
                    if (backupConnector != null) continue;
                    backupConnector = connector;
                }
                if (httpSecureConnector == null && backupConnector != null) {
                    httpSecureConnector = backupConnector;
                }
            }
            if (!masterSSLConnectorFound) {
                if (sslPassword != null && sslKeyPassword != null) {
                    Connector secureConnector = new Connector("HTTPS/1.1");
                    this.configureSSLConnector(configuration, useNIO, httpSecurePort, secureConnector);
                    if (httpSecureConnector == null) {
                        httpSecureConnector = secureConnector;
                    }
                    this.getService().addConnector(httpSecureConnector);
                } else {
                    LOG.warn("SSL password and SSL keystore password must be set in order to enable SSL.");
                    LOG.warn("SSL connector will not be started");
                }
            }
        } else {
            connectors = this.getService().findConnectors();
            if (connectors != null) {
                for (Connector connector : connectors) {
                    if (!connector.getSecure()) continue;
                    this.getService().removeConnector(connector);
                }
            }
        }
    }

    private void configureSSLConnector(Configuration configuration, Boolean useNIO, Integer httpSecurePort, Connector secureConnector) {
        secureConnector.setPort(httpSecurePort.intValue());
        secureConnector.setSecure(true);
        secureConnector.setScheme("https");
        secureConnector.setProperty("SSLEnabled", "true");
        secureConnector.setProperty("keystoreFile", configuration.getSslKeystore());
        secureConnector.setProperty("keystorePass", configuration.getSslKeyPassword());
        secureConnector.setProperty("clientAuth", "false");
        secureConnector.setProperty("sslProtocol", "TLS");
        if (useNIO.booleanValue()) {
            secureConnector.setProtocolHandlerClassName(Http11NioProtocol.class.getName());
        } else {
            secureConnector.setProtocolHandlerClassName(Http11Protocol.class.getName());
        }
        if (configuration.getServerMaxThreads() != null) {
            secureConnector.setAttribute("maxThreads", (Object)configuration.getServerMaxThreads());
        }
        if (configuration.getServerMinThreads() != null) {
            secureConnector.setAttribute("minSpareThreads", (Object)configuration.getServerMinThreads());
        }
    }

    private void configureConnector(Configuration configuration, Integer httpPort, Boolean useNIO, Connector connector) {
        LOG.debug("Configuring connector {}", (Object)connector);
        connector.setScheme("http");
        connector.setPort(httpPort.intValue());
        if (configuration.isHttpSecureEnabled().booleanValue()) {
            connector.setRedirectPort(configuration.getHttpSecurePort().intValue());
        }
        if (useNIO.booleanValue()) {
            connector.setProtocolHandlerClassName(Http11NioProtocol.class.getName());
        } else {
            connector.setProtocolHandlerClassName(Http11Protocol.class.getName());
        }
        if (configuration.getServerMaxThreads() != null) {
            connector.setAttribute("maxThreads", (Object)configuration.getServerMaxThreads());
        }
        if (configuration.getServerMinThreads() != null) {
            connector.setAttribute("minSpareThreads", (Object)configuration.getServerMinThreads());
        }
        LOG.debug("configuration done: {}", (Object)connector);
    }

    private void initBaseDir(Configuration configuration) {
        this.setBaseDir(configuration.getTemporaryDirectory().getAbsolutePath());
    }

    String getBasedir() {
        return this.basedir;
    }

    public Context findContext(ContextModel contextModel) {
        String name = this.generateContextName(contextModel.getContextName(), contextModel.getHttpContext());
        return this.findContext(name);
    }

    Context findContext(String contextName) {
        return (Context)this.findContainer(contextName);
    }

    Container findContainer(String contextName) {
        return this.getHost().findChild(contextName);
    }

    public Context addContext(Map<String, String> contextParams, Map<String, Object> contextAttributes, String contextName, HttpContext httpContext, AccessControlContext accessControllerContext, Map<ServletContainerInitializer, Set<Class<?>>> containerInitializers, URL jettyWebXmlURL, List<String> virtualHosts, List<String> connectors, String basedir) {
        this.silence(this.host, "/" + contextName);
        HttpServiceContext ctx = new HttpServiceContext(this.getHost(), accessControllerContext);
        String name = this.generateContextName(contextName, httpContext);
        LOG.info("registering context {}, with context-name: {}", (Object)httpContext, (Object)name);
        ctx.setWebappVersion(name);
        ctx.setName(name);
        ctx.setPath("/" + contextName);
        ctx.setDocBase(basedir);
        ctx.addLifecycleListener((LifecycleListener)new Tomcat.FixContextListener());
        ctx.setSessionCookieName(this.configurationSessionCookie);
        ctx.setUseHttpOnly(this.configurationSessionCookieHttpOnly);
        ctx.setSessionTimeout(this.configurationSessionTimeout);
        ctx.setHttpContext(httpContext);
        if (containerInitializers != null) {
            for (Map.Entry<ServletContainerInitializer, Set<Class<?>>> entry : containerInitializers.entrySet()) {
                ctx.addServletContainerInitializer(entry.getKey(), entry.getValue());
            }
        }
        if (this.isJspAvailable()) {
            try {
                Class<?> loadClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.ops4j.pax.web.jsp.JasperInitializer");
                ctx.addServletContainerInitializer((ServletContainerInitializer)loadClass.newInstance(), null);
            }
            catch (ClassNotFoundException e) {
                LOG.error("Unable to load JasperInitializer", (Throwable)e);
            }
            catch (InstantiationException e) {
                LOG.error("Unable to instantiate JasperInitializer", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error("Unable to instantiate JasperInitializer", (Throwable)e);
            }
        }
        if (this.host == null) {
            ((ContainerBase)this.getHost()).setStartChildren(false);
            this.getHost().addChild((Container)ctx);
        } else {
            ((ContainerBase)this.host).setStartChildren(false);
            this.host.addChild((Container)ctx);
        }
        ctx.getPipeline().addValve((Valve)new ServiceValve(httpContext));
        ctx.getPipeline().addValve((Valve)new OSGiAuthenticatorValve(httpContext));
        int i = 0;
        while (i < DEFAULT_MIME_MAPPINGS.length) {
            ctx.addMimeMapping(DEFAULT_MIME_MAPPINGS[i++], DEFAULT_MIME_MAPPINGS[i++]);
        }
        return ctx;
    }

    public String generateContextName(String contextName, HttpContext httpContext) {
        String name = contextName != null ? "[" + contextName + "]-" + httpContext.getClass().getName() : "[]-" + httpContext.getClass().getName();
        return name;
    }

    private boolean isJspAvailable() {
        try {
            return JspServletWrapper.class != null;
        }
        catch (NoClassDefFoundError ignore) {
            return false;
        }
    }

    private void silence(Host host, String ctx) {
        String base = "org.apache.catalina.core.ContainerBase.[default].[";
        base = host == null ? base + this.getHost().getName() : base + host.getName();
        base = base + "].[";
        base = base + ctx;
        base = base + "]";
        LOG.warn(base);
    }

    private static class FakeCatalina
    extends Catalina {
        private FakeCatalina() {
        }

        protected Digester createStartDigester() {
            Digester digester = super.createStartDigester();
            digester.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            return digester;
        }
    }
}

