/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.catalina.Host;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.StandardContext;
import org.ops4j.pax.web.service.WebContainerContext;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceContext
extends StandardContext {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServiceContext.class);
    private HttpContext httpContext;
    private final AccessControlContext accessControllerContext;

    public HttpServiceContext(Host host, AccessControlContext accessControllerContext) {
        this.accessControllerContext = accessControllerContext;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = new ServletApplicationContext(this);
            if (this.getAltDDName() != null) {
                this.context.setAttribute("org.apache.catalina.deploy.alt_dd", (Object)this.getAltDDName());
            }
        }
        return super.getServletContext();
    }

    public class ServletApplicationContext
    extends ApplicationContext {
        public ServletApplicationContext(StandardContext context) {
            super(context);
        }

        public String getRealPath(String path) {
            File file;
            String fileName;
            String protocol;
            URL resource;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getting real path: [{}]", (Object)path);
            }
            if ((resource = this.getResource(path)) != null && (protocol = resource.getProtocol()).equals("file") && (fileName = resource.getFile()) != null && (file = new File(fileName)).exists()) {
                String realPath = file.getAbsolutePath();
                LOG.debug("found real path: [{}]", (Object)realPath);
                return realPath;
            }
            return null;
        }

        public URL getResource(String path) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getting resource: [" + path + "]");
            }
            URL resource = null;
            try {
                resource = new URL(path);
                LOG.debug("resource: [" + path + "] is already a URL, returning");
                return resource;
            }
            catch (MalformedURLException e) {
                LOG.debug("not a URL or invalid URL: [" + path + "], treating as a file path");
                final String p = path != null && path.endsWith("/") && path.length() > 1 ? path.substring(0, path.length() - 1) : path;
                try {
                    resource = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                        @Override
                        public URL run() throws Exception {
                            return HttpServiceContext.this.httpContext.getResource(p);
                        }
                    }, HttpServiceContext.this.accessControllerContext);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("found resource: " + resource);
                    }
                }
                catch (PrivilegedActionException e2) {
                    LOG.warn("Unauthorized access: " + e2.getMessage());
                }
                return resource;
            }
        }

        public InputStream getResourceAsStream(String path) {
            final URL url = this.getResource(path);
            if (url != null) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                        @Override
                        public InputStream run() throws Exception {
                            try {
                                return url.openStream();
                            }
                            catch (IOException e) {
                                LOG.warn("URL canot be accessed: " + e.getMessage());
                                return null;
                            }
                        }
                    }, HttpServiceContext.this.accessControllerContext);
                }
                catch (PrivilegedActionException e) {
                    LOG.warn("Unauthorized access: " + e.getMessage());
                }
            }
            return null;
        }

        public Set<String> getResourcePaths(final String path) {
            if (HttpServiceContext.this.httpContext instanceof WebContainerContext) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getting resource paths for : [" + path + "]");
                }
                try {
                    Set<String> paths = AccessController.doPrivileged(new PrivilegedExceptionAction<Set<String>>(){

                        @Override
                        public Set<String> run() throws Exception {
                            return ((WebContainerContext)HttpServiceContext.this.httpContext).getResourcePaths(path);
                        }
                    }, HttpServiceContext.this.accessControllerContext);
                    if (paths == null) {
                        return null;
                    }
                    HashSet<String> slashedPaths = new HashSet<String>();
                    for (String foundPath : paths) {
                        if (foundPath == null) continue;
                        if (foundPath.trim().startsWith("/")) {
                            slashedPaths.add(foundPath.trim());
                            continue;
                        }
                        slashedPaths.add("/" + foundPath.trim());
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("found resource paths: " + paths);
                    }
                    return slashedPaths;
                }
                catch (PrivilegedActionException e) {
                    LOG.warn("Unauthorized access: " + e.getMessage());
                    return null;
                }
            }
            return super.getResourcePaths(path);
        }
    }
}

