/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.codec.binary.Base64;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGiAuthenticatorValve
extends AuthenticatorBase {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiAuthenticatorValve.class);
    private static final String DATE_ONE = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US).format(new Date(1L));
    private String authenticationType;
    private final HttpContext httpContext;

    public OSGiAuthenticatorValve(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        boolean authRequired;
        Realm realm;
        SecurityConstraint[] constraints;
        String decodedRequestURI;
        SavedRequest savedRequest;
        Session session;
        Principal principal;
        this.authenticationType = (String)request.getAttribute("org.osgi.service.http.authentication.type");
        String remoteUser = (String)request.getAttribute("org.osgi.service.http.authentication.remote.user");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Security checking request " + request.getMethod() + " " + request.getRequestURI());
        }
        LoginConfig config = this.context.getLoginConfig();
        if (this.cache && (principal = request.getUserPrincipal()) == null && (session = request.getSessionInternal(false)) != null && (principal = session.getPrincipal()) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("We have cached auth type " + session.getAuthType() + " for principal " + session.getPrincipal());
            }
            request.setAuthType(session.getAuthType());
            request.setUserPrincipal(principal);
        }
        String contextPath = this.context.getPath();
        String requestURI = request.getDecodedRequestURI();
        if (requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check") && !this.authenticate(request, (HttpServletResponse)response)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(" Failed authenticate() test ??" + requestURI);
            }
            return;
        }
        Session session2 = request.getSessionInternal(false);
        if (session2 != null && (savedRequest = (SavedRequest)session2.getNote("org.apache.catalina.authenticator.REQUEST")) != null && (decodedRequestURI = request.getDecodedRequestURI()) != null && decodedRequestURI.equals(savedRequest.getDecodedRequestURI()) && !this.authenticate(request, (HttpServletResponse)response)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(" Failed authenticate() test");
            }
            return;
        }
        Wrapper wrapper = request.getMappingData().wrapper;
        if (wrapper != null) {
            wrapper.servletSecurityAnnotationScan();
        }
        if ((constraints = (realm = this.context.getRealm()).findSecurityConstraints(request, this.context)) == null && !this.context.getPreemptiveAuthentication()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(" Not subject to any constraint");
            }
            this.getNext().invoke(request, response);
            return;
        }
        if (constraints != null && this.disableProxyCaching && !"POST".equalsIgnoreCase(request.getMethod())) {
            if (this.securePagesWithPragma) {
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", "no-cache");
            } else {
                response.setHeader("Cache-Control", "private");
            }
            response.setHeader("Expires", DATE_ONE);
        }
        if (constraints != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(" Calling hasUserDataPermission()");
            }
            if (!realm.hasUserDataPermission(request, response, constraints)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" Failed hasUserDataPermission() test");
                }
                return;
            }
        }
        if (constraints == null) {
            authRequired = false;
        } else {
            authRequired = true;
            for (int i = 0; i < constraints.length && authRequired; ++i) {
                String[] roles;
                if (!constraints[i].getAuthConstraint()) {
                    authRequired = false;
                    continue;
                }
                if (constraints[i].getAllRoles() || (roles = constraints[i].findAuthRoles()) != null && roles.length != 0) continue;
                authRequired = false;
            }
        }
        if (!authRequired && this.context.getPreemptiveAuthentication()) {
            boolean bl = authRequired = request.getCoyoteRequest().getMimeHeaders().getValue("authorization") != null;
        }
        if (!authRequired && this.context.getPreemptiveAuthentication()) {
            X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            boolean bl = authRequired = certs != null && certs.length > 0;
        }
        if (authRequired) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(" Calling authenticate()");
            }
            if (!this.authenticate(request, (HttpServletResponse)response)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" Failed authenticate() test");
                }
                return;
            }
        }
        if (constraints != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(" Calling accessControl()");
            }
            if (!realm.hasResourcePermission(request, response, constraints, this.context)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" Failed accessControl() test");
                }
                return;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Successfully passed all security constraints");
        }
        this.getNext().invoke(request, response);
    }

    public boolean authenticate(Request request, HttpServletResponse response) throws IOException {
        block10: {
            MessageBytes authorization;
            Principal principal = request.getUserPrincipal();
            String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
            if (principal != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Already authenticated '" + principal.getName() + "'");
                }
                if (ssoId != null) {
                    this.associate(ssoId, request.getSessionInternal(true));
                }
                return true;
            }
            if (ssoId != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("SSO Id " + ssoId + " set; attempting " + "reauthentication");
                }
                if (this.reauthenticateFromSSO(ssoId, request)) {
                    return true;
                }
            }
            if ((authorization = request.getCoyoteRequest().getMimeHeaders().getValue("authorization")) != null) {
                authorization.toBytes();
                ByteChunk authorizationBC = authorization.getByteChunk();
                BasicCredentials credentials = null;
                try {
                    credentials = new BasicCredentials(authorizationBC);
                    String username = credentials.getUsername();
                    String password = credentials.getPassword();
                    principal = this.context.getRealm().authenticate(username, password);
                    if (principal != null) {
                        this.register(request, response, principal, "BASIC", username, password);
                        return true;
                    }
                }
                catch (IllegalArgumentException iae) {
                    if (!LOG.isDebugEnabled()) break block10;
                    LOG.debug("Invalid Authorization" + iae.getMessage());
                }
            }
        }
        StringBuilder value = new StringBuilder(16);
        value.append("Basic realm=\"");
        value.append(OSGiAuthenticatorValve.getRealmName((Context)this.context));
        value.append('\"');
        response.setHeader("WWW-Authenticate", value.toString());
        response.sendError(401);
        return false;
    }

    protected String getAuthMethod() {
        return this.authenticationType;
    }

    protected static class BasicCredentials {
        private static final String METHOD = "basic ";
        private ByteChunk authorization;
        private int initialOffset;
        private int base64blobOffset;
        private int base64blobLength;
        private String username = null;
        private String password = null;

        public BasicCredentials(ByteChunk input) throws IllegalArgumentException {
            this.authorization = input;
            this.initialOffset = input.getOffset();
            this.parseMethod();
            byte[] decoded = this.parseBase64();
            this.parseCredentials(decoded);
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        private void parseMethod() throws IllegalArgumentException {
            if (!this.authorization.startsWithIgnoreCase(METHOD, 0)) {
                throw new IllegalArgumentException("Authorization header method is not \"Basic\"");
            }
            this.base64blobOffset = this.initialOffset + METHOD.length();
            this.base64blobLength = this.authorization.getLength() - METHOD.length();
        }

        private byte[] parseBase64() throws IllegalArgumentException {
            byte[] decoded = Base64.decodeBase64((byte[])this.authorization.getBuffer(), (int)this.base64blobOffset, (int)this.base64blobLength);
            this.authorization.setOffset(this.initialOffset);
            if (decoded == null) {
                throw new IllegalArgumentException("Basic Authorization credentials are not Base64");
            }
            return decoded;
        }

        private void parseCredentials(byte[] decoded) throws IllegalArgumentException {
            int colon = -1;
            for (int i = 0; i < decoded.length; ++i) {
                if (decoded[i] != 58) continue;
                colon = i;
                break;
            }
            if (colon < 0) {
                this.username = new String(decoded, StandardCharsets.ISO_8859_1);
            } else {
                this.username = new String(decoded, 0, colon, StandardCharsets.ISO_8859_1);
                this.password = new String(decoded, colon + 1, decoded.length - colon - 1, StandardCharsets.ISO_8859_1);
                if (this.password.length() > 1) {
                    this.password = this.password.trim();
                }
            }
            if (this.username.length() > 1) {
                this.username = this.username.trim();
            }
        }
    }
}

