/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.regex.Matcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.ResponseFacade;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(TomcatResourceServlet.class);
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String IF_MATCH = "If-Match";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String IF_RANGE = "If-Range";
    private static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    private static final String KEEP_ALIVE = "Keep-Alive";
    private static final String ETAG = "ETag";
    protected int input = 2048;
    private final HttpContext httpContext;
    private final String contextName;
    private final String alias;
    private final String name;

    public TomcatResourceServlet(HttpContext httpContext, String contextName, String alias, String name) {
        this.httpContext = httpContext;
        this.contextName = "/" + contextName;
        this.alias = alias;
        this.name = "/".equals(name) ? "" : name;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream out;
        if (response.isCommitted()) {
            return;
        }
        String mapping = null;
        Boolean included = request.getAttribute("javax.servlet.include.request_uri") != null;
        if (included != null && included.booleanValue()) {
            String servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            String pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (servletPath == null) {
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
            }
        } else {
            included = Boolean.FALSE;
            if (this.contextName.equals(this.alias)) {
                mapping = !"default".equalsIgnoreCase(this.name) ? this.name + request.getRequestURI() : request.getRequestURI();
            } else {
                mapping = request.getRequestURI().replaceFirst(this.contextName, "/");
                if (!"default".equalsIgnoreCase(this.name)) {
                    mapping = mapping.replaceFirst(this.alias, Matcher.quoteReplacement(this.name));
                }
            }
        }
        URL url = this.httpContext.getResource(mapping);
        if (url == null || url != null && "//".equals(mapping) && "bundleentry".equalsIgnoreCase(url.getProtocol()) || url != null && "/".equals(mapping) && "bundleentry".equalsIgnoreCase(url.getProtocol())) {
            if (!response.isCommitted()) {
                response.sendError(404);
            }
            return;
        }
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            response.sendError(403);
            return;
        }
        try {
            url.openStream();
        }
        catch (IOException ioex) {
            response.sendError(404);
            return;
        }
        String mimeType = this.getServletContext().getMimeType(url.getFile());
        if (mimeType == null) {
            try {
                if (url != null && url.openConnection() != null) {
                    mimeType = url.openConnection().getContentType();
                }
            }
            catch (IOException iOException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (mimeType == null) {
            ServletContext servletContext = this.getServletConfig().getServletContext();
            mimeType = servletContext.getMimeType(mapping);
        }
        if (mimeType != null) {
            response.setContentType(mimeType);
        }
        if ((out = response.getOutputStream()) != null) {
            IOException ioException;
            HttpServletResponse r = response;
            while (r instanceof ServletResponseWrapper) {
                r = ((ServletResponseWrapper)r).getResponse();
            }
            if (r instanceof ResponseFacade) {
                ((ResponseFacade)r).getContentWritten();
            }
            if ((ioException = this.copyRange(url.openStream(), out)) != null) {
                response.sendError(404);
                return;
            }
        }
    }

    protected IOException copyRange(InputStream istream, ServletOutputStream ostream) {
        if (istream == null) {
            return new IOException("Incoming stream is null");
        }
        IOException exception = null;
        byte[] buffer = new byte[this.input];
        int len = buffer.length;
        try {
            while ((len = istream.read(buffer)) != -1) {
                ostream.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }
}

