/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.TomcatURLStreamHandlerFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.descriptor.web.ErrorPage;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.core.BundleUtils;
import org.ops4j.pax.swissbox.core.ContextClassLoaderUtils;
import org.ops4j.pax.web.service.spi.LifeCycle;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.FilterModel;
import org.ops4j.pax.web.service.spi.model.Model;
import org.ops4j.pax.web.service.spi.model.SecurityConstraintMappingModel;
import org.ops4j.pax.web.service.spi.model.ServletModel;
import org.ops4j.pax.web.service.spi.model.WelcomeFileModel;
import org.ops4j.pax.web.service.tomcat.internal.AddErrorPageException;
import org.ops4j.pax.web.service.tomcat.internal.AddFilterException;
import org.ops4j.pax.web.service.tomcat.internal.EmbeddedTomcat;
import org.ops4j.pax.web.service.tomcat.internal.HttpServiceContext;
import org.ops4j.pax.web.service.tomcat.internal.RemoveContextException;
import org.ops4j.pax.web.service.tomcat.internal.RemoveErrorPageException;
import org.ops4j.pax.web.service.tomcat.internal.RemoveEventListenerException;
import org.ops4j.pax.web.service.tomcat.internal.ServerStartException;
import org.ops4j.pax.web.service.tomcat.internal.ServerWrapper;
import org.ops4j.pax.web.service.tomcat.internal.TomcatRemoveServletException;
import org.ops4j.pax.web.service.tomcat.internal.TomcatResourceServlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TomcatServerWrapper
implements ServerWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(TomcatServerWrapper.class);
    private static final String WEB_CONTEXT_PATH = "Web-ContextPath";
    private final EmbeddedTomcat server;
    private final Map<HttpContext, Context> contextMap = new ConcurrentHashMap<HttpContext, Context>();
    private ServiceRegistration<ServletContext> servletContextService;
    private Map<String, Object> contextAttributes;

    private TomcatServerWrapper(EmbeddedTomcat server) {
        NullArgumentException.validateNotNull((Object)server, "server");
        this.server = server;
        ((ContainerBase)server.getHost()).setStartChildren(false);
        TomcatURLStreamHandlerFactory.disable();
    }

    static ServerWrapper getInstance(EmbeddedTomcat server) {
        return new TomcatServerWrapper(server);
    }

    @Override
    public void start() {
        LOG.debug("start server");
        try {
            long t1 = System.nanoTime();
            this.server.getHost();
            this.server.start();
            long t2 = System.nanoTime();
            if (LOG.isInfoEnabled()) {
                LOG.info("TomCat server startup in " + (t2 - t1) / 1000000L + " ms");
            }
        }
        catch (LifecycleException e) {
            throw new ServerStartException(this.server.getServer().toString(), e);
        }
    }

    @Override
    public void stop() {
        LOG.debug("stop server");
        LifecycleState state = this.server.getServer().getState();
        if (LifecycleState.STOPPING_PREP.compareTo((Enum)state) <= 0 && LifecycleState.DESTROYED.compareTo((Enum)state) >= 0) {
            throw new IllegalStateException("stop already called!");
        }
        try {
            this.server.stop();
            this.server.destroy();
        }
        catch (Throwable e) {
            LOG.error("LifecycleException caught {}", e);
        }
    }

    @Override
    public void addServlet(final ServletModel model) {
        LOG.debug("add servlet [{}]", (Object)model);
        final Context context = this.findOrCreateContext(model.getContextModel());
        final String servletName = model.getName();
        if (model.getServlet() == null) {
            try {
                final Servlet servlet = model.getServletFromName();
                if (servlet != null) {
                    this.createServletWrapper(model, context, servletName, servlet);
                    if (!model.getContextModel().isWebBundle()) {
                        context.addLifecycleListener(new LifecycleListener(){

                            public void lifecycleEvent(LifecycleEvent event) {
                                Map servletRegistrations;
                                if ("after_start".equalsIgnoreCase(event.getType()) && !(servletRegistrations = context.getServletContext().getServletRegistrations()).containsKey(servletName)) {
                                    LOG.debug("need to re-register the servlet ...");
                                    TomcatServerWrapper.this.createServletWrapper(model, context, servletName, servlet);
                                }
                            }
                        });
                    }
                } else {
                    final Wrapper sw = context.createWrapper();
                    sw.setServletClass(model.getServletClass().getName());
                    this.addServletWrapper(sw, servletName, context, model);
                    if (!model.getContextModel().isWebBundle()) {
                        context.addLifecycleListener(new LifecycleListener(){

                            public void lifecycleEvent(LifecycleEvent event) {
                                Map servletRegistrations;
                                if ("after_start".equalsIgnoreCase(event.getType()) && !(servletRegistrations = context.getServletContext().getServletRegistrations()).containsKey(servletName)) {
                                    LOG.debug("need to re-register the servlet ...");
                                    sw.setServletClass(model.getServletClass().getName());
                                    TomcatServerWrapper.this.addServletWrapper(sw, servletName, context, model);
                                }
                            }
                        });
                    }
                }
            }
            catch (InstantiationException e) {
                LOG.error("failed to create Servlet", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error("failed to create Servlet", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                LOG.error("failed to create Servlet", (Throwable)e);
            }
            catch (SecurityException e) {
                LOG.error("failed to create Servlet", (Throwable)e);
            }
        } else {
            this.createServletWrapper(model, context, servletName, null);
            if (!model.getContextModel().isWebBundle()) {
                context.addLifecycleListener(new LifecycleListener(){

                    public void lifecycleEvent(LifecycleEvent event) {
                        Map servletRegistrations;
                        if ("before_start".equalsIgnoreCase(event.getType()) && !(servletRegistrations = context.getServletContext().getServletRegistrations()).containsKey(servletName)) {
                            LOG.debug("need to re-register the servlet ...");
                            TomcatServerWrapper.this.createServletWrapper(model, context, servletName, null);
                        }
                    }
                });
            }
        }
    }

    private void createServletWrapper(ServletModel model, Context context, String servletName, Servlet servlet) {
        if (servlet != null) {
            OsgiExistingStandardWrapper sw = new OsgiExistingStandardWrapper(model.getServlet(), model);
            this.addServletWrapper((Wrapper)sw, servletName, context, model);
        } else {
            OsgiExistingStandardWrapper sw = new OsgiExistingStandardWrapper(model.getServlet(), model);
            this.addServletWrapper((Wrapper)sw, servletName, context, model);
        }
    }

    private void addServletWrapper(Wrapper sw, String servletName, Context context, ServletModel model) {
        sw.setName(servletName);
        context.addChild((Container)sw);
        this.addServletMappings(context, servletName, model.getUrlPatterns());
        this.addInitParameters(sw, model.getInitParams());
        if (model.getAsyncSupported() != null) {
            sw.setAsyncSupported(model.getAsyncSupported().booleanValue());
        }
        if (model.getLoadOnStartup() != null) {
            sw.setLoadOnStartup(model.getLoadOnStartup().intValue());
        }
        if (model.getMultipartConfig() != null) {
            sw.setMultipartConfigElement(model.getMultipartConfig());
        }
    }

    @Override
    public void removeServlet(ServletModel model) {
        LOG.debug("remove servlet [{}]", (Object)model);
        Context context = this.findContext((Model)model);
        if (context == null) {
            throw new TomcatRemoveServletException("cannot remove servlet cannot find the associated container: " + model);
        }
        Container servlet = context.findChild(model.getName());
        if (servlet == null) {
            throw new TomcatRemoveServletException("cannot find the servlet to remove: " + model);
        }
        context.removeChild(servlet);
    }

    @Override
    public void removeContext(HttpContext httpContext) {
        LOG.debug("remove context [{}]", (Object)httpContext);
        try {
            if (this.servletContextService != null) {
                this.servletContextService.unregister();
            }
        }
        catch (IllegalStateException e) {
            LOG.info("ServletContext service already removed");
        }
        Context context = this.contextMap.remove(httpContext);
        this.server.getHost().removeChild((Container)context);
        if (context == null) {
            throw new RemoveContextException("cannot remove the context because it does not exist: " + httpContext);
        }
        try {
            LifecycleState state = context.getState();
            if (LifecycleState.DESTROYED != state || LifecycleState.DESTROYING != state) {
                context.destroy();
            }
        }
        catch (LifecycleException e) {
            throw new RemoveContextException("cannot destroy the context: " + httpContext, e);
        }
    }

    @Override
    public void addEventListener(final EventListenerModel eventListenerModel) {
        LOG.debug("add event listener: [{}]", (Object)eventListenerModel);
        final Context context = this.findOrCreateContext((Model)eventListenerModel);
        LifecycleState state = ((HttpServiceContext)context).getState();
        boolean restartContext = false;
        if ((LifecycleState.STARTING.equals((Object)state) || LifecycleState.STARTED.equals((Object)state)) && !eventListenerModel.getContextModel().isWebBundle()) {
            try {
                restartContext = true;
                ((HttpServiceContext)context).stop();
            }
            catch (LifecycleException e) {
                LOG.warn("Can't reset the Lifecycle ... ", (Throwable)e);
            }
        }
        context.addLifecycleListener(new LifecycleListener(){

            public void lifecycleEvent(LifecycleEvent event) {
                if ("before_start".equalsIgnoreCase(event.getType())) {
                    context.getServletContext().addListener(eventListenerModel.getEventListener());
                }
            }
        });
        if (restartContext) {
            try {
                ((HttpServiceContext)context).start();
            }
            catch (LifecycleException e) {
                LOG.warn("Can't reset the Lifecycle ... ", (Throwable)e);
            }
        }
    }

    @Override
    public void removeEventListener(EventListenerModel eventListenerModel) {
        LOG.debug("remove event listener: [{}]", (Object)eventListenerModel);
        NullArgumentException.validateNotNull(eventListenerModel, "eventListenerModel");
        NullArgumentException.validateNotNull(eventListenerModel.getEventListener(), "eventListenerModel#weventListener");
        Context context = this.findOrCreateContext((Model)eventListenerModel);
        if (!this.removeApplicationEventListener(context, eventListenerModel.getEventListener()) && !this.removeApplicationLifecycleListener(context, eventListenerModel.getEventListener())) {
            throw new RemoveEventListenerException("cannot remove the event lister it is a not support class : " + eventListenerModel);
        }
    }

    private boolean removeApplicationLifecycleListener(Context context, EventListener eventListener) {
        if (!this.isApplicationLifecycleListener(eventListener)) {
            return false;
        }
        ArrayList<EventListener> listeners = new ArrayList<EventListener>();
        Object[] applicationLifecycleListeners = context.getApplicationLifecycleListeners();
        boolean found = this.filterEventListener(listeners, applicationLifecycleListeners, eventListener);
        if (found) {
            context.setApplicationLifecycleListeners(listeners.toArray());
        }
        return found;
    }

    private boolean isApplicationLifecycleListener(EventListener eventListener) {
        return eventListener instanceof HttpSessionListener || eventListener instanceof ServletContextListener;
    }

    private boolean removeApplicationEventListener(Context context, EventListener eventListener) {
        if (!this.isApplicationEventListener(eventListener)) {
            return false;
        }
        ArrayList<EventListener> newEventListeners = new ArrayList<EventListener>();
        Object[] applicationEventListeners = context.getApplicationEventListeners();
        boolean found = this.filterEventListener(newEventListeners, applicationEventListeners, eventListener);
        if (found) {
            context.setApplicationEventListeners(newEventListeners.toArray());
        }
        return found;
    }

    private boolean filterEventListener(List<EventListener> listeners, Object[] applicationEventListeners, EventListener eventListener) {
        boolean found = false;
        for (Object object : applicationEventListeners) {
            EventListener listener = (EventListener)object;
            if (listener != eventListener) {
                listeners.add(listener);
                continue;
            }
            found = true;
        }
        return found;
    }

    private boolean isApplicationEventListener(EventListener eventListener) {
        return eventListener instanceof ServletContextAttributeListener || eventListener instanceof ServletRequestListener || eventListener instanceof ServletRequestAttributeListener || eventListener instanceof HttpSessionAttributeListener;
    }

    @Override
    public void addFilter(final FilterModel filterModel) {
        LOG.debug("add filter [{}]", (Object)filterModel);
        final Context context = this.findOrCreateContext((Model)filterModel);
        LifecycleState state = ((HttpServiceContext)context).getState();
        boolean restartContext = false;
        if ((LifecycleState.STARTING.equals((Object)state) || LifecycleState.STARTED.equals((Object)state)) && !filterModel.getContextModel().isWebBundle()) {
            try {
                restartContext = true;
                ((HttpServiceContext)context).stop();
            }
            catch (LifecycleException e) {
                LOG.warn("Can't reset the Lifecycle ... ", (Throwable)e);
            }
        }
        context.addLifecycleListener(new LifecycleListener(){

            public void lifecycleEvent(LifecycleEvent event) {
                if ("before_start".equalsIgnoreCase(event.getType())) {
                    FilterRegistration.Dynamic filterRegistration = null;
                    if (filterModel.getFilter() != null) {
                        filterRegistration = context.getServletContext().addFilter(filterModel.getName(), filterModel.getFilter());
                    } else if (filterModel.getFilterClass() != null) {
                        filterRegistration = context.getServletContext().addFilter(filterModel.getName(), filterModel.getFilterClass());
                    }
                    if (filterRegistration == null && (filterRegistration = (FilterRegistration.Dynamic)context.getServletContext().getFilterRegistration(filterModel.getName())) == null) {
                        LOG.error("Can't register Filter due to unknown reason!");
                    }
                    if (filterModel.getServletNames() != null && filterModel.getServletNames().length > 0) {
                        filterRegistration.addMappingForServletNames(TomcatServerWrapper.this.getDispatcherTypes(filterModel), false, filterModel.getServletNames());
                    } else if (filterModel.getUrlPatterns() != null && filterModel.getUrlPatterns().length > 0) {
                        filterRegistration.addMappingForUrlPatterns(TomcatServerWrapper.this.getDispatcherTypes(filterModel), false, filterModel.getUrlPatterns());
                    } else {
                        throw new AddFilterException("cannot add filter to the context; at least a not empty list of servlet names or URL patterns in exclusive mode must be provided: " + filterModel);
                    }
                    filterRegistration.setInitParameters(filterModel.getInitParams());
                }
            }
        });
        if (restartContext) {
            try {
                ((HttpServiceContext)context).start();
            }
            catch (LifecycleException e) {
                LOG.warn("Can't reset the Lifecycle ... ", (Throwable)e);
            }
        }
    }

    private EnumSet<DispatcherType> getDispatcherTypes(FilterModel filterModel) {
        ArrayList<DispatcherType> dispatcherTypes = new ArrayList<DispatcherType>(DispatcherType.values().length);
        for (String dispatcherType : filterModel.getDispatcher()) {
            dispatcherTypes.add(DispatcherType.valueOf((String)dispatcherType.toUpperCase()));
        }
        EnumSet<Object> result = EnumSet.noneOf(DispatcherType.class);
        if (dispatcherTypes != null && dispatcherTypes.size() > 0) {
            result = EnumSet.copyOf(dispatcherTypes);
        }
        return result;
    }

    @Override
    public void removeFilter(FilterModel filterModel) {
        FilterMap[] filterMaps;
        Context context = this.findOrCreateContext((Model)filterModel);
        FilterDef findFilterDef = context.findFilterDef(filterModel.getName());
        context.removeFilterDef(findFilterDef);
        for (FilterMap filterMap : filterMaps = context.findFilterMaps()) {
            if (!filterMap.getFilterName().equalsIgnoreCase(filterModel.getName())) continue;
            context.removeFilterMap(filterMap);
        }
    }

    @Override
    public void addErrorPage(ErrorPageModel model) {
        Context context = this.findContext((Model)model);
        if (context == null) {
            throw new AddErrorPageException("cannot retrieve the associated context: " + model);
        }
        ErrorPage errorPage = this.createErrorPage(model);
        context.addErrorPage(errorPage);
    }

    private ErrorPage createErrorPage(ErrorPageModel model) {
        NullArgumentException.validateNotNull(model, "model");
        NullArgumentException.validateNotNull(model.getLocation(), "model#location");
        NullArgumentException.validateNotNull(model.getError(), "model#error");
        ErrorPage errorPage = new ErrorPage();
        errorPage.setLocation(model.getLocation());
        Integer errorCode = this.parseErrorCode(model.getError());
        if (errorCode != null) {
            errorPage.setErrorCode(errorCode.intValue());
        } else if (!"org.ops4j.pax.web.error.error_page.global".equalsIgnoreCase(model.getError())) {
            errorPage.setExceptionType(model.getError());
        }
        return errorPage;
    }

    private Integer parseErrorCode(String errorCode) {
        try {
            return Integer.parseInt(errorCode);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public void removeErrorPage(ErrorPageModel model) {
        Context context = this.findContext((Model)model);
        if (context == null) {
            throw new RemoveErrorPageException("cannot retrieve the associated context: " + model);
        }
        ErrorPage errorPage = this.createErrorPage(model);
        context.removeErrorPage(errorPage);
    }

    @Override
    public Servlet createResourceServlet(ContextModel contextModel, String alias, String name) {
        LOG.debug("createResourceServlet( contextModel: {}, alias: {}, name: {})");
        return new TomcatResourceServlet(contextModel.getHttpContext(), contextModel.getContextName(), alias, name);
    }

    @Override
    public void addSecurityConstraintMapping(SecurityConstraintMappingModel secMapModel) {
        LOG.debug("add security contstraint mapping [{}]", (Object)secMapModel);
        Context context = this.findOrCreateContext(secMapModel.getContextModel());
        String mappingMethod = secMapModel.getMapping();
        String constraintName = secMapModel.getConstraintName();
        String url = secMapModel.getUrl();
        String dataConstraint = secMapModel.getDataConstraint();
        List roles = secMapModel.getRoles();
        boolean authentication = secMapModel.isAuthentication();
        SecurityConstraint[] constraints = context.findConstraints();
        SecurityConstraint secConstraint = new SecurityConstraint();
        boolean foundExisting = false;
        for (SecurityConstraint securityConstraint : constraints) {
            if (!securityConstraint.getDisplayName().equalsIgnoreCase(constraintName)) continue;
            secConstraint = securityConstraint;
            foundExisting = true;
        }
        if (!foundExisting) {
            secConstraint.setDisplayName(secMapModel.getConstraintName());
            secConstraint.setAuthConstraint(authentication);
            for (String authRole : roles) {
                secConstraint.addAuthRole(authRole);
            }
            secConstraint.setUserConstraint(dataConstraint);
            context.addConstraint(secConstraint);
        }
        SecurityCollection collection = new SecurityCollection();
        collection.addMethod(mappingMethod);
        collection.addPattern(url);
        secConstraint.addCollection(collection);
    }

    @Override
    public LifeCycle getContext(ContextModel model) {
        final Context context = this.findOrCreateContext(model);
        if (context == null) {
            throw new RemoveErrorPageException("cannot retrieve the associated context: " + model);
        }
        return new LifeCycle(){

            public void start() throws Exception {
                ContainerBase host = (ContainerBase)TomcatServerWrapper.this.server.getHost();
                host.setStartChildren(true);
                if (!context.getState().isAvailable()) {
                    LOG.info("server is available, in state {}", (Object)context.getState());
                    ContextClassLoaderUtils.doWithClassLoader(context.getParentClassLoader(), new Callable<Void>(){

                        @Override
                        public Void call() throws LifecycleException {
                            context.start();
                            return null;
                        }
                    });
                }
            }

            public void stop() throws Exception {
                context.stop();
            }
        };
    }

    private void addServletMappings(Context context, String servletName, String[] urlPatterns) {
        NullArgumentException.validateNotNull(urlPatterns, "urlPatterns");
        for (String urlPattern : urlPatterns) {
            context.addServletMapping(urlPattern, servletName);
        }
    }

    private void addInitParameters(Wrapper wrapper, Map<String, String> initParameters) {
        NullArgumentException.validateNotNull(initParameters, "initParameters");
        NullArgumentException.validateNotNull(wrapper, "wrapper");
        for (Map.Entry<String, String> initParam : initParameters.entrySet()) {
            wrapper.addInitParameter(initParam.getKey(), initParam.getValue());
        }
    }

    private Context findOrCreateContext(Model model) {
        NullArgumentException.validateNotNull(model, "model");
        return this.findOrCreateContext(model.getContextModel());
    }

    private Context findOrCreateContext(ContextModel contextModel) {
        HttpContext httpContext = contextModel.getHttpContext();
        Context context = this.contextMap.get(httpContext);
        if (context == null) {
            context = this.createContext(contextModel);
        }
        return context;
    }

    private Context createContext(ContextModel contextModel) {
        Bundle bundle = contextModel.getBundle();
        BundleContext bundleContext = BundleUtils.getBundleContext(bundle);
        Context context = this.server.addContext(contextModel.getContextParams(), this.getContextAttributes(bundleContext), contextModel.getContextName(), contextModel.getHttpContext(), contextModel.getAccessControllerContext(), contextModel.getContainerInitializers(), contextModel.getJettyWebXmlURL(), contextModel.getVirtualHosts(), null, this.server.getBasedir());
        context.setParentClassLoader(contextModel.getClassLoader());
        LifecycleState state = context.getState();
        if (state != LifecycleState.STARTED && state != LifecycleState.STARTING && state != LifecycleState.STARTING_PREP) {
            LOG.debug("Registering ServletContext as service. ");
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("osgi.web.symbolicname", bundle.getSymbolicName());
            Dictionary headers = bundle.getHeaders();
            String version = (String)headers.get("Bundle-Version");
            if (version != null && version.length() > 0) {
                ((Dictionary)properties).put("osgi.web.version", version);
            }
            String webContextPath = (String)headers.get(WEB_CONTEXT_PATH);
            String webappContext = (String)headers.get("Webapp-Context");
            ServletContext servletContext = context.getServletContext();
            if ("/".equalsIgnoreCase(context.getPath()) && (webContextPath == null || webappContext == null)) {
                webContextPath = context.getPath();
            }
            String string = webContextPath = webContextPath != null ? webContextPath : webappContext;
            if (webContextPath != null && !webContextPath.startsWith("/")) {
                webContextPath = "/" + webContextPath;
            }
            if (webContextPath == null) {
                LOG.warn("osgi.web.contextpath couldn't be set, it's not configured");
            }
            ((Dictionary)properties).put("osgi.web.contextpath", webContextPath);
            this.servletContextService = bundleContext.registerService(ServletContext.class, (Object)servletContext, properties);
            LOG.debug("ServletContext registered as service. ");
        }
        this.contextMap.put(contextModel.getHttpContext(), context);
        return context;
    }

    private Context findContext(ContextModel contextModel) {
        return this.server.findContext(contextModel);
    }

    private Context findContext(Model model) {
        return this.findContext(model.getContextModel());
    }

    private Map<String, Object> getContextAttributes(BundleContext bundleContext) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (this.contextAttributes != null) {
            attributes.putAll(this.contextAttributes);
        }
        attributes.put("osgi-bundlecontext", bundleContext);
        attributes.put("org.springframework.osgi.web.org.osgi.framework.BundleContext", bundleContext);
        return attributes;
    }

    @Override
    public void addWelcomeFiles(WelcomeFileModel model) {
        Context context = this.findOrCreateContext(model.getContextModel());
        for (String welcomeFile : model.getWelcomeFiles()) {
            context.addWelcomeFile(welcomeFile);
        }
    }

    @Override
    public void removeWelcomeFiles(WelcomeFileModel model) {
        Context context = this.findOrCreateContext(model.getContextModel());
        for (String welcomeFile : model.getWelcomeFiles()) {
            context.removeWelcomeFile(welcomeFile);
        }
    }

    private final class OsgiExistingStandardWrapper
    extends Tomcat.ExistingStandardWrapper {
        private final ServletModel model;

        private OsgiExistingStandardWrapper(Servlet existing, ServletModel model) {
            super(existing);
            this.model = model;
        }

        public synchronized void load() throws ServletException {
            try {
                this.instance = ContextClassLoaderUtils.doWithClassLoader(this.model.getContextModel().getClassLoader(), new Callable<Servlet>(){

                    @Override
                    public Servlet call() {
                        try {
                            return OsgiExistingStandardWrapper.this.loadServlet();
                        }
                        catch (ServletException e) {
                            LOG.warn("Caucht exception while loading Servlet with classloader {}", (Throwable)e);
                            return null;
                        }
                    }
                });
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                LOG.error("Ignored exception during servlet registration", (Throwable)e);
            }
            if (!this.instanceInitialized) {
                this.initServlet(this.instance);
            }
        }

        private synchronized void initServlet(Servlet servlet) throws ServletException {
            if (this.instanceInitialized && !this.singleThreadModel) {
                return;
            }
            try {
                this.instanceSupport.fireInstanceEvent("beforeInit", servlet);
                if (Globals.IS_SECURITY_ENABLED) {
                    Object[] args = new Object[]{this.facade};
                    SecurityUtil.doAsPrivilege((String)"init", (Servlet)servlet, (Class[])classType, (Object[])args);
                    args = null;
                } else {
                    servlet.init((ServletConfig)this.facade);
                }
                this.instanceInitialized = true;
                this.instanceSupport.fireInstanceEvent("afterInit", servlet);
            }
            catch (UnavailableException f) {
                this.instanceSupport.fireInstanceEvent("afterInit", servlet, (Throwable)f);
                this.unavailable(f);
                throw f;
            }
            catch (ServletException f) {
                this.instanceSupport.fireInstanceEvent("afterInit", servlet, (Throwable)f);
                throw f;
            }
            catch (Throwable f) {
                ExceptionUtils.handleThrowable((Throwable)f);
                this.getServletContext().log("StandardWrapper.Throwable", f);
                this.instanceSupport.fireInstanceEvent("afterInit", servlet, f);
                throw new ServletException(sm.getString("standardWrapper.initException", new Object[]{this.getName()}), f);
            }
        }
    }
}

