/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.tomcat.util.digester.Digester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGiMemoryRealm
extends MemoryRealm {
    private static final Logger log = LoggerFactory.getLogger(OSGiMemoryRealm.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startInternal() throws LifecycleException {
        if (this.getPathname().startsWith("classpath")) {
            String pathName = this.getPathname();
            try {
                URL pathUrl = new URL(pathName);
                pathName = pathUrl.getHost();
            }
            catch (MalformedURLException e) {
                log.error("Pathname URL is a malformed URL", (Throwable)e);
            }
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(pathName);
            if (inputStream == null) {
                try {
                    Enumeration<URL> resources = classLoader.getResources(pathName);
                    while (resources.hasMoreElements()) {
                        URL nextElement = resources.nextElement();
                        inputStream = nextElement.openStream();
                    }
                }
                catch (IOException e) {
                    log.warn("IOException while iterating over resources", (Throwable)e);
                }
            }
            Digester digester = this.getDigester();
            try {
                Digester e = digester;
                synchronized (e) {
                    digester.push((Object)this);
                    digester.parse(inputStream);
                }
            }
            catch (Exception e) {
                throw new LifecycleException(sm.getString("memoryRealm.readXml"), (Throwable)e);
            }
            finally {
                digester.reset();
            }
            if (this.digest != null) {
                try {
                    this.md = MessageDigest.getInstance(this.digest);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new LifecycleException(sm.getString("realmBase.algorithm", new Object[]{this.digest}), (Throwable)e);
                }
            }
            this.setState(LifecycleState.STARTING);
        } else {
            super.startInternal();
        }
    }
}

