/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.connector.ResponseFacade;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final int SECOND = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(TomcatResourceServlet.class);
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String IF_MATCH = "If-Match";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String IF_RANGE = "If-Range";
    private static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    private static final String KEEP_ALIVE = "Keep-Alive";
    private static final String ETAG = "ETag";
    protected int input = 2048;
    private final HttpContext httpContext;
    private final String contextName;
    private final String alias;
    private final String name;
    private final Context context;
    private String[] welcomes;

    public TomcatResourceServlet(HttpContext httpContext, String contextName, String alias, String name, Context context) {
        this.httpContext = httpContext;
        this.contextName = "/" + contextName;
        this.alias = alias;
        this.name = "/".equals(name) ? "" : name;
        this.context = context;
    }

    public void init() throws ServletException {
        this.welcomes = this.context.findWelcomeFiles();
        if (this.welcomes == null) {
            this.welcomes = new String[]{"index.html", "index.jsp"};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (response.isCommitted()) {
            return;
        }
        String mapping = null;
        Boolean included = request.getAttribute("javax.servlet.include.request_uri") != null;
        String pathInfo = null;
        if (included.booleanValue()) {
            String servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (servletPath == null) {
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
            }
            mapping = TomcatResourceServlet.addPaths(servletPath, pathInfo);
        } else {
            included = Boolean.FALSE;
            mapping = request.getRequestURI();
            if (!"/".equals(this.contextName)) {
                mapping = mapping.substring(this.contextName.length());
            }
            if (!"/".equals(this.alias)) {
                mapping = mapping.substring(this.alias.length());
            }
            if (!this.name.isEmpty() && !"default".equals(this.name)) {
                mapping = this.name + mapping;
            }
        }
        boolean endsWithSlash = (mapping == null ? request.getServletPath() : mapping).endsWith("/");
        URL url = this.httpContext.getResource(mapping);
        if (url == null || "//".equals(mapping) && "bundleentry".equalsIgnoreCase(url.getProtocol()) || "/".equals(mapping) && "bundleentry".equalsIgnoreCase(url.getProtocol())) {
            if (response.isCommitted()) return;
            response.sendError(404);
            return;
        }
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            response.sendError(403);
            return;
        }
        URLConnection connection = null;
        try {
            IOException ioException;
            ServletOutputStream out;
            long modifiedSince;
            boolean foundResource;
            try {
                connection = url.openConnection();
                connection.connect();
                foundResource = true;
            }
            catch (IOException ioex) {
                foundResource = false;
            }
            if (!foundResource && !endsWithSlash) {
                if (response.isCommitted()) return;
                response.sendError(404);
                return;
            }
            String welcome = this.getWelcomeFile(mapping);
            if (null != welcome) {
                LOG.debug("welcome={}", (Object)welcome);
                RequestDispatcher dispatcher = request.getRequestDispatcher(welcome);
                if (dispatcher != null) {
                    if (included.booleanValue()) {
                        dispatcher.include((ServletRequest)request, (ServletResponse)response);
                        return;
                    }
                    dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                    return;
                }
            } else if (!foundResource) {
                if (response.isCommitted()) return;
                response.sendError(404);
                return;
            }
            String eTag = String.valueOf(connection.getLastModified());
            if (request.getHeader(IF_NONE_MATCH) != null && eTag.equals(request.getHeader(IF_NONE_MATCH))) {
                response.setStatus(304);
                return;
            }
            if (request.getHeader(IF_MODIFIED_SINCE) != null) {
                long ifModifiedSince = request.getDateHeader(IF_MODIFIED_SINCE);
                if (connection.getLastModified() > 0L && connection.getLastModified() / 1000L <= ifModifiedSince / 1000L) {
                    response.reset();
                    response.setStatus(304);
                    response.flushBuffer();
                    return;
                }
            } else if (request.getHeader(IF_UNMODIFIED_SINCE) != null && (modifiedSince = request.getDateHeader(IF_UNMODIFIED_SINCE)) != -1L && connection.getLastModified() / 1000L > modifiedSince / 1000L) {
                response.sendError(412);
                return;
            }
            response.setHeader(ETAG, eTag);
            String mimeType = this.getServletContext().getMimeType(url.getFile());
            if (mimeType == null) {
                try {
                    if (url.openConnection() != null) {
                        mimeType = url.openConnection().getContentType();
                    }
                }
                catch (IOException | NullPointerException exception) {
                    // empty catch block
                }
            }
            if (mimeType == null) {
                ServletContext servletContext = this.getServletConfig().getServletContext();
                mimeType = servletContext.getMimeType(mapping);
            }
            if (mimeType != null) {
                response.setContentType(mimeType);
            }
            if ((out = response.getOutputStream()) == null) return;
            HttpServletResponse r = response;
            while (r instanceof ServletResponseWrapper) {
                r = ((ServletResponseWrapper)r).getResponse();
            }
            if (r instanceof ResponseFacade) {
                ((ResponseFacade)r).getContentWritten();
            }
            if ((ioException = this.copyRange(url.openStream(), out)) == null) return;
            response.sendError(404);
            return;
        }
        finally {
            if (connection != null) {
                try {
                    connection.getInputStream().close();
                }
                catch (IOException ioex) {}
            }
        }
    }

    private String getWelcomeFile(String pathInContext) throws MalformedURLException, IOException {
        if (this.welcomes == null) {
            return null;
        }
        String welcomeServlet = null;
        for (int i = 0; i < this.welcomes.length; ++i) {
            String welcomeInContext = TomcatResourceServlet.addPaths(pathInContext, this.welcomes[i]);
            if (this.httpContext.getResource(welcomeInContext) == null) continue;
            return this.welcomes[i];
        }
        return welcomeServlet;
    }

    private static String addPaths(String p1, String p2) {
        if (p1 == null || p1.length() == 0) {
            if (p1 != null && p2 == null) {
                return p1;
            }
            return p2;
        }
        if (p2 == null || p2.length() == 0) {
            return p1;
        }
        int split = p1.indexOf(59);
        if (split < 0) {
            split = p1.indexOf(63);
        }
        if (split == 0) {
            return p2 + p1;
        }
        if (split < 0) {
            split = p1.length();
        }
        StringBuilder buf = new StringBuilder(p1.length() + p2.length() + 2);
        buf.append(p1);
        if (buf.charAt(split - 1) == '/') {
            if (p2.startsWith("/")) {
                buf.deleteCharAt(split - 1);
                buf.insert(split - 1, p2);
            } else {
                buf.insert(split, p2);
            }
        } else if (p2.startsWith("/")) {
            buf.insert(split, p2);
        } else {
            buf.insert(split, '/');
            buf.insert(split + 1, p2);
        }
        return buf.toString();
    }

    protected IOException copyRange(InputStream istream, ServletOutputStream ostream) {
        if (istream == null) {
            return new IOException("Incoming stream is null");
        }
        IOException exception = null;
        byte[] buffer = new byte[this.input];
        int len = buffer.length;
        try {
            while ((len = istream.read(buffer)) != -1) {
                ostream.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }
}

