/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import org.ops4j.pax.web.service.spi.Configuration;
import org.ops4j.pax.web.service.tomcat.internal.ActiveServerState;
import org.ops4j.pax.web.service.tomcat.internal.InitializedServerState;
import org.ops4j.pax.web.service.tomcat.internal.InstalledServerState;
import org.ops4j.pax.web.service.tomcat.internal.ServerFactory;
import org.ops4j.pax.web.service.tomcat.internal.ServerState;
import org.ops4j.pax.web.service.tomcat.internal.ServerStateFactory;
import org.ops4j.pax.web.service.tomcat.internal.ServerWrapper;

public class TomcatServerStateFactory
implements ServerStateFactory {
    private final ServerFactory serverFactory;

    TomcatServerStateFactory(ServerFactory serverFactory) {
        this.serverFactory = serverFactory;
    }

    @Override
    public ServerState newInstalledState() {
        return InstalledServerState.getInstance(this);
    }

    @Override
    public ServerState newActiveState(ServerWrapper server, ServerState serverState) {
        if (serverState == null) {
            throw new IllegalArgumentException("server state parameter must be not null");
        }
        if (serverState.getState() != ServerState.States.INITIALIZED) {
            throw new IllegalArgumentException(String.format("server state parameter must be in state: '%s'; and not: '%s'", new Object[]{ServerState.States.INITIALIZED, serverState.getState()}));
        }
        return ActiveServerState.getInstance(this, serverState, server);
    }

    @Override
    public ServerState newInitializedState(Configuration configuration) {
        return InitializedServerState.getInstance(this, configuration, this.serverFactory);
    }

    static ServerStateFactory newInstance(ServerFactory serverFactory) {
        return new TomcatServerStateFactory(serverFactory);
    }
}

