/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree.signature;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.signature.TypeSignature;
import org.objectweb.asm.tree.signature.TypeSignatureFactory;

public class TypeParameter
extends SignatureVisitor {
    public String name;
    public TypeSignature classBound;
    public List<TypeSignature> interfaceBounds;
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;

    public TypeParameter(int api) {
        super(api);
    }

    public void visitFormalTypeParameter(String name) {
        this.name = name;
    }

    public SignatureVisitor visitClassBound() {
        return new TypeSignatureFactory(this.api, this);
    }

    public SignatureVisitor visitInterfaceBound() {
        if (this.interfaceBounds == null) {
            this.interfaceBounds = new ArrayList<TypeSignature>();
        }
        return new TypeSignatureFactory(this.api, this.interfaceBounds);
    }

    public void accept(SignatureVisitor sv) {
        sv.visitFormalTypeParameter(this.name);
        if (this.classBound != null) {
            this.classBound.accept(sv.visitClassBound());
        }
        if (this.interfaceBounds != null) {
            for (TypeSignature s : this.interfaceBounds) {
                s.accept(sv.visitInterfaceBound());
            }
        }
    }
}

