/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree.signature;

import java.util.List;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.tree.signature.ArrayType;
import org.objectweb.asm.tree.signature.ClassSignature;
import org.objectweb.asm.tree.signature.ClassType;
import org.objectweb.asm.tree.signature.MethodSignature;
import org.objectweb.asm.tree.signature.PrimitiveType;
import org.objectweb.asm.tree.signature.TypeArgument;
import org.objectweb.asm.tree.signature.TypeParameter;
import org.objectweb.asm.tree.signature.TypeSignature;
import org.objectweb.asm.tree.signature.TypeVariable;

public class TypeSignatureFactory
extends SignatureVisitor {
    Object target;
    private TypeSignature value;

    public TypeSignatureFactory(int api) {
        super(api);
    }

    TypeSignatureFactory(int api, Object target) {
        super(api);
        this.target = target;
    }

    public void visitBaseType(char descriptor) {
        if (descriptor != 'V') {
            this.value = new PrimitiveType(this.api);
            this.value.visitBaseType(descriptor);
        }
        this.storeValue();
    }

    public void visitTypeVariable(String name) {
        this.value = new TypeVariable(this.api);
        this.value.visitTypeVariable(name);
        this.storeValue();
    }

    public SignatureVisitor visitArrayType() {
        this.value = new ArrayType(this.api);
        this.storeValue();
        return this.value;
    }

    public void visitClassType(String name) {
        this.value = new ClassType(this.api);
        this.value.visitClassType(name);
        this.storeValue();
    }

    public void visitInnerClassType(String name) {
        this.value.visitInnerClassType(name);
    }

    public void visitTypeArgument() {
        this.value.visitTypeArgument();
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        return this.value.visitTypeArgument(wildcard);
    }

    public TypeSignature getValue() {
        return this.value;
    }

    private void storeValue() {
        if (this.target == null) {
            return;
        }
        if (this.target instanceof List) {
            ((List)this.target).add(this.value);
        } else if (this.target instanceof ClassSignature) {
            ((ClassSignature)this.target).superClass = this.value;
        } else if (this.target instanceof MethodSignature) {
            ((MethodSignature)this.target).result = this.value;
        } else if (this.target instanceof TypeArgument) {
            ((TypeArgument)this.target).bound = this.value;
        } else if (this.target instanceof TypeParameter) {
            ((TypeParameter)this.target).classBound = this.value;
        }
    }
}

