/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2005-2006 EBM WebSourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id: RemoteMessageExchangeFactoryImpl.java,v 1.1 2007/06/11 13:34:07 lam Exp $
 * -------------------------------------------------------------------------
 */

package org.objectweb.petals.tools.rmi.server.remote.implementations;

import java.net.URI;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;

import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.RobustInOnly;
import javax.xml.namespace.QName;

import org.objectweb.petals.tools.rmi.server.remote.interfaces.RemoteMessageExchangeFactory;
import org.objectweb.petals.tools.rmi.server.util.Convert;

/**
 * the RMI Message Exchange Factory.
 * @author nsalatge
 *
 */
public class RemoteMessageExchangeFactoryImpl
extends UnicastRemoteObject implements RemoteMessageExchangeFactory {


    /**
     * the serialVersionUID.
     */
    private static final long serialVersionUID = -7802199904640493500L;

    /**
     * the concrete message exchange factory.
     */
    private MessageExchangeFactory concreteMef;


	/**
	 * HasMap containing all the messages exchanges.
	 */
	private Map<String, MessageExchange> messages;

    /**
     * the constructor.
     * @param msgs
	 *         the messages
     * @param concreteMef
     *         the concrete message exchange factory
     * @throws RemoteException
     *         impossible to realize a remote access
     */
    public RemoteMessageExchangeFactoryImpl(final Map<String, MessageExchange> msgs,
            final MessageExchangeFactory concreteMef) throws RemoteException {
        super();
        this.concreteMef = concreteMef;
        this.messages = msgs;
    }


    /**
     * TODO find an endpoint for this parameteters. Return a
     * <code>MessageExchangeDecorator</code> for Consumer
     *
     * @see javax.jbi.messaging.MessageExchangeFactory#createExchange(javax.xml.namespace.QName,
     *      javax.xml.namespace.QName)
     * @param serviceName
     *          the service name
     * @param operationName
     *          the operationName
     * @return
     *        the message exchange
     * @throws MessagingException
     *        impossible to create the message exchange
     */
    public MessageExchange createExchange(
            final QName serviceName, final QName operationName)
    throws MessagingException {
        // Create the concrete message exchange
        MessageExchange meC = this.concreteMef.createExchange(serviceName, operationName);


        // Convert into fake message exchange
        MessageExchange meF = Convert.
        convertConcreteMessageExchangeToFakeMessageExchange(meC, null);
        ((org.objectweb.petals.tools.rmi.common.serializable.
                MessageExchange) meF).setRole(meC.getRole());

        // Store the messages
        this.messages.put(meF.getExchangeId(), meC);

        return meF;
    }

    /**
     * Return a <code>MessageExchangeDecorator</code> for Consumer, as
     * <code>InOnlyExchange, InOutExchange,...</code>
     *
     * @see javax.jbi.messaging.MessageExchangeFactory#createExchange(java.net.URI)
     * @param pattern
     *          the pattern
     * @return
     *        the message exchange
     * @throws MessagingException
     *        impossible to create the message exchange
     */
    public MessageExchange createExchange(final URI pattern)
    throws MessagingException {
        // Create the concrete message exchange
        MessageExchange meC = this.concreteMef.createExchange(pattern);


        // Convert into fake message exchange
        MessageExchange meF = Convert.
        convertConcreteMessageExchangeToFakeMessageExchange(meC, null);
        ((org.objectweb.petals.tools.rmi.common.serializable.
                MessageExchange) meF).setRole(meC.getRole());

        // Store the messages
        this.messages.put(meF.getExchangeId(), meC);

        return meF;
    }


    /**
     * Return a <code>MessageExchangeDecorator</code> for Consumer, as
     * <code>InOnly</code>.
     *
     * @see javax.jbi.messaging.MessageExchangeFactory#createInOnlyExchange()
     * @return
     *        the message exchange
     * @throws MessagingException
     *        impossible to create the message exchange
     */
    public InOnly createInOnlyExchange() throws MessagingException {
        // Create the concrete message exchange
        MessageExchange meC = this.concreteMef.createInOnlyExchange();

        // Convert into fake message exchange
        InOnly meF =  (InOnly) Convert.
        convertConcreteMessageExchangeToFakeMessageExchange(meC, Convert.IN_ONLY_PATTERN);
        ((org.objectweb.petals.tools.rmi.common.serializable.
                MessageExchange) meF).setRole(meC.getRole());

        // Store the messages
        this.messages.put(meF.getExchangeId(), meC);

        return meF;
    }

    /**
     * Return a <code>MessageExchangeDecorator</code> for Consumer, as
     * <code>InOptionalOut</code>.
     *
     * @see javax.jbi.messaging.MessageExchangeFactory#createInOptionalOutExchange()
     * @return
     *        the message exchange
     * @throws MessagingException
     *        impossible to create the message exchange
     */
    public InOptionalOut createInOptionalOutExchange()
    throws MessagingException {
        // Create the concrete message exchange
        MessageExchange meC = this.concreteMef.createInOptionalOutExchange();


        // Convert into fake message exchange
        InOptionalOut meF = (InOptionalOut) Convert.
        convertConcreteMessageExchangeToFakeMessageExchange(meC,
                Convert.IN_OPTIONAL_OUT_PATTERN);
        ((org.objectweb.petals.tools.rmi.common.serializable.
                MessageExchange) meF).setRole(meC.getRole());

        // Store the messages
        this.messages.put(meF.getExchangeId(), meC);

        return meF;
    }

    /**
     * Return a <code>MessageExchangeDecorator</code> for Consumer, as
     * <code>InOut</code>.
     *
     * @see javax.jbi.messaging.MessageExchangeFactory#createInOutExchange()
     * @return
     *        the message exchange
     * @throws MessagingException
     *        impossible to create the message exchange
     */
    public InOut createInOutExchange() throws MessagingException {
        // Create the concrete message exchange
        MessageExchange meC = this.concreteMef.createInOutExchange();

        // Convert into fake message exchange
        InOut meF = (InOut) Convert.
        convertConcreteMessageExchangeToFakeMessageExchange(meC,
                Convert.IN_OUT_PATTERN);
        ((org.objectweb.petals.tools.rmi.common.serializable.
                MessageExchange) meF).setRole(meC.getRole());

        // Store the messages
        this.messages.put(meF.getExchangeId(), meC);

        return meF;
    }

    /**
     * Return a <code>MessageExchangeDecorator</code> for Consumer, as
     * <code>RobustInOnly</code>.
     *
     * @see javax.jbi.messaging.MessageExchangeFactory#createRobustInOnlyExchange()
     * @return
     *        the message exchange
     * @throws MessagingException
     *        impossible to create the message exchange
     */
    public RobustInOnly createRobustInOnlyExchange() throws MessagingException {
        // Create the concrete message exchange
        MessageExchange meC = this.concreteMef.createRobustInOnlyExchange();

        // Convert into fake message exchange
        RobustInOnly meF = (RobustInOnly) Convert.
        convertConcreteMessageExchangeToFakeMessageExchange(meC,
                Convert.ROBUST_IN_ONLY_PATTERN);
        ((org.objectweb.petals.tools.rmi.common.serializable.
                MessageExchange) meF).setRole(meC.getRole());

        // Store the messages
        this.messages.put(meF.getExchangeId(), meC);

        return meF;
    }

}
