/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2005-2006 EBM WebSourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id: RemoteDeliveryChannel.java,v 1.1 2007/06/11 13:34:07 lam Exp $
 * -------------------------------------------------------------------------
 */

package org.objectweb.petals.tools.rmi.server.remote.interfaces;

import java.rmi.Remote;
import java.rmi.RemoteException;

import javax.jbi.messaging.MessagingException;

/**
 * The delivery channel interface.
 * @author nsalatge
 *
 */
public interface RemoteDeliveryChannel extends Remote {

    /**
     * TODO accept check multi thread
     * Blocking call used to service a MessageExchange instance which has been
     * initiated by another component. This method supports concurrent
     * invocation for multi-threaded environments. This must be interruptable
     * (Thread.interrupt()).
     *
     * @return message exchange instance; must be non-null
     * @throws MessagingException
     *             failed to accept
     * @throws MessagingException
     *             when the blocked thread is interrupted
     * @throws RemoteException
     *             impossible to realize a remote access
     */
    javax.jbi.messaging.MessageExchange accept()
    throws MessagingException, RemoteException;

    /**
     * TODO accept check multi thread
     * Blocking call used to service a MessageExchange instance which has been
     * initiated by another component, within the given timeout period. This
     * method supports concurrent invocation for multi-threaded environments.
     *
     * @param timeoutMS
     *            timeout period, in milliseconds (0 means no timeout); must be
     *            greater than or equal to zero
     * @return message exchange instance, or <code>null</code> if timed out
     * @throws MessagingException
     *             failed to accept
     * @throws MessagingException
     *             when the blocked thread is interrupted
     * @throws RemoteException
     *        impossible to realize a remote access
     */
    javax.jbi.messaging.MessageExchange accept(long timeoutMS)
    throws MessagingException, RemoteException;

    /**
     * TODO close pending messages, remove endpoint entries ?
     * Closes the delivery channel, halting all message traffic.
     *
     * @throws MessagingException
     *             fatal error while closing channel
     * @throws RemoteException
     *             impossible to realize a remote access
     */
    void close() throws MessagingException, RemoteException;

    /**
     * Create a message exchange factory. This factory will create exchange
     * instances with all appropriate properties set to <code>null</code>.
     *
     * @return a message exchange factory; must be non-null
     * @throws RemoteException
     *             impossible to realize a remote access
     */
    org.objectweb.petals.tools.rmi.server.remote.interfaces.
    RemoteMessageExchangeFactory createExchangeFactory()
    throws RemoteException;

    /**
     * Create a message exchange factory for the given interface name.
     *
     * @param interfaceName
     *            name of the interface for which all exchanges created by the
     *            returned factory will be set for; may be null
     * @return an exchange factory that will create exchanges for the the given
     *         interface; must be non-null
     * @throws RemoteException
     *             impossible to realize a remote access
     */
    org.objectweb.petals.tools.rmi.server.remote.interfaces.
    RemoteMessageExchangeFactory createExchangeFactory(
            javax.xml.namespace.QName interfaceName) throws RemoteException;

    /**
     * Create a message exchange factory for the given endpoint.
     *
     * @param endpoint
     *            endpoint for which all exchanges created by the returned
     *            factory will be set for; may be null
     * @return an exchange factory that will create exchanges for the given
     *         endpoint; must be non-null
     * @throws RemoteException
     *             impossible to realize a remote access
     */
    org.objectweb.petals.tools.rmi.server.remote.interfaces.
    RemoteMessageExchangeFactory createExchangeFactory(
            javax.jbi.servicedesc.ServiceEndpoint endpoint) throws RemoteException;


    /**
     * Create a message exchange factory for the given service name.
     *
     * @param serviceName
     *            name of the service for which all exchanges created by the
     *            returned factory will be set for; may be null
     * @return an exchange factory that will create exchanges for the the given
     *         service; must be non-null
     * @throws RemoteException
     *             impossible to realize a remote access
     */
    org.objectweb.petals.tools.rmi.server.remote.interfaces.
    RemoteMessageExchangeFactory createExchangeFactoryForService(
            javax.xml.namespace.QName serviceName) throws RemoteException;

    /**
     * TODO send resolve jbi logical endpoint
     * Routes a MessageExchange instance through the Normalized Message Router
     * to the appropriate servicing component. This method supports concurrent
     * invocation for multi-threaded environments.
     * <p>
     * This is used not only to send the initial message in an exchange, but
     * also for the servicer to "return" the exchange with the appropriate
     * response (response, fault, or <code>ExchangeStatus</code>). In more
     * complex message exchange patterns, a single <code>MessageExchange</code>
     * can be sent back-and-forth via <code>send()</code> several times, but
     * always terminating with the MessageExchange instance being sent with a
     * terminal <code>ExchangeStatus</code>.
     *
     * @param exchange
     *            message exchange to send; must be non-null
     * @throws MessagingException
     *             unable to send exchange
     * @throws RemoteException
     *             impossible to realize a remote access
     */
    void send(javax.jbi.messaging.MessageExchange exchange)
    throws MessagingException, RemoteException;

    /**
     * TODO sendSync check multithread
     * The RMI interface of sendSync return a message exchange.
     * it is different of jbi interface because the message exchange in
     * input parameter is not a remote object, so, it cannot be setted in the method.
     * Routes a MessageExchange instance through the Normalized Message Router
     * to the appropriate servicing component, and blocks until the exchange is
     * returned (that is, the other participant sends the message exchange
     * back). This method supports concurrent invocation for multi-threaded
     * environments.
     * <p>
     * If the thread making this call is interrupted, the message exchange is
     * treated in the same fashion as a timed-out sendSync call; see
     * {@link RemoteDeliveryChannel#sendSync(MessageExchange, long)}.
     * <p>
     * Note that the "returned" message exchange (the instance returned by the
     * other participant in the exchange) is the same instance referred to by
     * the parameter <code>exchange</code>.
     *
     * @param exchange
     *            message exchange to send; must be non-null
     * @return <code>the message exchange</code> if the exchange has been returned, or
     *         <code>null</code>
     * @throws MessagingException
     *             unable to send exchange, or no response is expected from the
     *             <code>send()</code> operation (i.e., the
     *             <code>MessageExchange</code> is being used to convey an
     *             <code>ExchangeStatus</code>)
     * @throws MessagingException
     *             when the blocked thread is interrupted
     * @throws RemoteException
     *             impossible to realize a remote access
     */
    javax.jbi.messaging.MessageExchange
    sendSync(javax.jbi.messaging.MessageExchange exchange)
    throws MessagingException, RemoteException;

    /**
     * TODO sendSync check multithread
     * The RMI interface of sendSync return a message exchange.
     * it is different of jbi interface because the message exchange in
     * input parameter is not a remote object, so, it cannot be setted in the method.
     * Routes a MessageExchange instance through the Normalized Message Router
     * to the appropriate servicing component, and blocks until the exchange is
     * returned (that is, the other participant sends the message exchange
     * back), or the specified timeout interval elapses. This method supports
     * concurrent invocation for multi-threaded environments.
     * <p>
     * If the thread making this call is interrupted while this method is
     * blocked, the message exchange is treated as if the time out occurred.
     * <p>
     * If this method returns false (indicating that timeout occurred), the
     * message exchange must be marked by the implementation as being in the
     * {@link ExchangeStatus#ERROR} state. Attempts by the service provider to
     * send a MessageExchange in such an ERROR state must result in the send (or
     * sendSync) method called ending abruptly with an appropriate
     * MessagingException.
     * <p>
     * Note that the "returned" message exchange (the instance returned by the
     * other participant in the exchange) is the same instance referred to by
     * the parameter <code>exchange</code>.
     *
     * @param exchange
     *            message exchange to send; must be non-null
     * @param timeoutMS
     *            timeout period, in milliseconds (0 means no timeout); must be
     *            greater than or equal to zero
     * @return <code>the message exchange</code> if the exchange has been returned, or
     *         <code>null</code> if the method timed out while waiting
     * @throws MessagingException
     *             unable to send exchange, or no response is expected from the
     *             <code>send()</code> operation (i.e., the
     *             <code>MessageExchange</code> is being used to convey an
     *             <code>ExchangeStatus</code>)
     * @throws MessagingException
     *             when the blocked thread is interrupted
     * @throws RemoteException
     *             impossible to realize a remote access
     */
    javax.jbi.messaging.MessageExchange
    sendSync(javax.jbi.messaging.MessageExchange exchange,
            long timeoutMS) throws MessagingException, RemoteException;
}
