/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2005-2006 EBM WebSourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id: RemoteMessageExchangeFactory.java,v 1.1 2007/06/11 13:34:07 lam Exp $
 * -------------------------------------------------------------------------
 */

package org.objectweb.petals.tools.rmi.server.remote.interfaces;

import java.rmi.Remote;
import java.rmi.RemoteException;

import javax.jbi.messaging.MessagingException;

/**
 * the rmi interface of MessageExchangeFactory.
 * @author nsalatge
 *
 */
public interface RemoteMessageExchangeFactory extends Remote {


    /**
     * TODO createExchange find an endpoint for the service at the ME creation
     * Creates a new <code>MessageExchange</code> instance used to initiate a
     * service invocation.
     * <p>
     * JBI defines a set of four basic message exchange types, corresponding to
     * the predefined in-* WSDL 2.0 Message Exchange Patterns. Message exchanges
     * of any type are created using the <code>DeliveryChannel</code>.
     *
     * @param serviceName
     *            the name of the service to be invoked; must be non-null
     * @param operationName
     *            the name of the operation to be invoked; must be non-null and
     *            non-empty
     * @return new message exchange, initialized for invoking the given service
     *         and operation; must be non-null
     * @throws MessagingException
     *             if the given service or operation are not registered with the
     *             NMR.
     * @throws RemoteException
     *             impossible to realize a remote access
     * @throws MessagingException
     *             if the factory was created for a particular interface, and
     *             the given serviceName does not implement that interface.
     */
    javax.jbi.messaging.MessageExchange createExchange(
            javax.xml.namespace.QName serviceName,
            javax.xml.namespace.QName operationName)
    throws MessagingException, RemoteException;

    /**
     * Creates a new MessageExchange instance used to initiate a service
     * invocation. JBI defines a set of four fundamental message exchange types
     * which are created using binding and engine delivery channels. This base
     * met0hod is provided for extensibility, to satisfy the need for
     * vendor-specific message exchange patterns. The registration and
     * administration of these patterns is not addressed by JBI.
     *
     * @param pattern
     *            message exchange pattern; must be non-null and non-empty
     * @return new message exchange; must be non-null
     * @throws RemoteException
     *             impossible to realize a remote access
     * @throws MessagingException
     *             specified pattern is not registered to a message exchange
     *             type
     */
    javax.jbi.messaging.MessageExchange createExchange(
            java.net.URI pattern) throws MessagingException, RemoteException;

    /**
     * Convenience method that creates an In-Only message exchange.
     *
     * @return new InOnly message exchange; must be non-null
     * @throws RemoteException
     *             impossible to realize a remote access
     * @throws MessagingException
     *             failed to create exchange
     */
    javax.jbi.messaging.InOnly createInOnlyExchange()
    throws MessagingException, RemoteException;

    /**
     * Convenience method that creates an In-Optional-Out message exchange.
     *
     * @return new InOptionalOut message exchange; must be non-null
     * @throws RemoteException
     *             impossible to realize a remote access
     * @throws MessagingException
     *             failed to create exchange
     */
    javax.jbi.messaging.InOptionalOut createInOptionalOutExchange()
    throws MessagingException, RemoteException;

    /**
     * Convenience method that creates an In Out message exchange.
     *
     * @return new InOut message exchange; must be non-null
     * @throws RemoteException
     *             impossible to realize a remote access
     * @throws MessagingException
     *             failed to create exchange
     */
    javax.jbi.messaging.InOut createInOutExchange()
    throws MessagingException, RemoteException;

    /**
     * Convenience method that creates a Robust-In-Only message exchange.
     *
     * @return new RobustInOnly message exchange; must be non-null
     * @throws RemoteException
     *             impossible to realize a remote access
     * @throws MessagingException
     *             failed to create exchange
     */
    javax.jbi.messaging.RobustInOnly createRobustInOnlyExchange()
    throws MessagingException, RemoteException;


}
