/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.petals.tools.rmi.server.remote.implementations;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import java.util.logging.Logger;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.objectweb.petals.tools.rmi.server.remote.implementations.RemoteMessageExchangeFactoryImpl;
import org.objectweb.petals.tools.rmi.server.remote.interfaces.RemoteDeliveryChannel;
import org.objectweb.petals.tools.rmi.server.remote.interfaces.RemoteMessageExchangeFactory;
import org.objectweb.petals.tools.rmi.server.util.Convert;

public class RemoteDeliveryChannelImpl
extends UnicastRemoteObject
implements RemoteDeliveryChannel {
    private static final long serialVersionUID = -864958310638895099L;
    private static final String INTERNAL_ERROR_MSG = "This message exchange is not present in the HashMap\nEither the message exchange has been created by another message exchange factory\nor the message exchange is terminated (It has already been deleted of the HashMap)";
    private DeliveryChannel deliveryChannel;
    private ComponentContext componentContext;
    private Map<String, MessageExchange> messages;
    private Logger logger;

    public RemoteDeliveryChannelImpl(DeliveryChannel dl, ComponentContext c, Map<String, MessageExchange> msgs, Logger log) throws RemoteException {
        this.deliveryChannel = dl;
        this.messages = msgs;
        this.logger = log;
        this.componentContext = c;
    }

    @Override
    public MessageExchange accept() throws MessagingException, RemoteException {
        MessageExchange fake = null;
        MessageExchange concrete = null;
        try {
            concrete = this.deliveryChannel.accept();
        }
        catch (MessagingException e) {
            throw Convert.convertMessagingException(e);
        }
        if (concrete != null) {
            fake = Convert.convertConcreteMessageExchangeToFakeMessageExchange(concrete, concrete.getPattern());
            this.checkAndStorageMessageExchange(fake, concrete);
            this.getConcreteMessageOrRemoveIfNotActive(fake);
            this.logger.finest("Return the Accept() method, exchange Id : " + fake.getExchangeId());
        }
        return fake;
    }

    @Override
    public MessageExchange accept(long timeoutMS) throws MessagingException, RemoteException {
        MessageExchange fake = null;
        MessageExchange concrete = null;
        try {
            concrete = this.deliveryChannel.accept(timeoutMS);
        }
        catch (MessagingException e) {
            throw Convert.convertMessagingException(e);
        }
        if (concrete != null) {
            fake = Convert.convertConcreteMessageExchangeToFakeMessageExchange(concrete, concrete.getPattern());
            this.checkAndStorageMessageExchange(fake, concrete);
            this.getConcreteMessageOrRemoveIfNotActive(fake);
            this.logger.finest("Return the Accept(timeoutMS) method, exchange Id : " + fake.getExchangeId());
        }
        return fake;
    }

    @Override
    public void close() throws MessagingException, RemoteException {
        throw new NoSuchMethodError("Not implemented.");
    }

    @Override
    public RemoteMessageExchangeFactory createExchangeFactory() throws RemoteException {
        MessageExchangeFactory mef = this.deliveryChannel.createExchangeFactory();
        return new RemoteMessageExchangeFactoryImpl(this.messages, mef);
    }

    @Override
    public RemoteMessageExchangeFactory createExchangeFactory(QName interfaceName) throws RemoteException {
        MessageExchangeFactory mef = this.deliveryChannel.createExchangeFactory(interfaceName);
        return new RemoteMessageExchangeFactoryImpl(this.messages, mef);
    }

    @Override
    public RemoteMessageExchangeFactory createExchangeFactory(ServiceEndpoint endpoint) throws RemoteException {
        MessageExchangeFactory mef = this.deliveryChannel.createExchangeFactory(endpoint);
        return new RemoteMessageExchangeFactoryImpl(this.messages, mef);
    }

    @Override
    public RemoteMessageExchangeFactory createExchangeFactoryForService(QName serviceName) throws RemoteException {
        MessageExchangeFactory mef = this.deliveryChannel.createExchangeFactory(serviceName);
        return new RemoteMessageExchangeFactoryImpl(this.messages, mef);
    }

    @Override
    public void send(MessageExchange exchange) throws MessagingException, RemoteException {
        if (exchange == null) {
            throw new MessagingException("send: The MessageExchange is null");
        }
        if (!(exchange instanceof org.objectweb.petals.tools.rmi.common.serializable.MessageExchange)) {
            throw new MessagingException("send: Invalid object");
        }
        MessageExchange concrete = this.getConcreteMessageOrRemoveIfNotActive(exchange);
        if (concrete == null) {
            throw new MessagingException(INTERNAL_ERROR_MSG);
        }
        Convert.setFakeValueMEToConcreteValueME(this.componentContext, (org.objectweb.petals.tools.rmi.common.serializable.MessageExchange)exchange, concrete);
        try {
            this.deliveryChannel.send(concrete);
        }
        catch (MessagingException e) {
            this.messages.remove(exchange.getExchangeId());
            throw Convert.convertMessagingException(e);
        }
        catch (RuntimeException e) {
            this.messages.remove(exchange.getExchangeId());
            throw e;
        }
        this.getConcreteMessageOrRemoveIfNotActive(exchange);
        this.logger.finest("Return the send() method, exchange Id : " + exchange.getExchangeId());
    }

    @Override
    public MessageExchange sendSync(MessageExchange exchange) throws MessagingException, RemoteException {
        if (exchange == null) {
            throw new MessagingException("sendSync: The MessageExchange is null");
        }
        if (!(exchange instanceof org.objectweb.petals.tools.rmi.common.serializable.MessageExchange)) {
            throw new MessagingException("sendSync: Invalid object");
        }
        MessageExchange result = null;
        MessageExchange concrete = this.getConcreteMessageOrRemoveIfNotActive(exchange);
        if (concrete == null) {
            throw new MessagingException(INTERNAL_ERROR_MSG);
        }
        Convert.setFakeValueMEToConcreteValueME(this.componentContext, (org.objectweb.petals.tools.rmi.common.serializable.MessageExchange)exchange, concrete);
        try {
            boolean res = this.deliveryChannel.sendSync(concrete);
            if (res) {
                Convert.setConcreteValueMEToFakeValueME(this.componentContext, concrete, (org.objectweb.petals.tools.rmi.common.serializable.MessageExchange)exchange);
                result = exchange;
            } else {
                result = null;
            }
        }
        catch (MessagingException e) {
            this.messages.remove(exchange.getExchangeId());
            throw Convert.convertMessagingException(e);
        }
        catch (RuntimeException e) {
            this.messages.remove(exchange.getExchangeId());
            throw e;
        }
        concrete = this.getConcreteMessageOrRemoveIfNotActive(exchange);
        this.logger.finest("Return the sendSync() method, exchange Id : " + exchange.getExchangeId());
        return result;
    }

    @Override
    public MessageExchange sendSync(MessageExchange exchange, long timeoutMS) throws MessagingException, RemoteException {
        if (exchange == null) {
            throw new MessagingException("sendSync with timeout: The MessageExchange is null");
        }
        if (!(exchange instanceof org.objectweb.petals.tools.rmi.common.serializable.MessageExchange)) {
            throw new MessagingException("sendSync with timeout: Invalid object");
        }
        MessageExchange result = null;
        MessageExchange concrete = this.getConcreteMessageOrRemoveIfNotActive(exchange);
        if (concrete == null) {
            throw new MessagingException(INTERNAL_ERROR_MSG);
        }
        Convert.setFakeValueMEToConcreteValueME(this.componentContext, (org.objectweb.petals.tools.rmi.common.serializable.MessageExchange)exchange, concrete);
        try {
            boolean res = this.deliveryChannel.sendSync(concrete, timeoutMS);
            if (res) {
                Convert.setConcreteValueMEToFakeValueME(this.componentContext, concrete, (org.objectweb.petals.tools.rmi.common.serializable.MessageExchange)exchange);
                result = exchange;
            } else {
                result = null;
            }
        }
        catch (MessagingException e) {
            this.messages.remove(exchange.getExchangeId());
            throw Convert.convertMessagingException(e);
        }
        catch (RuntimeException e) {
            this.messages.remove(exchange.getExchangeId());
            throw e;
        }
        concrete = this.getConcreteMessageOrRemoveIfNotActive(exchange);
        this.logger.finest("Return the sendSync(timeoutMS) method, exchange Id : " + exchange.getExchangeId());
        return result;
    }

    private void checkAndStorageMessageExchange(MessageExchange fake, MessageExchange concrete) {
        if (concrete.getStatus() == ExchangeStatus.ACTIVE) {
            this.messages.put(fake.getExchangeId(), concrete);
        }
    }

    private MessageExchange getConcreteMessageOrRemoveIfNotActive(MessageExchange fake) {
        MessageExchange concrete = null;
        concrete = fake.getStatus() != ExchangeStatus.ACTIVE ? this.messages.remove(fake.getExchangeId()) : this.messages.get(fake.getExchangeId());
        return concrete;
    }
}

