/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.petals.tools.rmi.server.remote.implementations;

import java.net.URI;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.RobustInOnly;
import javax.xml.namespace.QName;
import org.objectweb.petals.tools.rmi.server.remote.interfaces.RemoteMessageExchangeFactory;
import org.objectweb.petals.tools.rmi.server.util.Convert;

public class RemoteMessageExchangeFactoryImpl
extends UnicastRemoteObject
implements RemoteMessageExchangeFactory {
    private static final long serialVersionUID = -7802199904640493500L;
    private MessageExchangeFactory concreteMef;
    private Map<String, MessageExchange> messages;

    public RemoteMessageExchangeFactoryImpl(Map<String, MessageExchange> msgs, MessageExchangeFactory concreteMef) throws RemoteException {
        this.concreteMef = concreteMef;
        this.messages = msgs;
    }

    @Override
    public MessageExchange createExchange(QName serviceName, QName operationName) throws MessagingException {
        MessageExchange meC = this.concreteMef.createExchange(serviceName, operationName);
        MessageExchange meF = Convert.convertConcreteMessageExchangeToFakeMessageExchange(meC, null);
        ((org.objectweb.petals.tools.rmi.common.serializable.MessageExchange)meF).setRole(meC.getRole());
        this.messages.put(meF.getExchangeId(), meC);
        return meF;
    }

    @Override
    public MessageExchange createExchange(URI pattern) throws MessagingException {
        MessageExchange meC = this.concreteMef.createExchange(pattern);
        MessageExchange meF = Convert.convertConcreteMessageExchangeToFakeMessageExchange(meC, null);
        ((org.objectweb.petals.tools.rmi.common.serializable.MessageExchange)meF).setRole(meC.getRole());
        this.messages.put(meF.getExchangeId(), meC);
        return meF;
    }

    @Override
    public InOnly createInOnlyExchange() throws MessagingException {
        InOnly meC = this.concreteMef.createInOnlyExchange();
        InOnly meF = (InOnly)Convert.convertConcreteMessageExchangeToFakeMessageExchange((MessageExchange)meC, Convert.IN_ONLY_PATTERN);
        ((org.objectweb.petals.tools.rmi.common.serializable.MessageExchange)meF).setRole(meC.getRole());
        this.messages.put(meF.getExchangeId(), (MessageExchange)meC);
        return meF;
    }

    @Override
    public InOptionalOut createInOptionalOutExchange() throws MessagingException {
        InOptionalOut meC = this.concreteMef.createInOptionalOutExchange();
        InOptionalOut meF = (InOptionalOut)Convert.convertConcreteMessageExchangeToFakeMessageExchange((MessageExchange)meC, Convert.IN_OPTIONAL_OUT_PATTERN);
        ((org.objectweb.petals.tools.rmi.common.serializable.MessageExchange)meF).setRole(meC.getRole());
        this.messages.put(meF.getExchangeId(), (MessageExchange)meC);
        return meF;
    }

    @Override
    public InOut createInOutExchange() throws MessagingException {
        InOut meC = this.concreteMef.createInOutExchange();
        InOut meF = (InOut)Convert.convertConcreteMessageExchangeToFakeMessageExchange((MessageExchange)meC, Convert.IN_OUT_PATTERN);
        ((org.objectweb.petals.tools.rmi.common.serializable.MessageExchange)meF).setRole(meC.getRole());
        this.messages.put(meF.getExchangeId(), (MessageExchange)meC);
        return meF;
    }

    @Override
    public RobustInOnly createRobustInOnlyExchange() throws MessagingException {
        RobustInOnly meC = this.concreteMef.createRobustInOnlyExchange();
        RobustInOnly meF = (RobustInOnly)Convert.convertConcreteMessageExchangeToFakeMessageExchange((MessageExchange)meC, Convert.ROBUST_IN_ONLY_PATTERN);
        ((org.objectweb.petals.tools.rmi.common.serializable.MessageExchange)meF).setRole(meC.getRole());
        this.messages.put(meF.getExchangeId(), (MessageExchange)meC);
        return meF;
    }
}

