/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.client;

import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.RSADecrypter;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCAccessTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.util.DefaultJWTDecoder;
import com.nimbusds.openid.connect.sdk.util.DefaultResourceRetriever;
import java.net.URI;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Mechanism;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.pac4j.oidc.profile.OidcProfile;

public class OidcClient
extends BaseClient<OidcCredentials, OidcProfile> {
    private static final String USE_NONCE_PARAM = "useNonce";
    private static final String STATE_ATTRIBUTE = "oidcStateAttribute";
    private static final String NONCE_ATTRIBUTE = "oidcNonceAttribute";
    private String clientId;
    private String secret;
    private URI redirectURI;
    private String discoveryURI;
    private DefaultJWTDecoder jwtDecoder;
    private OIDCProviderMetadata oidcProvider;
    private Map<String, String> authParams;
    private final Map<String, String> customParams = new HashMap<String, String>();
    private ClientAuthentication clientAuthentication;
    private ClientID _clientID;
    private Secret _secret;

    public Mechanism getMechanism() {
        return Mechanism.OPENID_CONNECT_PROTOCOL;
    }

    public void setDiscoveryURI(String discoveryURI) {
        this.discoveryURI = discoveryURI;
    }

    public void setClientID(String clientID) {
        this.clientId = clientID;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void addCustomParam(String key, String value) {
        this.customParams.put(key, value);
    }

    protected void internalInit() {
        JWKSet jwkSet;
        CommonHelper.assertNotBlank((String)this.clientId, (String)"clientID cannot be blank");
        CommonHelper.assertNotBlank((String)this.secret, (String)"secret cannot be blank");
        CommonHelper.assertNotBlank((String)this.discoveryURI, (String)"discoveryURI cannot be blank");
        this.authParams = new HashMap<String, String>();
        this.authParams.put("scope", "openid profile email");
        this.authParams.put("response_type", "code");
        this.authParams.put("redirect_uri", this.getCallbackUrl());
        this.authParams.putAll(this.customParams);
        this.authParams.put("client_id", this.clientId);
        this.authParams.put("client_secret", this.secret);
        this._clientID = new ClientID(this.clientId);
        this._secret = new Secret(this.secret);
        try {
            DefaultResourceRetriever resourceRetriever = new DefaultResourceRetriever();
            this.oidcProvider = OIDCProviderMetadata.parse((String)resourceRetriever.retrieveResource(new URL(this.discoveryURI)).getContent());
            jwkSet = JWKSet.parse((String)resourceRetriever.retrieveResource(this.oidcProvider.getJWKSetURI().toURL()).getContent());
            this.redirectURI = new URI(this.getCallbackUrl());
        }
        catch (Exception e) {
            throw new TechnicalException((Throwable)e);
        }
        ClientAuthenticationMethod method = this.getClientAuthenticationMethod();
        this.clientAuthentication = this.getClientAuthentication(method);
        this.jwtDecoder = new DefaultJWTDecoder();
        this.initJwtDecoder(this.jwtDecoder, jwkSet);
    }

    protected BaseClient<OidcCredentials, OidcProfile> newClient() {
        OidcClient client = new OidcClient();
        client.setClientID(this.clientId);
        client.setSecret(this.secret);
        client.setDiscoveryURI(this.discoveryURI);
        client.setAuthParams(this.authParams);
        return client;
    }

    protected boolean isDirectRedirection() {
        return true;
    }

    protected RedirectAction retrieveRedirectAction(WebContext context) {
        String queryString;
        HashMap<String, String> params = new HashMap<String, String>(this.authParams);
        State state = new State();
        params.put("state", state.getValue());
        context.setSessionAttribute(STATE_ATTRIBUTE, (Object)state);
        if (this.useNonce()) {
            Nonce nonce = new Nonce();
            params.put("nonce", nonce.getValue());
            context.setSessionAttribute(NONCE_ATTRIBUTE, (Object)nonce.getValue());
        }
        try {
            queryString = AuthenticationRequest.parse(params).toQueryString();
        }
        catch (Exception e) {
            throw new TechnicalException((Throwable)e);
        }
        String location = this.oidcProvider.getAuthorizationEndpointURI().toString() + "?" + queryString;
        logger.debug("Authentication request url : {}", (Object)location);
        return RedirectAction.redirect((String)location);
    }

    protected OidcCredentials retrieveCredentials(WebContext context) throws RequiresHttpAction {
        AuthenticationResponse response;
        Map<String, String> parameters = this.toSingleParameter(context.getRequestParameters());
        try {
            response = AuthenticationResponseParser.parse((URI)this.redirectURI, parameters);
        }
        catch (ParseException e) {
            throw new TechnicalException((Throwable)e);
        }
        if (response instanceof AuthenticationErrorResponse) {
            logger.error("Bad authentication response, error={}", (Object)((AuthenticationErrorResponse)response).getErrorObject());
            return null;
        }
        logger.debug("Authentication response successful, get authorization code");
        AuthenticationSuccessResponse successResponse = (AuthenticationSuccessResponse)response;
        if (!successResponse.getState().equals(context.getSessionAttribute(STATE_ATTRIBUTE))) {
            throw new TechnicalException("State parameter is different from the one sent in authentication request. Session expired or possible threat of cross-site request forgery");
        }
        AuthorizationCode code = successResponse.getAuthorizationCode();
        return new OidcCredentials(code);
    }

    protected OidcProfile retrieveUserProfile(OidcCredentials credentials, WebContext context) {
        TokenRequest request = new TokenRequest(this.oidcProvider.getTokenEndpointURI(), this.clientAuthentication, (AuthorizationGrant)new AuthorizationCodeGrant(credentials.getCode(), this.redirectURI, this.clientAuthentication.getClientID()));
        try {
            String nonce;
            HTTPResponse httpResponse = request.toHTTPRequest().send();
            logger.debug("Token response: status={}, content={}", (Object)httpResponse.getStatusCode(), (Object)httpResponse.getContent());
            TokenResponse response = OIDCTokenResponseParser.parse((HTTPResponse)httpResponse);
            if (response instanceof TokenErrorResponse) {
                logger.error("Bad token response, error={}", (Object)((TokenErrorResponse)response).getErrorObject());
                return null;
            }
            logger.debug("Token response successful");
            OIDCAccessTokenResponse tokenSuccessResponse = (OIDCAccessTokenResponse)response;
            BearerAccessToken accessToken = (BearerAccessToken)tokenSuccessResponse.getAccessToken();
            UserInfo userInfo = null;
            if (this.oidcProvider.getUserInfoEndpointURI() != null) {
                UserInfoRequest userInfoRequest = new UserInfoRequest(this.oidcProvider.getUserInfoEndpointURI(), accessToken);
                httpResponse = userInfoRequest.toHTTPRequest().send();
                logger.debug("Token response: status={}, content={}", (Object)httpResponse.getStatusCode(), (Object)httpResponse.getContent());
                UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)httpResponse);
                if (userInfoResponse instanceof UserInfoErrorResponse) {
                    logger.error("Bad User Info response, error={}", (Object)((UserInfoErrorResponse)userInfoResponse).getErrorObject());
                } else {
                    UserInfoSuccessResponse userInfoSuccessResponse = (UserInfoSuccessResponse)userInfoResponse;
                    userInfo = userInfoSuccessResponse.getUserInfo();
                }
            }
            ReadOnlyJWTClaimsSet claimsSet = this.jwtDecoder.decodeJWT(tokenSuccessResponse.getIDToken());
            if (this.useNonce() && ((nonce = claimsSet.getStringClaim("nonce")) == null || !nonce.equals(context.getSessionAttribute(NONCE_ATTRIBUTE)))) {
                throw new TechnicalException("A nonce was sent in the authentication request but it is missing or different in the ID Token. Session expired or possible threat of cross-site request forgery");
            }
            OidcProfile profile = new OidcProfile(accessToken);
            profile.setId(claimsSet.getSubject());
            profile.addAttributes(claimsSet.getAllClaims());
            profile.addAttributes(userInfo.toJWTClaimsSet().getAllClaims());
            return profile;
        }
        catch (Exception e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    private ClientAuthenticationMethod getClientAuthenticationMethod() {
        return this.oidcProvider.getTokenEndpointAuthMethods() != null && this.oidcProvider.getTokenEndpointAuthMethods().size() > 0 ? (ClientAuthenticationMethod)this.oidcProvider.getTokenEndpointAuthMethods().get(0) : ClientAuthenticationMethod.getDefault();
    }

    private boolean useNonce() {
        return Boolean.parseBoolean(this.authParams.get(USE_NONCE_PARAM));
    }

    private void initJwtDecoder(DefaultJWTDecoder jwtDecoder, JWKSet jwkSet) {
        try {
            for (JWK key : jwkSet.getKeys()) {
                if (key.getKeyUse() == KeyUse.SIGNATURE) {
                    jwtDecoder.addJWSVerifier(this.getVerifier(key));
                    continue;
                }
                if (key.getKeyUse() != KeyUse.ENCRYPTION) continue;
                jwtDecoder.addJWEDecrypter(this.getDecrypter(key));
            }
        }
        catch (Exception e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    private JWEDecrypter getDecrypter(JWK key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (key instanceof RSAKey) {
            return new RSADecrypter(((RSAKey)key).toRSAPrivateKey());
        }
        return null;
    }

    private JWSVerifier getVerifier(JWK key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (key instanceof RSAKey) {
            return new RSASSAVerifier(((RSAKey)key).toRSAPublicKey());
        }
        if (key instanceof ECKey) {
            ECKey ecKey = (ECKey)key;
            return new ECDSAVerifier(ecKey.getX().decodeToBigInteger(), ecKey.getY().decodeToBigInteger());
        }
        return null;
    }

    private ClientAuthentication getClientAuthentication(ClientAuthenticationMethod method) {
        if (ClientAuthenticationMethod.CLIENT_SECRET_POST.equals((Object)method)) {
            return new ClientSecretPost(this._clientID, this._secret);
        }
        if (ClientAuthenticationMethod.CLIENT_SECRET_BASIC.equals((Object)method)) {
            return new ClientSecretBasic(this._clientID, this._secret);
        }
        return null;
    }

    private Map<String, String> toSingleParameter(Map<String, String[]> requestParameters) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : requestParameters.entrySet()) {
            map.put(entry.getKey(), entry.getValue()[0]);
        }
        return map;
    }

    private void setAuthParams(Map<String, String> authParams) {
        this.authParams = authParams;
    }
}

