/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.profile;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.text.ParseException;
import java.util.List;
import org.pac4j.core.profile.CommonProfile;

public class OidcProfile
extends CommonProfile
implements Externalizable {
    private static final long serialVersionUID = -52855988661742374L;
    private static final transient String ACCESS_TOKEN = "access_token";
    private static final transient String ID_TOKEN = "id_token";
    private static final transient String REFRESH_TOKEN = "refresh_token";

    public void setAccessToken(BearerAccessToken accessToken) {
        this.addAttribute(ACCESS_TOKEN, accessToken);
    }

    public BearerAccessToken getAccessToken() {
        return (BearerAccessToken)this.getAttribute(ACCESS_TOKEN);
    }

    public String getIdTokenString() {
        return (String)this.getAttribute(ID_TOKEN);
    }

    public void setIdTokenString(String idTokenString) {
        this.addAttribute(ID_TOKEN, idTokenString);
    }

    public JWT getIdToken() throws ParseException {
        if (this.getIdTokenString() != null) {
            return JWTParser.parse((String)this.getIdTokenString());
        }
        return null;
    }

    public String getRefreshTokenString() {
        return (String)this.getAttribute(REFRESH_TOKEN);
    }

    public void setRefreshTokenString(String refreshTokenString) {
        this.addAttribute(REFRESH_TOKEN, refreshTokenString);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        BearerAccessTokenBean bean = null;
        if (this.getAccessToken() != null) {
            bean = BearerAccessTokenBean.toBean(this.getAccessToken());
        }
        out.writeObject(bean);
        out.writeObject(this.getIdTokenString());
        out.writeObject(this.getRefreshTokenString());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        BearerAccessTokenBean bean = (BearerAccessTokenBean)in.readObject();
        if (bean != null) {
            this.setAccessToken(BearerAccessTokenBean.fromBean(bean));
        }
        this.setIdTokenString((String)in.readObject());
        this.setRefreshTokenString((String)in.readObject());
    }

    public void clearSensitiveData() {
        this.removeAttribute(ACCESS_TOKEN);
        this.removeAttribute(ID_TOKEN);
        this.removeAttribute(REFRESH_TOKEN);
    }

    private static class BearerAccessTokenBean
    implements Serializable {
        private static final long serialVersionUID = 7726472295622796149L;
        private String value;
        private long lifetime;
        private List<String> scope;

        public BearerAccessTokenBean(String value, long lifetime, List<String> scope) {
            this.value = value;
            this.lifetime = lifetime;
            this.scope = scope;
        }

        public static BearerAccessTokenBean toBean(BearerAccessToken token) {
            Scope scope = token.getScope();
            if (scope != null) {
                return new BearerAccessTokenBean(token.getValue(), token.getLifetime(), scope.toStringList());
            }
            return new BearerAccessTokenBean(token.getValue(), token.getLifetime(), null);
        }

        public static BearerAccessToken fromBean(BearerAccessTokenBean token) {
            return new BearerAccessToken(token.value, token.lifetime, Scope.parse(token.scope));
        }
    }
}

