/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.config;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;

public class OidcConfiguration
extends InitializableWebObject {
    public static final String SCOPE = "scope";
    public static final String RESPONSE_TYPE = "response_type";
    public static final String RESPONSE_MODE = "response_mode";
    public static final String REDIRECT_URI = "redirect_uri";
    public static final String CLIENT_ID = "client_id";
    public static final String STATE = "state";
    public static final String NONCE = "nonce";
    public static final String STATE_SESSION_ATTRIBUTE = "oidcStateAttribute";
    public static final String NONCE_SESSION_ATTRIBUTE = "oidcNonceAttribute";
    public static final int DEFAULT_MAX_CLOCK_SKEW = 30;
    private String clientId;
    private String secret;
    private String discoveryURI;
    private String scope;
    private Map<String, String> customParams = new HashMap<String, String>();
    private ClientAuthenticationMethod clientAuthenticationMethod;
    private boolean useNonce;
    private JWSAlgorithm preferredJwsAlgorithm;
    private int maxClockSkew = 30;
    private int connectTimeout = 500;
    private int readTimeout = 5000;
    private ResourceRetriever resourceRetriever;
    private OIDCProviderMetadata providerMetadata;
    private String callbackUrl;
    private String responseType;
    private String responseMode;

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotBlank((String)"clientId", (String)this.clientId);
        CommonHelper.assertNotBlank((String)"secret", (String)this.secret);
        if (this.discoveryURI == null && this.providerMetadata == null) {
            throw new TechnicalException("You must define either the discovery URL or directly the provider metadata");
        }
        if (this.resourceRetriever == null) {
            this.resourceRetriever = new DefaultResourceRetriever(this.connectTimeout, this.readTimeout);
        }
        if (this.providerMetadata == null) {
            CommonHelper.assertNotBlank((String)"discoveryURI", (String)this.discoveryURI);
            try {
                this.providerMetadata = OIDCProviderMetadata.parse((String)this.resourceRetriever.retrieveResource(new URL(this.discoveryURI)).getContent());
            }
            catch (ParseException | IOException e) {
                throw new TechnicalException(e);
            }
        }
    }

    public OIDCProviderMetadata getProviderMetadata() {
        return this.providerMetadata;
    }

    public void setProviderMetadata(OIDCProviderMetadata providerMetadata) {
        this.providerMetadata = providerMetadata;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getDiscoveryURI() {
        return this.discoveryURI;
    }

    public void setDiscoveryURI(String discoveryURI) {
        if (this.discoveryURI == null) {
            this.discoveryURI = discoveryURI;
        }
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Map<String, String> getCustomParams() {
        return this.customParams;
    }

    public void setCustomParams(Map<String, String> customParams) {
        CommonHelper.assertNotNull((String)"customParams", customParams);
        this.customParams = customParams;
    }

    public void addCustomParam(String key, String value) {
        this.customParams.put(key, value);
    }

    public ClientAuthenticationMethod getClientAuthenticationMethod() {
        return this.clientAuthenticationMethod;
    }

    public void setClientAuthenticationMethod(ClientAuthenticationMethod clientAuthenticationMethod) {
        this.clientAuthenticationMethod = clientAuthenticationMethod;
    }

    public boolean isUseNonce() {
        return this.useNonce;
    }

    public void setUseNonce(boolean useNonce) {
        this.useNonce = useNonce;
    }

    public JWSAlgorithm getPreferredJwsAlgorithm() {
        return this.preferredJwsAlgorithm;
    }

    public void setPreferredJwsAlgorithm(JWSAlgorithm preferredJwsAlgorithm) {
        this.preferredJwsAlgorithm = preferredJwsAlgorithm;
    }

    public int getMaxClockSkew() {
        return this.maxClockSkew;
    }

    public void setMaxClockSkew(int maxClockSkew) {
        this.maxClockSkew = maxClockSkew;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public ResourceRetriever getResourceRetriever() {
        return this.resourceRetriever;
    }

    public void setResourceRetriever(ResourceRetriever resourceRetriever) {
        if (this.resourceRetriever == null) {
            this.resourceRetriever = resourceRetriever;
        }
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getResponseMode() {
        return this.responseMode;
    }

    public void setResponseMode(String responseMode) {
        this.responseMode = responseMode;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"clientId", this.clientId, "discoveryURI", this.discoveryURI, SCOPE, this.scope, "customParams", this.customParams, "clientAuthenticationMethod", this.clientAuthenticationMethod, "useNonce", this.useNonce, "preferredJwsAlgorithm", this.preferredJwsAlgorithm, "maxClockSkew", this.maxClockSkew, "connectTimeout", this.connectTimeout, "readTimeout", this.readTimeout, "resourceRetriever", this.resourceRetriever, "callbackUrl", this.callbackUrl, "responseType", this.responseType, "responseMode", this.responseMode});
    }
}

