/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.profile;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.AttributesDefinition;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.oidc.profile.OidcAttributesDefinition;

public class OidcProfile
extends CommonProfile {
    private static final long serialVersionUID = -52855988661742374L;
    private static final transient AttributesDefinition ATTRIBUTES_DEFINITION = new OidcAttributesDefinition();

    public AttributesDefinition getAttributesDefinition() {
        return ATTRIBUTES_DEFINITION;
    }

    public String getFirstName() {
        return (String)this.getAttribute("given_name");
    }

    public String getMiddleName() {
        return (String)this.getAttribute("middle_name");
    }

    public String getDisplayName() {
        return (String)this.getAttribute("name");
    }

    public String getNickname() {
        return (String)this.getAttribute("nickname");
    }

    public String getUsername() {
        return (String)this.getAttribute("preferred_username");
    }

    public String getPictureUrl() {
        return (String)this.getAttribute("picture");
    }

    public String getProfileUrl() {
        return (String)this.getAttribute("profile");
    }

    public String getLocation() {
        return (String)this.getAttribute("zoneinfo");
    }

    public Boolean getEmailVerified() {
        return (Boolean)this.getAttribute("email_verified");
    }

    public String getPhoneNumber() {
        return (String)this.getAttribute("phone_number");
    }

    public Boolean getPhoneNumberVerified() {
        return (Boolean)this.getAttribute("phone_number_verified");
    }

    public Date getUpatedAt() {
        return (Date)this.getAttribute("updated_at");
    }

    public String getIssuer() {
        return (String)this.getAttribute("iss");
    }

    public List<String> getAudience() {
        Object audience = this.getAttribute("aud");
        if (audience instanceof String) {
            return Collections.singletonList((String)audience);
        }
        return (List)audience;
    }

    public Date getExpirationDate() {
        return (Date)this.getAttribute("exp");
    }

    public Date getIssuedAt() {
        return (Date)this.getAttribute("iat");
    }

    public Date getNbf() {
        return (Date)this.getAttribute("nbf");
    }

    public Date getAuthTime() {
        return (Date)this.getAttribute("auth_time");
    }

    public String getNonce() {
        return (String)this.getAttribute("nonce");
    }

    public String getAcr() {
        return (String)this.getAttribute("acr");
    }

    public Object getAmr() {
        return this.getAttribute("amr");
    }

    public String getAzp() {
        return (String)this.getAttribute("azp");
    }

    public void setAccessToken(AccessToken accessToken) {
        this.addAttribute("access_token", accessToken);
    }

    public AccessToken getAccessToken() {
        return (AccessToken)this.getAttribute("access_token");
    }

    public String getIdTokenString() {
        return (String)this.getAttribute("id_token");
    }

    public void setIdTokenString(String idToken) {
        this.addAttribute("id_token", idToken);
    }

    public JWT getIdToken() {
        try {
            return JWTParser.parse((String)this.getIdTokenString());
        }
        catch (ParseException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    public RefreshToken getRefreshToken() {
        return (RefreshToken)this.getAttribute("refresh_token");
    }

    public void setRefreshToken(RefreshToken refreshToken) {
        this.addAttribute("refresh_token", refreshToken);
    }

    public void clearSensitiveData() {
        this.removeAttribute("access_token");
        this.removeAttribute("id_token");
        this.removeAttribute("refresh_token");
    }
}

