/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.logout;

import com.nimbusds.jwt.JWT;
import com.nimbusds.openid.connect.sdk.LogoutRequest;
import java.net.URI;
import java.net.URISyntaxException;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.ajax.AjaxRequestResolver;
import org.pac4j.core.http.ajax.DefaultAjaxRequestResolver;
import org.pac4j.core.logout.LogoutActionBuilder;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.profile.OidcProfile;

public class OidcLogoutActionBuilder<U extends OidcProfile>
implements LogoutActionBuilder<U> {
    protected OidcConfiguration configuration;
    private AjaxRequestResolver ajaxRequestResolver = new DefaultAjaxRequestResolver();

    public OidcLogoutActionBuilder(OidcConfiguration configuration) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        this.configuration = configuration;
    }

    public RedirectAction getLogoutAction(WebContext context, U currentProfile, String targetUrl) {
        String logoutUrl = this.configuration.findLogoutUrl();
        if (CommonHelper.isNotBlank((String)logoutUrl)) {
            try {
                URI endSessionEndpoint = new URI(logoutUrl);
                JWT idToken = ((OidcProfile)((Object)currentProfile)).getIdToken();
                LogoutRequest logoutRequest = CommonHelper.isNotBlank((String)targetUrl) ? new LogoutRequest(endSessionEndpoint, idToken, new URI(targetUrl), null) : new LogoutRequest(endSessionEndpoint, idToken);
                if (this.ajaxRequestResolver.isAjax(context)) {
                    context.getSessionStore().set(context, "pac4jRequestedUrl", (Object)"");
                    context.setResponseHeader("Location", logoutRequest.toURI().toString());
                    throw HttpAction.status((int)403, (WebContext)context);
                }
                return RedirectAction.redirect((String)logoutRequest.toURI().toString());
            }
            catch (URISyntaxException e) {
                throw new TechnicalException((Throwable)e);
            }
        }
        return null;
    }

    public AjaxRequestResolver getAjaxRequestResolver() {
        return this.ajaxRequestResolver;
    }

    public void setAjaxRequestResolver(AjaxRequestResolver ajaxRequestResolver) {
        CommonHelper.assertNotNull((String)"ajaxRequestResolver", (Object)ajaxRequestResolver);
        this.ajaxRequestResolver = ajaxRequestResolver;
    }
}

