/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.redirect;

import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.redirect.RedirectActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcRedirectActionBuilder
implements RedirectActionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(OidcRedirectActionBuilder.class);
    protected OidcConfiguration configuration;
    protected OidcClient client;
    private Map<String, String> authParams;

    public OidcRedirectActionBuilder(OidcConfiguration configuration, OidcClient client) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        CommonHelper.assertNotNull((String)"client", (Object)((Object)client));
        this.configuration = configuration;
        this.client = client;
        this.authParams = new HashMap<String, String>();
        String scope = configuration.getScope();
        if (CommonHelper.isNotBlank((String)scope)) {
            this.authParams.put("scope", scope);
        } else {
            this.authParams.put("scope", "openid profile email");
        }
        this.authParams.put("response_type", configuration.getResponseType());
        String responseMode = configuration.getResponseMode();
        if (CommonHelper.isNotBlank((String)responseMode)) {
            this.authParams.put("response_mode", responseMode);
        }
        this.authParams.putAll(configuration.getCustomParams());
        this.authParams.put("client_id", configuration.getClientId());
    }

    public RedirectAction redirect(WebContext context) {
        Map<String, String> params = this.buildParams();
        String computedCallbackUrl = this.client.computeFinalCallbackUrl(context);
        params.put("redirect_uri", computedCallbackUrl);
        this.addStateAndNonceParameters(context, params);
        if (this.configuration.getMaxAge() != null) {
            params.put("max_age", this.configuration.getMaxAge().toString());
        }
        String location = this.buildAuthenticationRequestUrl(params);
        logger.debug("Authentication request url: {}", (Object)location);
        return RedirectAction.redirect((String)location);
    }

    protected Map<String, String> buildParams() {
        return new HashMap<String, String>(this.authParams);
    }

    protected void addStateAndNonceParameters(WebContext context, Map<String, String> params) {
        State state = this.configuration.isWithState() ? new State(this.configuration.getStateGenerator().generateState(context)) : new State();
        params.put("state", state.getValue());
        context.getSessionStore().set(context, "oidcStateAttribute", (Object)state);
        if (this.configuration.isUseNonce()) {
            Nonce nonce = new Nonce();
            params.put("nonce", nonce.getValue());
            context.getSessionStore().set(context, "oidcNonceAttribute", (Object)nonce.getValue());
        }
    }

    protected String buildAuthenticationRequestUrl(Map<String, String> params) {
        String queryString;
        try {
            queryString = AuthenticationRequest.parse(params.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.singletonList((String)e.getValue())))).toQueryString();
        }
        catch (Exception e2) {
            throw new TechnicalException((Throwable)e2);
        }
        return this.configuration.getProviderMetadata().getAuthorizationEndpointURI().toString() + "?" + queryString;
    }
}

