/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.config;

import java.util.Map;
import org.pac4j.core.context.WebContext;
import org.pac4j.oidc.config.OidcConfiguration;

public class OidcConfigurationContext {
    private final WebContext context;
    private final OidcConfiguration configuration;

    public OidcConfigurationContext(WebContext webContext, OidcConfiguration oidcConfiguration) {
        this.context = webContext;
        this.configuration = oidcConfiguration;
    }

    public Integer getMaxAge() {
        return this.context.getRequestAttribute("max_age").orElse(this.configuration.getMaxAge());
    }

    public Boolean isForceAuthn() {
        return this.context.getRequestAttribute("ForceAuthn").isPresent();
    }

    public Boolean isPassive() {
        return this.context.getRequestAttribute("Passive").isPresent();
    }

    public String getScope() {
        return this.context.getRequestAttribute("scope").orElse("openid profile email");
    }

    public String getResponseType() {
        return this.context.getRequestAttribute("response_type").orElse(this.configuration.getResponseType());
    }

    public String getResponseMode() {
        return this.context.getRequestAttribute("response_mode").orElse(this.configuration.getResponseMode());
    }

    public Map<String, String> getCustomParams() {
        return this.context.getRequestAttribute("custom_params").orElse(this.configuration.getCustomParams());
    }

    public OidcConfiguration getConfiguration() {
        return this.configuration;
    }
}

