/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.authorization.generator;

import com.nimbusds.jose.shaded.json.JSONArray;
import com.nimbusds.jose.shaded.json.JSONObject;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.util.Map;
import java.util.Optional;
import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.oidc.profile.keycloak.KeycloakOidcProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakRolesAuthorizationGenerator
implements AuthorizationGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeycloakRolesAuthorizationGenerator.class);
    private String clientId;

    public KeycloakRolesAuthorizationGenerator() {
    }

    public KeycloakRolesAuthorizationGenerator(String clientId) {
        this.clientId = clientId;
    }

    public Optional<UserProfile> generate(WebContext context, SessionStore sessionStore, UserProfile profile) {
        if (profile instanceof KeycloakOidcProfile) {
            try {
                JSONArray clientRolesJsonArray;
                JSONObject clientRolesJsonObject;
                Map resourceAccess;
                JSONArray realmRolesJsonArray;
                SignedJWT jwt = SignedJWT.parse((String)((KeycloakOidcProfile)profile).getAccessToken().getValue());
                JWTClaimsSet jwtClaimsSet = jwt.getJWTClaimsSet();
                Map realmRolesJsonObject = jwtClaimsSet.getJSONObjectClaim("realm_access");
                if (realmRolesJsonObject != null && (realmRolesJsonArray = (JSONArray)realmRolesJsonObject.get("roles")) != null) {
                    realmRolesJsonArray.forEach(role -> profile.addRole((String)role));
                }
                if (this.clientId != null && (resourceAccess = jwtClaimsSet.getJSONObjectClaim("resource_access")) != null && (clientRolesJsonObject = (JSONObject)resourceAccess.get(this.clientId)) != null && (clientRolesJsonArray = (JSONArray)clientRolesJsonObject.get((Object)"roles")) != null) {
                    clientRolesJsonArray.forEach(role -> profile.addRole((String)role));
                }
            }
            catch (Exception e) {
                LOGGER.warn("Cannot parse Keycloak roles", (Throwable)e);
            }
        }
        return Optional.of(profile);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }
}

